static char rcsid[] = "@(#)$Id: partialcmd.c,v 1.9 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
static struct elm_commands *give_partial_common_commands P_((void)); 
static struct elm_commands *give_partial_common_commands() 
{        

    static struct elm_commands  * partial_common_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (partial_common_commands) {
	inc_commands_refcount(partial_common_commands);
	return partial_common_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialKeyTitle,"Message assemble command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&partial_common_commands);


    add_commands_help_single(ret,NULL,0,'|',
			     CATGETS(elm_msg_cat, CommandSet, CommandPartialPipe,
				     "Pipe the current message or tagged messages to the command specified."));

    {
	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }

    DPRINT(Debug,30,(&Debug,
		     "give_partial_common_commands=%p [pointer %p]\n",
		     ret,&partial_common_commands));

    return ret;
}


/* increment refcount */
static struct elm_commands *give_partialA_commands P_((void));
static struct elm_commands *give_partialA_commands() 
{

    static struct elm_commands  * partialA_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (partialA_commands) {
	inc_commands_refcount(partialA_commands);
	return partialA_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialKeyTitle,"Message assemble command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&partialA_commands);

    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }

    add_commands_help_single(ret,NULL,0,'o',
			     CATGETS(elm_msg_cat, CommandSet, CommandPartialOptionsMenu,
				     "Go to the options submenu."));

    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandPartialToggleMenu,
				     "Toggle menu on/off"));

    DPRINT(Debug,30,(&Debug,
		     "give_partialA_commands=%p [pointer %p]\n",
		     ret,&partialA_commands));

    return ret;
}

/* increment refcount */
struct elm_commands *give_partialmbx_commands() 
{        

    static struct elm_commands  * partialmbx_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (partialmbx_commands) {
	inc_commands_refcount(partialmbx_commands);
	return partialmbx_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialKeyTitle,"Message assemble command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&partialmbx_commands);

    {
	int cmds[] = { 'i', 'q', 'Q', 'x', 'X', ctrl('Q'), 0 };


	add_commands_help_many(ret,0,cmds,
			     CATGETS(elm_msg_cat, CommandSet, CommandPartialReturnIndex,
				     "Quit message assemble screen and return to index."));
    }


    {
	struct elm_commands *A = give_partialA_commands();
	
	add_commands_help_merge(ret,A,0);

	free_commands(&A);    /* Just decrements refcount */
    }


    {
	struct elm_commands *mbx = give_additional_mailbox_commands();
	
	add_commands_help_merge(ret,mbx,0);

	free_commands(&mbx);    /* Just decrements refcount */
    }


    {
	struct elm_commands *common = give_partial_common_commands();
	
	add_commands_help_merge(ret,common,0);

	free_commands(&common);    /* Just decrements refcount */

    }

    DPRINT(Debug,30,(&Debug,
		     "give_partialmbx_commands=%p [pointer %p]\n",
		     ret,&partialmbx_commands));

    return ret;
}


/* increment refcount */
struct elm_commands *give_partialmain_commands() 
{        

    static struct elm_commands  * partialmain_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (partialmain_commands) {
	inc_commands_refcount(partialmain_commands);
	return partialmain_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialKeyTitle,"Message assemble command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&partialmain_commands);


    {
      int cmds[] = { '$', F5_KEY_MARK, 0 };

      add_commands_help_many(ret,0,cmds,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandPartialResynchronizeFolder,
				     "Quit message assemble screen and force resynchronization of the folder."));

    }    


    add_commands_help_single(ret,NULL,0,'c',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandPartialChangeFolder,
				     "Quit message assemble screen and change folders, leaving the current folder."));



    {
	int cmds[] = { 'i', 'q', 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandPartialReturnIndex,
				       "Quit message assemble screen and return to index."));
    }


    add_commands_help_single(ret,NULL,0,'Q',
			     CATGETS(elm_msg_cat, CommandSet, CommandPartialQuickQuit,
				     "Quit message assemble screen and  quit the mailer, save read, leave unread, delete deleted."));

    add_commands_help_single(ret,NULL,0,'X',
			     CATGETS(elm_msg_cat, CommandSet, CommandPartialQuickExit,
				     "Quit message assemble screen and exit leaving the folder untouched, unconditionally."));



    {
	int cmds[] = { 'x', ctrl('Q'), 0 };
    
	/* Ctrl-Q is not on pager commands */

	add_commands_help_many(ret,0,cmds,
				 CATGETS(elm_msg_cat, CommandSet, 
					 CommandPartialExitFolder,
					 "Quit message assemble screen and exit leaving the folder untouched, ask permission if changed."));
			     
    }



    {
	struct elm_commands *A = give_partialA_commands();
	
	add_commands_help_merge(ret,A,0);

	free_commands(&A);    /* Just decrements refcount */
    }

    {
	struct elm_commands *mbx = give_additional_mailbox_commands();
	
	add_commands_help_merge(ret,mbx,0);

	free_commands(&mbx);    /* Just decrements refcount */
    }


    {
	struct elm_commands *common = give_partial_common_commands();
	
	add_commands_help_merge(ret,common,0);

	free_commands(&common);    /* Just decrements refcount */

    }

    DPRINT(Debug,30,(&Debug,
		     "give_partialmain_commands=%p [pointer %p]\n",
		     ret,&partialmain_commands));

    return ret;
}


/* increment refcount */
struct elm_commands *give_partialpager_commands() 
{        

    static struct elm_commands  * partialpager_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (partialpager_commands) {
	inc_commands_refcount(partialpager_commands);
	return partialpager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialPgKeyTitle,"Message assemble command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPartialPgDescTitle,
					      "Elm %s PL%s Action (pager)"),
				      VERSION,PATCHLEVEL),
			&partialpager_commands);

    {
	struct elm_commands *cpager = give_cpager_commands();
	
	add_commands_help_merge(ret,cpager,0);

	free_commands(&cpager);    /* Just decrements refcount */

    }


    {
	struct elm_commands *common = give_partial_common_commands();
	
	add_commands_help_merge(ret,common,0);

	free_commands(&common);    /* Just decrements refcount */

    }

    DPRINT(Debug,30,(&Debug,
		     "give_partialpager_commands=%p [pointer %p]\n",
		     ret,&partialpager_commands));

    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
