static char rcsid[] = "@(#)$Id: threadcmd.c,v 1.4 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

struct elm_commands *give_view_threads_commands() 
{        

    static struct elm_commands  * view_threads_commands = NULL;

    struct elm_commands  * ret = NULL;

    if (view_threads_commands) {
	inc_commands_refcount(view_threads_commands);
	return view_threads_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewThreadsKeyTitle,
					      "Viewing threads command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewThreadsDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&view_threads_commands);

    {
	int cmds[] = { '\n', '\r', 0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandViewThreadsThis,
				       "View current thread as mailbox."));
    }


    {
	int cmds[] = { '*', END_MARK, 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandViewThreadsLastThread,
				       "Go to the last thread."));
    }


    {	
	int cmds[] = { '+', PAGEDOWN_MARK, 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewThreadsNextPage,
				       "Go to the next page of threads."));
    }
    
    {
	int cmds[] = { '-',  PAGEUP_MARK, 0 };
	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewThreadsPreviousPage,
				       "Go to the previous page of threads."));
    }

    add_commands_help_single_keyext(ret,NULL,0,NUMBER_MARK,
				    format_string(CATGETS(elm_msg_cat, CommandSet,
							  CommandReturnKey,
							  "<return>")),
				    CATGETS(elm_msg_cat, CommandSet, 
					    CommandViewThreadsMakeThreadCurrent,
					    "Make specified number the current thread."));


    {
	int cmds[] = { '=', HOME_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewThreadsFirstThread,
				       "Go to the first thread."));
    }

    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }

    add_commands_help_single(ret,NULL,0,'d',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandViewThreadsDelete,
				     "Mark the current thread for future deletion."));	     

    {
	int cmds[] = { 'i', 'q', 'x', 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewThreadsQuit,
				       "Quit threads viewing screen and return to index."));
    }

    add_commands_help_single(ret,NULL,0,'J',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandViewThreadsNextThread,
				     "Go to the next thread."));

    {
	int cmds[] = { 'j', DOWN_MARK, 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewThreadsNextUndeleted,
				       "Go to the next undeleted thread."));
    }

    add_commands_help_single(ret,NULL,0,'K',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandViewThreadsPreviousThread,
				     "Go to the previous thread."));


    {
	int cmds[] = { 'k', UP_MARK, 0 };

	
	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandViewThreadsPreviousUndeleted,
				       "Go to the previous undeleted thread."));
    }


    add_commands_help_single(ret,NULL,0, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, CommandMainRewriteScreen,
				     "Rewrite the screen."));


    {
	
	struct elm_commands * mail_commands = new_dummy_prefixed_commands();

	add_commands_help_single(mail_commands,NULL,0,'/',
				 CATGETS(elm_msg_cat, CommandSet, CommandMailCanceled,
					 "Select canceled (forgotten) mail."));

	add_commands_help_single(ret,mail_commands,0,'m',
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonSendMail,
				     "Create and send mail to the specified person or persons."));
	
	free_commands(&mail_commands);    /* Just decrement refcount */
    }

    add_commands_help_single(ret,NULL,0,'u',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandViewThreadsMessage,
				     "Undelete - remove the deletion mark on the current thread."));

    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainToggleMenu,
				     "Toggle menu on/off"));

    DPRINT(Debug,30,(&Debug,
		     "give_view_threads_commands=%p [pointer %p]\n",
		     ret,&view_threads_commands));

    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
