static char rcsid[] = "@(#)$Id: view_foldercmd.c,v 1.5 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_snd_view_folder_commands() 
{        

    static struct elm_commands  * snd_view_folder_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (snd_view_folder_commands) {
	inc_commands_refcount(snd_view_folder_commands);
	return snd_view_folder_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandSndViewFolKeyTitle,"Viewing folder command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandSndViewFolDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&snd_view_folder_commands);

    {
      int cmds[] = { ctrl('J'), ctrl('M'), 
		     ctrl('Q'), 'Q', 'X',
		     'q', 'i', 0  };

      add_commands_help_many(ret,0, cmds, 
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandSndViewFolQuit,
				     "Quit viewing folder and return to Mail Pre-Send Screen."));
      
    }

    add_commands_help_single(ret,NULL,0,' ',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainDisplayCurrentMessage,
				     "Display the current message."));
			     
    add_commands_help_single(ret,NULL,0,'a',
			     CATGETS(elm_msg_cat,CommandSet,
				     CommandSndViewFolViewAttachments,
				     "View attachments of mail (which is prepared on Mail Pre-Send Screen)."));

    add_commands_help_single(ret,NULL,0,'b',
			     CATGETS(elm_msg_cat,CommandSet,
				     CommandSndViewFolAttachBody,
				     "Attach the body of the current message to mail on Mail Pre-Send Screen."));

    add_commands_help_single(ret,NULL,0,'m',
			     CATGETS(elm_msg_cat,CommandSet,
				     CommandSndViewFolAttachMessage,
				     "Attach the current message to mail on Mail Pre-Send Screen."));

    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainToggleMenu,
				     "Toggle menu on/off"));

    {
	struct elm_commands *motion = give_motion_commands();
	
	add_commands_help_merge(ret,motion,0);
	
	free_commands(&motion);    /* Just decrements refcount */
    }

    DPRINT(Debug,30,(&Debug,
		     "give_snd_view_folder_commands=%p [pointer %p]\n",
		     ret,&snd_view_folder_commands));

    return ret;
}


/* increment refcount */
struct elm_commands *give_snd_view_pager_commands() 
{        

    static struct elm_commands  * snd_view_pager_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (snd_view_pager_commands) {
	inc_commands_refcount(snd_view_pager_commands);
	return snd_view_pager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandSndViewPgKeyTitle,"Viewing folder command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandSndViewPgDescTitle,
					      "Elm %s PL%s Action (pager)"),
				      VERSION,PATCHLEVEL),
			&snd_view_pager_commands);


    add_commands_help_single(ret,NULL,0,'b',
			     CATGETS(elm_msg_cat,CommandSet,
				     CommandSndViewPgAttachBody,
				     "Command not available (attaching message body is not possible when viewing it)."));
    
    add_commands_help_single(ret,NULL,0,'m',
			     CATGETS(elm_msg_cat,CommandSet,
				     CommandSndViewPgAttachMessage,
				     "Command not available (attaching message is not possible when viewing it)."));
      

    {
	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }

    DPRINT(Debug,30,(&Debug,
		     "give_snd_view_pager_commands=%p [pointer %p]\n",
		     ret,&snd_view_pager_commands));


    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
