static char rcsid[] = "@(#)$Id: visit_mailboxcmd.c,v 1.4 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
static struct elm_commands *give_visitmbx_common_commands P_((void)); 
static struct elm_commands *give_visitmbx_common_commands() 
{        

    static struct elm_commands  * visitmbx_common_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (visitmbx_common_commands) {
	inc_commands_refcount(visitmbx_common_commands);
	return visitmbx_common_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandVisitMbxKeyTitle,
					      "Visiting mailbox command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandVisitMbxDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&visitmbx_common_commands);
    
    add_commands_help_single(ret,NULL,0,'|',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonPipe,
				     "Pipe the current message or tagged messages to the command specified."));

    {
	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }


    return ret;
}


/* increment refcount */
struct elm_commands *give_visit_mailbox_commands() 
{        

    static struct elm_commands  * visit_mailbox_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (visit_mailbox_commands) {
	inc_commands_refcount(visit_mailbox_commands);
	return visit_mailbox_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandVisitMbxKeyTitle,"Visiting mailbox command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandVisitMbxDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&visit_mailbox_commands);


    add_commands_help_single(ret,NULL,0,'i',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandVisitMbxReturnIndex,
				     "Quit visiting mailbox screen, asking about deletion, and return to index."));

    add_commands_help_single(ret,NULL,0,'Q',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandVisitMbxQuickQuit,
				     "Quick quit visiting mailbox screen, delete deleted."));

    add_commands_help_single(ret,NULL,0,'q',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandVisitMbxQuit,
				     "Quit visiting mailbox screen, asking about deletion."));

    add_commands_help_single(ret,NULL,0,'X',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandVisitMbxQuickExit,
				     "Exit visiting mailbox screen, leaving mails untouched, unconditionally."));

    {
	int cmds[] = { 'x', ctrl('Q'), 0 };
	
	/* Ctrl-Q is not on pager commands */
	
	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandVisitMbxExit,
				       "Exit screen, leaving mails untouched, ask permission if changed."));
    }

    
    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainToggleMenu,
				     "Toggle menu on/off"));


    {
	struct elm_commands *mbx = give_additional_mailbox_commands();
	
	add_commands_help_merge(ret,mbx,0);

	free_commands(&mbx);    /* Just decrements refcount */
    }


    {
	struct elm_commands *common = give_visitmbx_common_commands();
	
	add_commands_help_merge(ret,common,0);

	free_commands(&common);    /* Just decrements refcount */

    }

    return ret;
}

/* increment refcount */
struct elm_commands *give_visit_mbx_pager_commands() 
{        

    static struct elm_commands  * visit_mbx_pager_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (visit_mbx_pager_commands) {
	inc_commands_refcount(visit_mbx_pager_commands);
	return visit_mbx_pager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandVisitMbxPgKeyTitle,"Visiting mailbox command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandVisitMbxPgDescTitle,
					      "Elm %s PL%s Action (pager)"),
				      VERSION,PATCHLEVEL),
			&visit_mbx_pager_commands);


    /* none */

    {
	struct elm_commands *common = give_visitmbx_common_commands();
	
	add_commands_help_merge(ret,common,0);

	free_commands(&common);    /* Just decrements refcount */

    }

    return ret;
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
