static char rcsid[] = "@(#)$Id: date.c,v 2.18 2020/05/29 17:12:57 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.18 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/date.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/date.c
 *  That code have following copyright:
 *
 *  The Elm Mail System  
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** return the current date and time in a readable format! **/
/** also returns an ARPA RFC-822 format date...            **/




#include "def_elm.h"

#include "s_me.h"


DEBUG_VAR(Debug,__FILE__,"config");

static unsigned char * s2us P_((char *str));
static unsigned char * s2us(str)
     char *str;
{
    return (unsigned char *)str;
}

/* SHRT_MAX */
#include <limits.h>

/* Caller must free -- uses return value of days_ahead_tm() ,
   return NULL on failure
*/
struct string * days_ahead_text(expire_time, print_time)
     const struct tm * expire_time;
     enum print_time print_time;
{
    if (expire_time) {

	char timebuf[SLEN] = "";
	size_t len = 0;
	
	DPRINT(Debug,16,(&Debug,
			 "days_ahead_text: print_time=%d",print_time));

	
	switch (print_time) {
	    char * days_ahead_fmt;

	case print_date_and_time:
	    DPRINT(Debug,16,(&Debug," print_date_and_time"));

	    
	    days_ahead_fmt = catgets(elm_msg_cat,MeSet,
				     MeDaysAheadFmtTime,
				     "%a, %d %B %Y %H:%M");

	    DPRINT(Debug,16,(&Debug," days_ahead_fmt=%s",days_ahead_fmt));
	    
	    len = strftime(timebuf,sizeof timebuf,days_ahead_fmt,
			   expire_time);
	    
	    DPRINT(Debug,16,(&Debug," len=%zu timebuf=%s",len,timebuf));
	    
	    break;
	case print_date_only:
	    DPRINT(Debug,16,(&Debug," print_date_only"));
	    
	    days_ahead_fmt = catgets(elm_msg_cat,MeSet,
				     MeDaysAheadFmt,
				     "%a, %d %B %Y");

	    DPRINT(Debug,16,(&Debug," days_ahead_fmt=%s",days_ahead_fmt));
	    
	    len = strftime(timebuf,sizeof timebuf,days_ahead_fmt,
			   expire_time);

	    DPRINT(Debug,16,(&Debug," len=%zu timebuf=%s",len,timebuf));
	    
	    break;
	}
	DPRINT(Debug,16,(&Debug,"\n"));
	
	if (len > 0) {
	    /* system_charset is locale charset */
	    return new_string2(system_charset,s2us(timebuf));
	}				      
    } 
	
    return NULL;
}

/* Caller must string_free() result;
 *  may return NULL
 *
 */

struct string * elm_date_text(entry,time_mode,show_zone)
     struct header_rec         * entry;
     enum pager_time_display_v time_mode;
     enum pager_zone_mode      show_zone;
{
    struct string * ret = NULL;

    static int report_time_MAX = 1;

    if (report_time_MAX) {
	DPRINT(Debug,1,(&Debug,
			"Using time_MAX = %ld\n",
			(long)time_MAX));
	report_time_MAX = 0;
    }
    
    if (time_MAX == entry->time_sent ||
	entry->time_sent <= 0
	) {

	const char * s UNUSED_VAROK = 
	    (time_MAX == entry->time_sent) ? "MAX overflow" : "usupported value";
	
	if (entry->time_menu_year > 0 && entry->time_menu_year < SHRT_MAX) {
	    DPRINT(Debug,16,(&Debug,
			     "elm_date_text: parse_date_time() have %s, year %d\n",
			     s,
			     entry->time_menu_year));
	    

	    ret = format_string(CATGETS(elm_msg_cat,MeSet,
					MeDateStrYear,"year %04d"),
				entry->time_menu_year);
	} else {
	    DPRINT(Debug,16,(&Debug,
			     "make_menu_date: parse_date_time() have %s, failure\n",
			     s));
	}

    } else if (
	       (entry->tz_offset > 0 && time_MAX - entry->tz_offset < entry->time_sent)
	       ||
	       (entry->tz_offset < 0 && entry->time_sent < -(entry->tz_offset))
	       ) {
	
	DPRINT(Debug,1,(&Debug,
			"elm_date_text: time_sent=%ld tz_offset=%ld time_MAX = %ld -- overflow\n",
			(long)(entry->time_sent),(long)(entry->tz_offset),(long)time_MAX));

    } else {
	time_t seconds   = entry->time_sent + entry->tz_offset;
	struct tm *tmbuf = gmtime(&seconds);

	if (tmbuf) {
	    char timebuf[SLEN] = "";
	    char * time_fmt = NULL;
	    
	    DPRINT(Debug,16,(&Debug,
			     "elm_date_text: seconds=%ld  date %04d-%02d-%02d %02d:%02d:%02d %.12s (offset=%ld)\n",
			     (long)seconds,
			     tmbuf->tm_year + 1900,
			     tmbuf->tm_mon + 1,
			     tmbuf->tm_mday,
			     tmbuf->tm_hour,
			     tmbuf->tm_min,
			     tmbuf->tm_sec,
			     entry->time_zone,
			     (long)(entry->tz_offset)));

	    switch (time_mode) {
		
	    case  ptd_legacy:
		time_fmt = catgets(elm_msg_cat,MeSet,
				   MeDateStrTimeFmt,
				   "%b %d, %Y %r");
	    
		if (0) {		    
		case ptd_default:   time_fmt = catgets(elm_msg_cat,MeSet,
						       MeDateStrTime24Fmt,
						       "%b %d, %Y %T");
		}

		/* Rest are fixed ------------------------------------- */
		if (0) {	      		
		case ptd_month_day_year_12h: /* month day, Year 12h (am/pm) */
		    time_fmt = "%b %d, %Y %r";
		}
		if (0) {
		case ptd_month_day_year_24h: /* month day, Year 24h         */
		    time_fmt = "%b %d, %Y %T";
		}
		if (0) {		
		case ptd_month_day_year_HH_MM:  /*  month day, Year HH:MH       */
		    time_fmt = "%b %d, %Y %R";
		}
		if (0) {
		case ptd_preferred:  time_fmt = "%c";
		}
		if (0) {
		case ptd_day_month_year_12h:   /*  day month year  12h (am/pm) */
		    time_fmt = "%d %b %Y %r";
		}
		if (0) {
		case ptd_day_month_year_24h:   /*        day month year  24h    */
		    time_fmt = "%d %b %Y %T";
		}
		if (0) {
		case ptd_day_month_year_HH_MM: /*        day month year  HH:MM   */
		    time_fmt = "%d %b %Y %R";
		}

		if (time_fmt) {  /* Got time format */
		    size_t len =  strftime(timebuf,sizeof timebuf,time_fmt,
					   tmbuf);
		    if (len > 0) {
			
			/* system_charset is locale charset */
			ret = new_string2(system_charset,s2us(timebuf));
		    }
		}
		break;
		
	    case ptd_YYYY_MM_DD_HH_MM:            /* numeric YYYY-MM-DD HH:MM           */
		ret = format_string(FRM("%04d-%02d-%02d %02d:%02d"),
				    tmbuf->tm_year + 1900,
				    tmbuf->tm_mon + 1,
				    tmbuf->tm_mday,
				    tmbuf->tm_hour,
				    tmbuf->tm_min);
		break;

	    case ptd_YYYY_MM_DD_HH_MM_SS:         /* numeric YYYY-MM-DD HH:MM:SS        */
		ret = format_string(FRM("%04d-%02d-%02d %02d:%02d"),
				    tmbuf->tm_year + 1900,
				    tmbuf->tm_mon + 1,
				    tmbuf->tm_mday,
				    tmbuf->tm_hour,
				    tmbuf->tm_min,
				    tmbuf->tm_sec);
		break;

	    case NUM_pager_time_display: break;

	    case ptr_date_header_field:
		if (expanded_time_hdrval(tmbuf, entry->time_sent /* ---- not 'seconds'? */,
					 timebuf,sizeof timebuf,
					 print_date_and_time,
					 entry->time_zone,entry->tz_offset)) {
		    
		    /* Assumed system_charset */
		    ret = new_string2(system_charset,s2us(timebuf));
		}

		goto zone_alread_handled;
	    }

	    if (ret) {
		switch (show_zone) {
		case elm_date_no_zone: break;
		case elm_date_show_zone:
		    if (entry->time_zone) {
			add_ascii_to_string(ret,s2us(" "));
			add_ascii_to_string(ret,s2us(entry->time_zone));
		    }
		    break;
		}
	    }

	} else {
	    DPRINT(Debug,1,(&Debug,
			    "elm_date_text: seconds=%ld -- gmtime failed\n",
			    (long)seconds));	    
	}	    
    }

 zone_alread_handled:
    if (ret) {
	DPRINT(Debug,16,(&Debug,
			 "elm_date_text=%S\n",ret));
    } else {
	DPRINT(Debug,16,(&Debug,
			 "elm_date_text=NULL\n"));
    }
    
    return ret;
}




void make_menu_date(entry,menu_type,today_info)
     struct header_rec       * entry;
     enum time_menu_mode       menu_type;
     const struct today_info * today_info;
{
    static int report_time_MAX = 1;

    char timebuf[SLEN] = "";

    if (report_time_MAX) {
	DPRINT(Debug,1,(&Debug,
			"Using time_MAX = %ld\n",
			(long)time_MAX));
	report_time_MAX = 0;
    }
    
    if (time_MAX == entry->time_sent ||
	entry->time_sent <= 0
	) {

	const char * s UNUSED_VAROK = 
	    (time_MAX == entry->time_sent) ? "MAX overflow" : "usupported value";		
	if (entry->time_menu_year > 0 && entry->time_menu_year < SHRT_MAX) {
	    DPRINT(Debug,16,(&Debug,
			     "make_menu_date: parse_date_time() have %s, year %d\n",
			     s,
			     entry->time_menu_year));

	    elm_sfprintf(timebuf, sizeof timebuf,
			 FRM("%04d"),
			 entry->time_menu_year);
	} else {
	    strfcpy(timebuf,"<?>",	sizeof timebuf);
	    DPRINT(Debug,16,(&Debug,
			     "make_menu_date: %s\n",
			     s));
	}

	/* Preserve entry->time_menu_year */
	entry->time_menu_type = time_menu_null;
	entry->time_menu_today = 0;

    } else if (
	(entry->tz_offset > 0 && time_MAX - entry->tz_offset < entry->time_sent)
	||
	(entry->tz_offset < 0 && entry->time_sent < -(entry->tz_offset))
	) {

	DPRINT(Debug,1,(&Debug,
			"make_menu_date: time_sent=%ld tz_offset=%ld time_MAX = %ld -- overflow\n",
			(long)(entry->time_sent),(long)(entry->tz_offset),(long)time_MAX));
	
	strfcpy(timebuf,"<?>",	sizeof timebuf);
	entry->time_menu_year = 0; /* Unsupported */
	entry->time_menu_type = time_menu_null;
	entry->time_menu_today = 0;
	
    } else {
    
	time_t seconds   = entry->time_sent + entry->tz_offset;
	struct tm *tmbuf = gmtime(&seconds);
	int may_use_hhmm = 0;
	int may_use_day_hhmm = 0;
	
	if (tmbuf) {
	    strfcpy(timebuf,"<?>",	sizeof timebuf);
	    entry->time_menu_type = menu_type;

	    DPRINT(Debug,16,(&Debug,
			     "make_menu_date: seconds=%ld  date %04d-%02d-%02d %02d:%02d:%02d %.12s (offset=%ld)\n",
			     (long)seconds,
			     tmbuf->tm_year + 1900,
			     tmbuf->tm_mon + 1,
			     tmbuf->tm_mday,
			     tmbuf->tm_hour,
			     tmbuf->tm_min,
			     tmbuf->tm_sec,
			     entry->time_zone,
			     (long)(entry->tz_offset)));
	    
	    if (today_info) {
		entry->time_menu_today = 0;
		
		if (TODAY_INFO_magic != today_info->magic)
		    panic("ELM PANIC",__FILE__,__LINE__,
			  "make_menu_date",
			  "Bad magic number (today_info)",0);

		may_use_hhmm =
		    tmbuf->tm_mday == today_info->tm_mday &&
		    tmbuf->tm_mon  == today_info->tm_mon  &&
		    tmbuf->tm_year == today_info->tm_year;

		may_use_day_hhmm =
		    tmbuf->tm_year == today_info->tm_year;
		    
		
		if (may_use_hhmm) {
		    entry->time_menu_today = 1;
		    DPRINT(Debug,16,(&Debug,
				     "make_menu_date: Is today -- day,month,year matches\n"));
		    
		} else if (may_use_day_hhmm) {
		    DPRINT(Debug,16,(&Debug,
				     "make_menu_date: Is this year -- year matches\n"));
		}
		
		if (entry->tz_offset != today_info->tz_mins*60) {
		    may_use_hhmm     = 0;
		    may_use_day_hhmm = 0;
		    DPRINT(Debug,16,(&Debug,
				     "make_menu_date: Is different timezone (tz_offset=%ld) than on today info (tz_mins=%d, tz_offset=%ld)\n",
				     (long)(entry->tz_offset),today_info->tz_mins,
				     (long)( today_info->tz_mins*60)));
		}
		    
		if (today_info->today_start_time &&
		    (time_t)-1 != today_info->today_start_time &&
		    today_info->today_end_time &&
		    (time_t)-1 != today_info->today_end_time &&
		    entry->time_sent >= today_info->today_start_time &&
		    entry->time_sent <= today_info->today_end_time) {
		    entry->time_menu_today = 1;

		    DPRINT(Debug,16,(&Debug,
				     "make_menu_date: Is today -- is between start of day and end of day on today info\n"));
		}
	    } else {
		DPRINT(Debug,16,(&Debug,
				 "make_menu_date: no today info -- %s today (not updated)\n",
				 entry->time_menu_today ? "Is" : "Is not"));
	    }
	    
	    switch(menu_type) {
		char * time_menu_fmt;
		size_t len;
		
	    case time_menu_null:
		strfcpy(timebuf,"<?>",	sizeof timebuf);

		DPRINT(Debug,16,(&Debug,
				 "make_menu_date: uses null time format\n"));
		
		break;

	    case time_menu_hhmm_24hour:
		if (may_use_hhmm) {
		    elm_sfprintf(timebuf, sizeof timebuf,
				 FRM("%02d:%02d "),
				 tmbuf->tm_hour,
				 tmbuf->tm_min);

		    DPRINT(Debug,16,(&Debug,
				     "make_menu_date: uses hhmm: %s\n",
				     timebuf));
		} else
		    goto not_today;
		break;
		
	    not_today:
	    case time_menu_month_day:

		time_menu_fmt = catgets(elm_msg_cat,MeSet,
					MeEntryTimeMenuMonthDayFmt,
					"%b %d");
		
		len = strftime(timebuf,sizeof timebuf,time_menu_fmt,
			       tmbuf);
		if (len > 0) {
		    entry->time_menu_type = time_menu_month_day;
		    
		    DPRINT(Debug,16,(&Debug,
				     "make_menu_date: uses month day: %s\n",
				     timebuf));
		} else {
		     DPRINT(Debug,16,(&Debug,
				      "make_menu_date: strftime failed\n"));
		     
		     strfcpy(timebuf,"<?>",	sizeof timebuf);
		     entry->time_menu_year  = 0; /* Unsupported */
		     entry->time_menu_type = time_menu_null;
		}
		
		break;

	    case time_menu_hhmm_or_year:
		if (may_use_hhmm) {
		    elm_sfprintf(timebuf, sizeof timebuf,
				 FRM("%02d:%02d "),
				 tmbuf->tm_hour,
				 tmbuf->tm_min);

		    DPRINT(Debug,16,(&Debug,
				     "make_menu_date: uses hhmm: %s\n",
				     timebuf));
		} else
		    goto meybe_this_year;
		break;

	    meybe_this_year:
	    case time_menu_month_day_hhmm:
		if (may_use_day_hhmm) {
		    time_menu_fmt = catgets(elm_msg_cat,MeSet,
					    MeEntryTimeMenuMonthDayTimeFmt,
					    "%b %d %H:%M");

		    len = strftime(timebuf,sizeof timebuf,time_menu_fmt,
				   tmbuf);
		    if (len > 0) {
			entry->time_menu_type = time_menu_month_day_hhmm;
			
			DPRINT(Debug,16,(&Debug,
					 "make_menu_date: uses month day time: %s\n",
					 timebuf));
		    } else {
			DPRINT(Debug,16,(&Debug,
					 "make_menu_date: strftime failed\n"));
			
			strfcpy(timebuf,"<?>",	sizeof timebuf);
			entry->time_menu_year  = 0; /* Unsupported */
			entry->time_menu_type = time_menu_null;
		    }
		} else
		    goto not_this_year;
		break;

	    not_this_year:
	    case time_menu_month_day_year:
		time_menu_fmt = catgets(elm_msg_cat,MeSet,
					 MeEntryTimeMenuMonthDayYearFmt,
					 "%b %d %Y");

		len = strftime(timebuf,sizeof timebuf,time_menu_fmt,
			       tmbuf);
		if (len > 0) {
		    entry->time_menu_type = time_menu_month_day_year;
		    
		    DPRINT(Debug,16,(&Debug,
				     "make_menu_date: uses month day year: %s\n",
				     timebuf));
		} else {
		    DPRINT(Debug,16,(&Debug,
				     "make_menu_date: strftime failed\n"));
		    
		    strfcpy(timebuf,"<?>",	sizeof timebuf);
		    entry->time_menu_year  = 0; /* Unsupported */
		    entry->time_menu_type = time_menu_null;
		}
		break;		
	    }
	    
	    if (tmbuf->tm_year >= 0 &&
		tmbuf->tm_year + 1900 <= SHRT_MAX) {
		entry->time_menu_year = tmbuf->tm_year + 1900;
		DPRINT(Debug,16,(&Debug,
				 "make_menu_date: year is %d\n",
				 entry->time_menu_year));
	    } else
		entry->time_menu_year = 0; /* Unsupported */
	} else {
	    DPRINT(Debug,1,(&Debug,
			    "make_menu_date seconds=%ld -- gmtime failed\n",
			    (long)seconds));
	    
	    strfcpy(timebuf,"<?>",	sizeof timebuf);
	    entry->time_menu_year  = 0; /* Unsupported */
	    entry->time_menu_type = time_menu_null;
	}
    }


    if (entry->time_menu_s)
	free_string(& (entry->time_menu_s));

    /* system_charset is locale charset */
    entry->time_menu_s = new_string2(system_charset,s2us(timebuf));
    DPRINT(Debug,16,(&Debug,
		     "make_menu_date: time menu=%S\n",
		     entry->time_menu_s));
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
