/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_elm.h"

extern struct sending_display * new_sending_display  P_((int rcpt_count,
							 int interactive));
extern void free_sending_display P_((struct sending_display **sd));
extern void inc_sending_display_refcount P_((struct sending_display *sd));
extern void update_addr_sd P_((struct sending_display *sd,
			       int                    idx,
			       struct string        * addr,
			       enum msd_addr_status   status,
			       struct string        * message /* server */
			       ));
extern enum msd_action check_addr_sd P_((struct sending_display *sd,
					 int                    idx,
					 struct string        * addr,
					 enum msd_addr_status   status,
					 struct string        * message 
					 /* server */,
					 enum msd_can_continue can_continue));
extern void update_data_sd P_((struct sending_display * sd,
			       enum msd_data_status     status,
			       struct string          * message /* server */));
extern enum msd_action check_fail_sd P_((struct sending_display *sd,
					 enum msd_data_status    status,
					 struct string         * message 
					 /* server */,
					 enum msd_can_continue can_continue));
extern void update_con_sd P_((struct sending_display *sd,
			      enum msd_connection_info idx,
			      struct string *text));

extern enum msd_action size_check_sd P_((struct sending_display *sd,
					 long message_size,
					 long size_limit));
extern void update_size_cb P_((struct sending_display *sd,
			       enum msd_size_info idx,
			       long size));

/* ----------------------------------------------------------------------------- */

enum verify_trans_result {
    ft_none         = 0,
    ft_send         = 1,
    ft_preview      = 2,
    ft_preview_menu = 3,
    ft_preview_mime = 4, /* View mime structure */
    ft_preview_hdrs = 5,

    ft_forget       = -1,
    ft_forget_empty = -2,
    ft_EOF          = -3
};

extern enum snd_preview_result {
    sp_none         = 0,
    sp_send         = 1,
    sp_verify_trans = 4,

    sp_forget       = -1,
    sp_EOF          = -3
} preview_message P_((FILE *converted_buffer,int *command_ch,
		      struct menu_context  *parent_page,
		      struct elm_commands *snd_cmds,
		      enum verify_trans_result ft_code,
		      mime_send_t *mime_info,
		      struct mailing_headers * headers,
		      struct AliasView *aview,
		      struct MailboxView *mailbox,
		      const struct remote_server  * remote_server
));

/* --------------------------------------------------------------------- */

extern struct classify_domain_result {
    int          is_literal;          /* Is literal */
    const char * whitelisted_name;    /* Is whitelisted */
    const char * reserved_name;       /* Is reserved (special name) */

    enum verify_domain_result  domain_result;
    
    unsigned int is_local      :1;
    unsigned int need_verify   :1;
    unsigned int domain_rewritten :1;
    
} const NULL_classify_domain_result;

extern enum rp_classify_domain {
    env_from_reset      = -2, /* Env from was reset to <> */
    env_from_no_domain  = -1  /* Env from does not include domain */,
    env_from_bad_domain = 0, /* Parse failure or reserved domain 
				 DNS: domain have bad syntax 
			      */
    env_from_ok_domain  = 1  /* Parses OK */,
    env_from_mailer_verified /* Mailer verified this with 250 (local address)
				domain verification not needed */,
    env_from_unknown_domain  /* DNS: domain not found */,
    env_from_no_mail_domain  /* DNS: domain does not accept mail */,
    env_from_dns_verified    /* DNS: domain ok */
} env_from_classify_domain P_((struct mailer_env_from *X,
			       struct classify_domain_result *cdr,
			       struct mailer_info      * mailer_info));

extern void rp_classify_domain_message P_((struct mailer_env_from *env_from,
					   enum rp_classify_domain       result,
					   struct classify_domain_result *cdr));

extern void mail_env_from_presend P_((enum rp_classify_domain       * env_from_domain_class_p,
				      struct mailing_headers        * headers,
				      struct classify_domain_result *  env_from_cdr_p));

extern void mail_show_env_from P_((struct mailing_headers *headers,
				   enum rp_classify_domain env_from_domain_class,
				   struct menu_context *page));

extern int mail_env_from_def_edit P_((enum rp_classify_domain         env_from_domain_class,
				      struct mailing_headers        * headers,
				      struct classify_domain_result * env_from_cdr));

extern int mail_edit_return_path(struct mailing_headers *headers,
				 struct menu_context *page);

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
