static char rcsid[] = "@(#)$Id: edit.c,v 2.11 2020/01/18 20:07:41 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/edit.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This routine is for allowing the user to edit their current folder
    as they wish.

**/

#include "def_elm.h"
#include "s_elm.h"

#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif         

DEBUG_VAR(Debug,__FILE__,"misc");

void edit_mailbox(mailbox, page)
     struct MailboxView **mailbox;
     struct menu_context *page;
{
    /** Allow the user to edit their folder, always resynchronizing
	afterwards.   Due to intense laziness on the part of the
	programmer, this routine will invoke $EDITOR on the entire
	file.  The mailer will ALWAYS resync on the folder
	even if nothing has changed since, not unreasonably, it's
	hard to figure out what occurred in the edit session...
	
	Also note that if the user wants to edit their incoming
	mailbox they'll actually be editing the tempfile that is
	an exact copy.  More on how we resync in that case later
	in this code.
    **/

    const char *edited_file = NULL;
    struct folder_info * f = get_main_folder(*mailbox);
    int reconnect = 0;
    
    if (!f)
	return;

    if (!start_edit_folder(f,&edited_file))
	return;

    if (edit_a_file(edited_file,page) == 0) 
	return;
    
    switch(end_edit_folder(f)) { 
    case end_edit_fail_abort:
	DPRINT(Debug,9, (&Debug, "edit_mailbox: got end_fail_abort\n"));
	emergency_exit(0);
    case end_edit_none:
	DPRINT(Debug,9, (&Debug, "edit_mailbox: got end_edit_none\n"));
	return;
    case end_edit_open:
	DPRINT(Debug,9, (&Debug, "edit_mailbox: got end_edit_open\n"));

	break;
    case end_edit_reconnect:
	/* Should not happen */
	DPRINT(Debug,9, (&Debug, "edit_mailbox: got end_edit_reconnect\n"));
	reconnect = 1;
	break;
    }

    
    if (sleepmsg > 0) {
	error_sleep(sleepmsg);
    }

    menu_ClearScreen(page);
    newmbox_1(f, mailbox, FALSE, 
	      page,reconnect,NULL,
	      /* struct quota_display * */ NULL
	      );  
    

    showscreen(page);
    return;
}

int edit_a_file(editfile, page)
     const char *editfile;
     struct menu_context  *page;
{
    /** Edit a file.  This routine is used by edit_mailbox()
	and edit_aliases_text().  It gets all the editor info
	from the elmrc file.
    **/
    
    char     buffer[SLEN];
    int	LINES, COLUMNS;
    
    unsigned int editor_keyword = 0, editor_mask = 0;
    const char * editor_val = give_dt_estr_as_str(&editor_e,"editor",
						  &editor_keyword,
						  &editor_mask);
    int builtin = 0;

    menu_get_sizes(page,&LINES, &COLUMNS);

    PutLineX(LINES-2,0, CATGETS(elm_msg_cat, ElmSet, ElmInvokeEditor,
				"Invoking editor..."));
    
    error_wait();  /* Pause if there was error */    

    if (!editor_val && !editor_keyword) {   /* "none" or error */
	builtin++;	
    } else {
	switch(editor_keyword) {
	case editor_kw_builtin:
	    builtin++;
	    break;

	case editor_kw_NO:
	    break;

	default:
	    DPRINT(Debug,9, (&Debug, 
			     "edit_a_file: bad editor keyword #%d\n",
			     editor_keyword));
	    builtin++;
	    break;
	}
    }

    if (builtin || !have_editor(editor_val)) {
	editor_val = give_dt_estr_as_str(&alternative_editor_e,"alteditor",
					 &editor_keyword,
					 &editor_mask);

	if (editor_val) {
	    DPRINT(Debug,9, (&Debug, 
			     "edit_a_file: Using alternative editor %s instead\n",
			     editor_val));
	} else {
	   DPRINT(Debug,9, (&Debug, 
			    "edit_a_file: No alternative editor\n"));
	   return 0;
	}
    }
    
    if (!editor_val || editor_keyword || 
	strlen(editfile) + strlen(editor_val) > sizeof buffer -5 ||
	!have_editor(editor_val)) {
	DPRINT(Debug,9, (&Debug, 
			 "edit_a_file: No editor or alternative editor or too long line\n"));
	return 0;
    }

    /* XXXX change this  */
    if (in_string(editor_val, "%s"))
	elm_sfprintf(buffer, sizeof buffer,
		     FRM(editor_val), editfile);
    else
	elm_sfprintf(buffer, sizeof buffer,
		     FRM("%s %s"), editor_val, editfile);
        
    Raw(OFF);
    
    if (system_call(buffer, SY_ENAB_SIGHUP, NULL) == -1) {
	Raw(ON);

	menu_trigger_redraw(page);

	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmProblemsInvokingEditor,
			  "Problems invoking editor %s!"), 
		  editor_val);
	sleep_message();
	return(0);
    }
    
    Raw(ON);
       
    menu_trigger_redraw(page);

    return(1);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
