static char rcsid[] = "@(#)$Id: exitprog.c,v 2.3 2014/07/14 15:07:29 hurtta Exp $";

/****************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>  
 *                       (was hurtta+elm@posti.FMI.FI, 
 *                            hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ****************************************************************************
 *  Based on Elm 2.4 src/exitprog.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ELM");

/* returns:

   0 .. do not do exit
   1 .. do normal exit
   EOF

   Does NOT free mailbox
*/

int exit_mailbox(mailbox, page)
     struct MailboxView *mailbox;
     struct menu_context *page;
{
    /** Exit, abandoning all changes to the mailbox (if there were
	any, and if the user say's it's ok)
    **/

    int i, changes = 0;
    int mc;
    int LINES, COLUMNS;

    menu_get_sizes(page, &LINES, &COLUMNS);   


    DPRINT(Debug,1,
	   (&Debug, "\n\n-- exiting --\n\n"));
    
    /* Determine if any messages are scheduled for deletion, or if
     * any message has changed status
     */
    mc = get_message_count(mailbox);
    for (changes = 0, i = 0; i < mc; i++) {
	struct header_rec * hdr = give_header(mailbox,i);
	
	if (ison(hdr->status, DELETED) || hdr->status_chgd)
	    changes++;
    }
	

    if (changes) {

	int X1;
	  /* YES or NO on softkeys */
	  /*
	  if (hp_softkeys) {
	    define_softkeys(YESNO);
	    softkeys_on();
	  }
	  */

	/* Ctrl-C is equivalent of NO  here*/

	  if (changes == 1)
	      X1 = prompt_letter(LINES-4,"",*def_ans_no,
				 PROMPT_yesno|PROMPT_cancel,page,	
				 
				 CATGETS(elm_msg_cat, ElmSet, ElmAbandonChange,
					 "Abandon change to mailbox? (%c/%c) "),
				 *def_ans_yes, *def_ans_no);
	  else
	      X1 = prompt_letter(LINES-4,"",*def_ans_no,
				 PROMPT_yesno|PROMPT_cancel,page,	
				 
				 CATGETS(elm_msg_cat, ElmSet, ElmAbandonChangePlural,
					 "Abandon changes to mailbox? (%c/%c) "), 
				 *def_ans_yes, *def_ans_no);
	  
	  if (X1 == EOF)
	      return EOF;

	  
	  if(X1 != *def_ans_yes) 
	      return 0;
	}

	FlushBuffer();

	
	return 1;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
