static char rcsid[] = "@(#)$Id: fb_options.c,v 2.4 2014/05/17 12:46:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * Partially based on Elm 2.5 src/fbrowser.c
 *
 *****************************************************************************/

#include "def_elm.h"
#include "s_fbrowser.h"

#include "browser.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"ui");


#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

static int global_resort = 0;
static int global_setscreen  = 0;

S_(option_post_handling_f set_resort)
static void set_resort P_((int));
static void set_resort(f) 
     int f;
{
    if (f) {
	global_resort++;
    }

}

S_(option_post_handling_f set_screen)
static void set_screen P_((int));
static void set_screen(f) 
     int f;
{
    if (f) {
	global_setscreen++;
    }

}





/* Returns 'q'
            0
           EOF

*/         

int fbrowser_option(parent_page,resort,setscreen)
     struct menu_context * parent_page;
     int *resort;
     int *setscreen;
{
    static struct elm_commands * STORE = NULL;

    struct elm_commands *cmds = NULL;
    int ch;

    struct optsmenu *fbrowser_opts = malloc_optsmenu();


    char * fbrowser_options = "^_dspt";

    struct string * title = format_string(CATGETS(elm_msg_cat, FbrowserSet,
						  FbrowserOptionsTitle,
						  "File Selection Browser -- Options"));

    struct string * prompt_text = 
	format_string(CATGETS(elm_msg_cat, FbrowserSet,
			      FbrowserOptionsInstructMain,
			      "Select option letter, or q)uit to return to File Selection Browser."));
					      

    global_resort     = *resort;
    global_setscreen  = *setscreen;

    /* add_option: pointers are shared -- 
                   must be malloced and caller must not free them 
    */
    add_option(fbrowser_opts,
	       'd',
	       safe_strdup("file-browser-show-dotfiles"),
	       format_string(CATGETS(elm_msg_cat, FbrowserSet,
				     FbrowserOptionsTitleDotf,
				     "D)ot files displayed?")),
	       format_string(CATGETS(elm_msg_cat, FbrowserSet,
				     FbrowserOptionsInstructDotf,
				     "Do you want filenames beginning with \".\" dot to be displayed?")),
	       set_resort);

    
    add_option(fbrowser_opts,
	       's',
	       safe_strdup("file-browser-sortby"),
	       format_string(CATGETS(elm_msg_cat, FbrowserSet,
				     FbrowserOptionsTitleSort,
				     "S)orting criteria")),
	       format_string(CATGETS(elm_msg_cat, FbrowserSet,
				     FbrowserOptionsInstructSort,
				     "How should the filename listing be sorted?")),
	       set_resort);

    add_option(fbrowser_opts,
	       'p',
	       safe_strdup("file-browser-show-protection"),
	       format_string(CATGETS(elm_msg_cat, FbrowserSet,
				     FbrowserOptionsTitleProtection,
				     "File p)rotection displayed?")),
	       format_string(CATGETS(elm_msg_cat, FbrowserSet,
				     FbrowserOptionsInstructProtection,
				     "Do you want protection and owner of files displayed?")),
	       NULL_option_post_handling);

    add_option(fbrowser_opts,
	       't',
	       safe_strdup("file-browser-show-title"),
	       format_string(CATGETS(elm_msg_cat, FbrowserSet,
				     FbrowserOptionsTitleShowTitle,
				     "T)itle of columns displayed?")),
	       format_string(CATGETS(elm_msg_cat, FbrowserSet,
				     FbrowserOptionsInstructShowTitle,
				     "Do you want title of columns displayed?")),
	       set_screen);
	   

    cmds = 
	give_option_commands(&STORE,fbrowser_opts, NULL,
			     format_string(CATGETS(elm_msg_cat, FbrowserSet, 
						   FbrowserKeyTitle,
						   "Command")),
			     format_string(CATGETS(elm_msg_cat, FbrowserSet,
						   FbrowserActionTitle,
						   "Elm %s PL%s Action"),
					   VERSION,PATCHLEVEL),
			     pg_BOLD,
			     format_string(CATGETS(elm_msg_cat, FbrowserSet,
						   FbrowserHelpTitle,
						   "Commands available on options menu of File Selection Browser")),
			     format_string(CATGETS(elm_msg_cat, FbrowserSet,
						   FbrowserQuitHelp,
						   "Return to the File Selection Browser.")),
			     fbrowser_options);

   
    ch = gen_options(fbrowser_opts,parent_page,NULL,cmds,title,
		     fbrowser_options,prompt_text);
    	       
    *resort    = global_resort;
    *setscreen = global_setscreen;

    free_string(&prompt_text);
    free_string(&title);

    free_optsmenu(& fbrowser_opts);

    free_commands(&cmds);

    DPRINT(Debug,9, (&Debug, "fbrowser_option=%d  *resort=%d *setscreen=%d\n",
		     ch,*resort,*setscreen));

    return ch;
}




/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */


