static char rcsid[] = "@(#)$Id: help.c,v 2.11 2016/10/26 16:02:45 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/help.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/help.c. 
 *  That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/*** help routine for ELM program 

***/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"misc");

int help_generic(cmds,pager_help,page, prompt_area)
     struct elm_commands  * cmds;
     int pager_help;
     struct menu_context  *page;
     struct menu_context  *prompt_area;
{

    /** Process the request for help [section] from the user.
	If pager_help is TRUE, then act a little differently from
	if pager_help is FALSE (index screen)
	
	If redraw is needed use menu_trigger_redraw()
    **/
    

    int  ch;		/* character buffer for input */
    int prompt_line, info_line;
    int delay_redraw = 0;
    
    
    
 redraw:
    menu_ClearScreen(prompt_area);
    
    if(pager_help) {
	int LINES, COLUMNS;
	
	menu_get_sizes(prompt_area,&LINES, &COLUMNS);
	
	menu_print_format_center(prompt_area,LINES-1, 
				 CATGETS(elm_msg_cat, ElmSet, ElmHelpMessage,
					 "Press the key you want help for, '?' for a key list, or '.' to exit help"));
	prompt_line = 0;
    } else {
	menu_print_format_center(prompt_area,0,
				 CATGETS(elm_msg_cat, ElmSet, ElmHelpSystem,
					 "ELM Help System"));
	menu_print_format_center(prompt_area,1,
				 CATGETS(elm_msg_cat, ElmSet, ElmHelpMessage,
					 "Press the key you want help for, '?' for a key list, or '.' to exit help"));
	prompt_line = 2;
    }
    info_line = prompt_line + 1;
    
    do {
	menu_PutLineX(prompt_area,
		      prompt_line, 0, 
		      CATGETS(elm_msg_cat, ElmSet, ElmHelpPrompt,
			      "Help for key: "));
	
	ch = menu_ReadCh(prompt_area,REDRAW_MARK|READCH_CURSOR
			 |READCH_sig_char);
	
	if (ch == REDRAW_MARK) {
	    menu_ClearScreen(page);   /* clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    delay_redraw++;
	    
	    /* This clear redraw mark from prompt_area */	      
	    goto redraw;
	}

	if (ch == '.') 
	    break;
	
	if (ch == TERMCH_interrupt_char) 
	    break;
	
	switch (ch) {
	    	    
	case HELP_MARK:
	case '?': { 
	    int X = '\0';
	    
	    struct stringbuffer * bout =  give_commands_help(cmds);
	    
	    if (bout) {
		struct pager_page * PP = init_pager_page(NULL);
		
		X =  builtinplusplus(bout,PP,1, NULL,
				     0 /* no index */);
		
		free_stringbuffer(&bout);
		
		exit_pager_page(&PP,page);
	    }
	    
	    
	    return X;
	}
	break;
		
	case EOF: 
	    
	    return EOF;

	default : {
	    
	    const struct elm_command * C =
		lookup_elm_command(cmds,ch);
	    
	    if (C) {
		struct string * key_text = 
		    elm_command_key_text(C);
		const struct string * key_desc =
		    elm_command_key_desc(C);
		
		menu_ClearLine(prompt_area,info_line);
		
		menu_print_format_center(prompt_area,info_line,
					 FRM("%S = %S"),
					 key_text,key_desc);
		
		
		free_string(&key_text);
		
	    } else {
		struct string * key_text =
		    elm_command_key1_desc(ch);
		
		menu_ClearLine(prompt_area,info_line);
		
		if (key_text) {
		    menu_print_format_center(prompt_area,info_line,
					     CATGETS(elm_msg_cat, ElmSet, 
						     ElmHelpUnknownNameCommand,
						     "%S = Unknown command.  Use '?' for a list of commands."),
					     key_text);
		    free_string(&key_text);
		} else {
		    menu_print_format_center(prompt_area,info_line,
					     CATGETS(elm_msg_cat, ElmSet, 
						     ElmHelpUnknownCommand,
						     "Unknown command.  Use '?' for a list of commands."));
		}
	    }
	    	    	    
	}
	    break;

	}
	
    } while (ch != '.');

    if (delay_redraw) 
	menu_trigger_redraw(page);
    
    menu_trigger_redraw(prompt_area);
    
    return '\0';
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
