static char rcsid[] = "@(#)$Id: visit_mailbox.c,v 2.22 2021/01/10 15:47:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.22 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * Some part based on code from src/elm.c. It have following copyright:
 * 
 *  The Elm Mail System 
 *
 * This file and all associated files and documentation:
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_list.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"mail");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(subpage_simple_redraw sb_visit_mailbox_title)
static int sb_visit_mailbox_title(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    struct menu_common *mptr = mp_lookup_mcommon(list,elm_mp_menu);

    int message_count  = mcommon_get_count(mptr);
    int selected       = mcommon_get_selected(mptr);
    struct string * f1 = mcommon_title(mptr);

    struct string * buffer0 = NULL;
    struct string * buffer = NULL;
    struct string * buffer2 = NULL;

    int l0,l1,l2,l;
    int LINES, COLUMNS;
    
    DPRINT(Debug,9, (&Debug, "sb_visit_mailbox_title\n"));

    menu_ClearScreen(ptr);
    menu_get_sizes(ptr, &LINES, &COLUMNS);   


    buffer0 = format_string(CATGETS(elm_msg_cat, ElmSet, 
				    ElmVisitMailboxTitle,
				    "Visiting mailbox"));
   
    if (selected)
	buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
				       ElmShownXWithSelect,
				       "%S with %d shown out of %d"),
			       f1,selected, 
			       message_count);
    else 
       	buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
				       ElmShownXNoSelectItem,
				       "%S with %d %S"),
			       f1, message_count,
			       (message_count == 1) ? 
			       mcommon_give_item(mptr,m_item) :
			       mcommon_give_item(mptr,m_items));

    

    free_string(&f1);
    
    l0 = string_len(buffer0);
    l1 = string_len(buffer);
    
    buffer2 = format_string(FRM("[ELM %s]"),
			    version_buff);
    l2 = string_len(buffer2);
    l = l1 + l2 + 1; /* Assumed */
    
    if (l + l0 + 2 < COLUMNS) {
	int la = l + l0 +2;

	menu_PutLineX(ptr,1,(COLUMNS - la)/2,
		      FRM("%S: %S %S"),
		      buffer0,buffer,buffer2);

    } else {
	if (l0 < COLUMNS)
	    menu_PutLineX(ptr,0,(COLUMNS - l0)/2,FRM("%S"),buffer0);
	
	if (l > COLUMNS) {
	    if (l2 < COLUMNS)
		menu_PutLineX(ptr,2,(COLUMNS - l2)/2,FRM("%S"),buffer2);
	    if (l1 > COLUMNS) 
		menu_PutLineX(ptr,1,1,FRM("%S"),buffer);
	    else
		menu_PutLineX(ptr,1,(COLUMNS - l1)/2,FRM("%S"),buffer);
	} else {
	    menu_PutLineX(ptr,1,(COLUMNS - l)/2,FRM("%S %S"),buffer,buffer2);
	}
    }

    free_string(&buffer);
    free_string(&buffer2);
    
    return 1;   /* subpage area updated completely */
}

S_(subpage_simple_redraw sb_visit_mailbox_menu)
static int sb_visit_mailbox_menu(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list; 
{
    enum user_level_v ul = 
	give_dt_enumerate_as_int(&user_level);

    menu_ClearScreen(ptr);
    
    if (ul == user_level_beginner) {	/* a rank beginner.  Give less options  */
	menu_print_format_center(ptr,0,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel0MenuLine1,
					 "You can use any of the following commands by pressing the first character;"));
	menu_print_format_center(ptr,1,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel0VisitMLine2,
					 "d)elete or u)ndelete mail,  m)ail a message,  r)eply mail,  q)uit visit"));
	menu_print_format_center(ptr,2,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel0PartLine3,
					 "To read a message, press <return>.  j = move down, k = move up"));
    } else {
	menu_print_format_center(ptr,0,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel1MenuLine1,
					 "|=pipe, !=shell, ?=help, <n>=set current to n, /=search pattern"));
        menu_print_format_center(ptr,1,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel1VisitMLine2,
					 "a)lias, C)opy, d)elete, f)orward, g)roup reply, m)ail,"));
	menu_print_format_center(ptr,2, 
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel1VisitMLine3,
					 "n)ext,  P)rint text, r)eply, s)ave, t)ag, or q)uit"));
    }

    return 1;
}


static void set_mailbox_screen P_((struct menu_context  *page, 
				   struct screen_parts *LOC,
				   struct menu_param  *LIST));


static void set_mailbox_screen(page,LOC, LIST)
     struct menu_context  *page;
     struct screen_parts *LOC;
     struct menu_param  *LIST;
{    
    int   LINES, COLUMNS;	

    menu_get_sizes(page,&LINES, &COLUMNS);

    /* 1)  Title part of screen */

    if (! LOC->title_page)
	LOC->title_page = new_menu_subpage(page,0,4,sb_visit_mailbox_title,
					   LIST);
    else
	menu_subpage_relocate(LOC->title_page,page,0,4);
					  
    /* 2) menu part */

    if (LOC->menu_page && LINES < 14)
	erase_menu_context (&(LOC->menu_page));
    else if (LOC->menu_page)
	menu_subpage_relocate(LOC->menu_page,page,LINES-8,4);
    else if (mini_menu && LINES > 14)
	LOC->menu_page = new_menu_subpage(page,LINES-8,4,
					  sb_visit_mailbox_menu,LIST);
   
    mailbox_screen_common(page,LOC, LIST);	
}

#if ANSI_C
static showmsg_cmd showmsg_visit_mailbox_cmd;
#endif


static int showmsg_visit_mailbox_cmd P_((struct MailboxView *mailbox,
					 int cmd, 
					 struct pager_page *pager_page));
static int showmsg_visit_mailbox_cmd(mailbox,cmd,pager_page)
     struct MailboxView *mailbox;
     int cmd; 
     struct pager_page *pager_page;
{
    struct menu_common MENU;
    
    set_mcommon_from_mbxview(&MENU,mailbox);

    switch (cmd) {
    case '|' : {
	int current = get_current(mailbox);
	
	put_cmd_name(pager_page, TRUE,
		     CATGETS(elm_msg_cat, ElmSet, ElmPipe, "Pipe"));
	
	if (give_message_data(mailbox,current-1,
			      NULL,NULL,NULL,
			      NO_mime_parse))
	    do_pipe(mailbox, 
		    pager_page->root,
		    pager_page->prompt_area);     
	    
	else {
	    DPRINT(Debug,3,(&Debug, 
			    "give_message_data [%d] fails",current-1));
	}
    }
	return 256;
    }

    return cmd;
}


static void check_mailbox_screen P_((struct screen_parts *LOC,
				     struct menu_param *list));
static void check_mailbox_screen(LOC,list)
     struct screen_parts *LOC;
     struct menu_param *list;
{
    if (menu_resized(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page resized\n"));

    }
    if (menu_need_redraw(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page redraw???\n"));
	sb_visit_mailbox_title(LOC->title_page,list);	
    }
    if (LOC->menu_page) {
	/* 2) menu page */
	if (menu_resized(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page resized\n"));
	    
	}
	if (menu_need_redraw(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page redraw???\n"));
	    sb_visit_mailbox_menu(LOC->menu_page,list);
	}
    }

    /* 3) prompt part */
    if (menu_resized(LOC->prompt_page)) {
	DPRINT(Debug,1, (&Debug, "prompt page resized\n"));
    }
    if (menu_need_redraw(LOC->prompt_page)) {
	menu_ClearScreen(LOC->prompt_page);

	show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
    }    

    /* 4) headers part */
    if (menu_resized(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page resized\n"));
    }
    if (menu_need_redraw(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page redraw\n"));
	menu_ClearScreen(LOC->header_page);
    }
}

/* Returns 'i' is return to index given */
int visit_mailbox_loop(mailbox, aview,command_letter)
     struct MailboxView *mailbox;
     struct AliasView *aview;
     int  command_letter;
{
    int leave = 0;
    int retch = '\0';

    struct menu_context  *page = new_menu_context();
    struct screen_parts LOC = { NULL };
    struct menu_common MENU;
    struct menu_param  PARAM[elm_mp_COUNT+1] = { 
	{ mp_menu_common, { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_END,         { 0 } }
    };

    struct elm_commands *pager_cmds = give_visit_mbx_pager_commands();
    struct elm_commands *menu_cmds = give_visit_mailbox_commands();


    int   LINES, COLUMNS;
    const char * exit_hint_folder = NULL;  /* If not "", gives failed folder type */

    mp_list_set_mcommon(PARAM,elm_mp_menu,&MENU);


    menu_get_sizes(page,&LINES, &COLUMNS);

    set_mcommon_from_mbxview(&MENU,mailbox);
    set_mailbox_screen(page,&LOC,PARAM);

    resort_mailbox(mailbox,1);

    get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
    copy_current(&MENU,LOC.header_page);

    showscreen(page);

    while (!leave) {
	int ch;

	menu_set_default(page);

	if (menu_resized(page)) {
	
	    set_mailbox_screen(page,&LOC,PARAM);
		    
	    menu_get_sizes(page,&LINES, &COLUMNS);

	    menu_trigger_redraw(page);

	} 

	new_mail_check(mailbox, page, &LOC, &exit_hint_folder);
	
	if (update_view(mailbox)) {
	    resort_mailbox(mailbox,1);

	    get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
	    menu_trigger_redraw(LOC.header_page);
	    menu_trigger_redraw(LOC.title_page);	 

	}

	if (menu_need_redraw(page)) 
	    showscreen(page);
	check_mailbox_screen(&LOC, PARAM);

	{   
	    int lin,col;
	    
	    menu_PutLineX(LOC.prompt_page,0,0,
			    FRM("%S"),mcommon_give_item(&MENU, m_Prompt));
	    menu_GetXYLocation(LOC.prompt_page,&lin,&col);

	    menu_CleartoEOS(LOC.prompt_page);   
	    
	    if (!show_last_error() &&
		exit_hint_folder) {
		if (exit_hint_folder[0])
		    lib_transient(CATGETS(elm_msg_cat, ElmSet, 
					  ElmSFailedUseXforQuickExit,
					  "%s failed. Use 'X' for Quick Exit"),
				  exit_hint_folder);
		else
		    lib_transient(CATGETS(elm_msg_cat, ElmSet, 
					  ElmUseXforQuickExit,
					  "Use 'X' for Quick Exit"));
		exit_hint_folder = NULL;
	    }

	    if (command_letter) {
		DPRINT(Debug,4,(&Debug, 
				"Auto command %d",
				command_letter));
		if (isascii(command_letter) && isprint(command_letter)) {
		    DPRINT(Debug,4,(&Debug, " (%d)",
				    command_letter));
		}
		DPRINT(Debug,4,(&Debug, "\n"));
		
		ch = command_letter;
		command_letter = '\0';
	    } else
		ch = GetPrompt(LOC.prompt_page,elm_timeout);
	    
	    menu_CleartoEOS(LOC.prompt_page);
	    
	    if (isascii(ch) && isprint(ch)) {
		  DPRINT(Debug,4,(&Debug, 
				  "\nCommand: %c [%d]\n\n", ch, ch));
	    } else {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %d\n\n", ch));
	    }
	    
	    set_error("");	/* clear error buffer */	    
	    
	    menu_MoveCursor(LOC.prompt_page,lin,col);
	}

	ch = mailbox_command(mailbox,ch, &LOC,
			     showmsg_visit_mailbox_cmd, aview, 
			     page,pager_cmds,0,menu_cmds);

	switch (ch) {
	case 0:  /* OK */
	    break;

	case F3_KEY_MARK:
	    mini_menu = ! mini_menu;

	    if (LOC.menu_page && !mini_menu)
		erase_menu_context (&(LOC.menu_page));

	    DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));
	    
	    set_mailbox_screen(page,&LOC,PARAM);
		    
	    menu_trigger_redraw(page);
	    
	    break;

	case '|'    :   {
	    int current = get_current(mailbox);
	    
	    menu_Writechar(LOC.prompt_page,
			   '|');
	    
	    if (current < 1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoMailToPipe,
				  "No mail to pipe!"));
		
	    } else if (give_message_data(mailbox,current-1,
					 NULL,NULL,NULL,NO_mime_parse)) {
		
		/* softkeys_off(); */
		
		do_pipe(mailbox, page,LOC.prompt_page);			       

		/* softkeys_on(); */
	    } else {
		DPRINT(Debug,3,(&Debug, 
				"give_message_data [%d] fails",current-1));
	    }
	}
	    break;


	case 'q': {
	      int idx, mbxcount, found = 0;

	      menu_Write_to_screen(LOC.prompt_page,
				   CATGETS(elm_msg_cat, ElmSet,
					   ElmQuit,
					   "Quit"));
	      FlushBuffer();

	      mbxcount = get_storage_count(mailbox);
		
	      for (idx = 0 ; idx < mbxcount; idx++) {
		  long bytes = 0;
		  int newmails = 0;
		  enum new_mail_stat r1;
		  int err = 0;
		  
		  struct current_storage * storage =		      
		      get_storage(mailbox,idx);
		  
		  if (!storage->current_folder)
		      continue;
		  
		  r1 = new_mail_on_folder(storage->current_folder,&bytes,
					  &newmails,&err,NULL);
		  switch (r1) {
		  case failed_mbx_ign_new_mail:
		  case new_mail_check_failed: {
		      const char * ftype = folder_type(storage->current_folder);

		      if (err) 
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmFailedQuitCancelledS,
					    "%s failed! Quit canceled: %s"),
				    ftype,strerror(err));
		      else
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmFailedQuitCancelled,
					    "%s failed! Quit canceled..."),
				    ftype);
		      found++;
		      exit_hint_folder = ftype;
		  }
		      break;
		  case no_new_mail: break;
		  case have_new_mail:
		      if (newmails > 1) {  /* IMAP mailbox, count is available */
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmXNewMailsQuitCancelled,
					    "%d new mails!  Quit canceled..."),
				    newmails);
		      } else {
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmNewMailQuitCancelled,
					    "New Mail!  Quit canceled..."));
		      }
		      found++;
		      break;
		  case new_mail_reconnect: {
		      const char * ftype = folder_type(storage->current_folder);
		      
		      lib_error(CATGETS(elm_msg_cat, ElmSet, 
					ElmReconnectedQuitCancelled,
					"%s reconnected! Quit canceled..."),
				ftype);
		      found++;		      
		  }
		      break;
		  }
      	  
	      }

	      if (!found) {
		  /* We specify resync so that messages are not moved to
		     received folder ... visiting folder should not
		     change message status (actually not true with IMAP)
		  */
		  
		  enum sync_mbox_stat status =
		      sync_mbox(TRUE, TRUE, TRUE, NULL, mailbox,
				page,LOC.prompt_page);
		  
		  switch (status) {
		  case sync_mbox_cancel:
		      goto quit_canceled;
		  case sync_mbox_reconnect:
		      /*   What to do ?? */
		      continue;
		  case sync_mbox_newmail:
		      continue;
		  case sync_mbox_failure:		      
		  case sync_mbox_nochange:
		  case sync_mbox_changed:
		      break;

		  case sync_mbox_EOF:
		      retch = EOF;
		      goto OUT;
		      /* Read failed, control tty died? */		

		      break;		

		  }
			
		  if (status < sync_mbox_nochange) {
		      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedLeaveFolder,
					"Failed to leave folder!"));
		      exit_hint_folder = "";
		  } else {
		      leave = 1;			
		  }
		  
	      }
	}

	    if (0) {
	    quit_canceled:  /* Perhaps Ctrl-C given */
		lib_transient(CATGETS(elm_msg_cat, ElmSet, 
				      ElmQuitCancelled1,
				      "Quit canceled..."));
		
	    }
	    
	    break;
	    
	case 'Q'    :  {
	      int idx, mbxcount, found = 0;
	      
	      menu_Write_to_screen(LOC.prompt_page,
				   CATGETS(elm_msg_cat, ElmSet,
					   ElmQuickQuit,
					   "Quick quit"));
	      FlushBuffer();

	      mbxcount = get_storage_count(mailbox);
	      
	      for (idx = 0 ; idx < mbxcount; idx++) {
		  long bytes = 0;
		  int newmails = 0;
		  enum new_mail_stat r1;
		  int err = 0;
		  
		  struct current_storage * storage = 
		      get_storage(mailbox,idx);
		  
		  if (!storage || !storage->current_folder)
		      continue;

		  r1 = new_mail_on_folder(storage->current_folder,&bytes,
					  &newmails,&err,NULL);
		  switch (r1) {
		  case failed_mbx_ign_new_mail:
		  case  new_mail_check_failed: {
		      const char * ftype = folder_type(storage->current_folder);

		      if (err) 
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmFailedQuickQuitCancelledS,
					    "%s failed! Quick Quit canceled: %s"),
				    ftype,strerror(err));
		      else
			  lib_error(CATGETS(elm_msg_cat, ElmSet,
					    ElmFailedQuickQuitCancelled,
					    "%s failed! Quick Quit canceled..."),
				    ftype);
		      exit_hint_folder = ftype;
		      found++;
		  }
		      break;
		  case no_new_mail: break;
		  case have_new_mail:
		      if (newmails > 1) {  /* IMAP mailbox, count is available */
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmXNewMailsQuickQuitCancelled,
					    "%d new mails!  Quick Quit canceled..."),
				    newmails);
		      } else {
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmNewMailQuickQuitCancelled,
					    "New Mail!  Quick Quit canceled..."));
		      }
		      found++;
		      break;
		  case new_mail_reconnect: {
		      const char * ftype = folder_type(storage->current_folder);
		      
		      lib_error(CATGETS(elm_msg_cat, ElmSet, 
					ElmReconnectedQuickQuitCancelled,
					"%s reconnected! Quick Quit canceled..."),
				ftype);	
		      found++;
		  }
		      break;
		      
		  }
	      }

	      if (!found) {
		  /* We specify resync so that messages are not moved to
		     received folder .... visiting folder should not
		     change message status (actually not true with IMAP)
		  */

		  enum sync_mbox_stat status = sync_mbox(TRUE, TRUE, FALSE, NULL, mailbox,
							 page,LOC.prompt_page);

		   switch (status) {
		   case sync_mbox_cancel:
		       goto quick_quit_canceled;

		   case sync_mbox_reconnect:
		       /*   What to do ?? */
		       continue;
		   case sync_mbox_newmail:
		       continue;
		   case sync_mbox_failure:
		    case sync_mbox_nochange:
		    case sync_mbox_changed:
			break;

		   case sync_mbox_EOF:
		       retch = EOF;
		       goto OUT;
		       /* Read failed, control tty died? */		

		   }
		       
		  if (status < sync_mbox_nochange) {
		      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedLeaveFolder,
					"Failed to leave folder!"));
		      exit_hint_folder = "";
		  } else {
		      leave = 1;			
		  }		 
	      }
	  }

	    if (0) {
	    quick_quit_canceled:
		lib_transient(CATGETS(elm_msg_cat, ElmSet, 
				      ElmQuickQuitCancelled1,
				      "Quick Quit canceled..."));

	    }
	    
	      break;

	  case 'X'    :  
	      menu_Write_to_screen(LOC.prompt_page,
				   CATGETS(elm_msg_cat, ElmSet,
					   ElmQuickExit,
					   "Quick Exit"));
	      FlushBuffer();
	      leave = 1;
	      break;

	case ctrl('Q') :
	case 'x'    : {   
	    int r;
	    
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
					 ElmExit,
					 "Exit"));  
	    FlushBuffer();
	    
	    r = exit_mailbox(mailbox,
			     page);

	    if (EOF == r) {
		retch = EOF;
		goto OUT;
		/* Read failed, control tty died? */		
	    }

	    if (r) {
		leave=1;
	    }
	    /* XXXX   differentiate failure and cancel of Exit ? */
	}
	    break;

	case 'i': {

	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
					 ElmReturnIndex,
					 "Return to index"));  
	    FlushBuffer();

	    {
		  /* We specify resync so that messages are not moved to
		     received folder .... visiting folder should not
		     change message status (actually not true with IMAP)
		     
		     Let sync_mbox() to check about new mail ....
		  */

		enum sync_mbox_stat status =
		    sync_mbox(TRUE, TRUE, TRUE, NULL, mailbox,
			      page,LOC.prompt_page);

		switch (status) {
		case sync_mbox_cancel:
		    goto return_index_canceled;

		case sync_mbox_reconnect:
		    /*   What to do ?? */
		    continue;
		case sync_mbox_newmail:
		    continue;
		case sync_mbox_failure:
		case sync_mbox_nochange:
		case sync_mbox_changed:
		    break;
		    
		case sync_mbox_EOF:
		    retch = EOF;
		    goto OUT;
		    /* Read failed, control tty died? */		

		}
		    
		if (status < sync_mbox_nochange) {
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedLeaveFolder,
				      "Failed to leave folder!"));
		    exit_hint_folder = "";
		} else {

		    

		    retch = 'i';
		    leave = 1;			
		}
	    }

	    if (0) {
	    return_index_canceled:
		lib_transient(CATGETS(elm_msg_cat, ElmSet, 
				      ElmReturnIndexCancelled1,
				      "Return to index canceled..."));
		
	    }
	    
	}
	    break;
	case EOF:
	    retch = EOF;
	    goto OUT;

	default:
	    lib_error(CATGETS(elm_msg_cat, ElmSet,
			      ElmUnknownCommand2,			
			      "Unknown command."));

	}
	
	if (menu_need_redraw(page))
	    showscreen(page);
	
	check_range(&MENU, &LOC);
	check_mailbox_screen(&LOC, PARAM);


    } /* the BIG while loop! */

 OUT:
    free_commands(&pager_cmds);   /* Decrement refcount */
    free_commands(&menu_cmds);   /* Decrement refcount */

    free_mailbox_screen(&LOC);	
    erase_menu_context(&page);

    return retch;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
