static char rcsid[] = "@(#)$Id: alias_limit.c,v 2.7 2023/12/13 16:55:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * Inludes code from Elm 2.4 src/limit.c which have following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_mcommon.h"
#include "s_aliases.h"
#include "s_elm.h"


DEBUG_VAR(Debug,__FILE__,"menu");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}

static int limit_alias_selection P_((int based_on, struct string *pattern, 
				      int *vector,
				     struct AliasView *aview));
static int limit_alias_selection(based_on, pattern, vector,
				 aview)
     int based_on;
     struct string *pattern;
     int * vector;
     struct AliasView *aview;

{
    /** Given the type of criteria, and the pattern, mark all
	non-matching aliases as ! VISIBLE.  If additional_criteria,
	don't mark as visible something that isn't currently!
    **/
    
    int iindex;
    int count  = 0;
    
    DPRINT(Debug,2,(&Debug,  
		    "\n\n\n**limit on %d - '%S'**\n\n",
		    based_on, pattern));

    
    if (based_on == BY_NAME) {
	int ac = get_alias_count(aview);
	
	for (iindex = 0; iindex < ac; iindex++) {
	    struct aliasview_record *a = give_alias(aview,iindex);
	    
	    if (a) {
		const struct string * X = aliasview_key(a);
	    
		if (find_pattern_from_string(X,pattern,1 /* ignore case */))
		    vector[count++] = iindex;
	    }
	}

    } else if (based_on == BY_ALIAS) {
	int ac = get_alias_count(aview);
	
	for (iindex = 0; iindex < ac; iindex++) {

	    struct aliasview_record *a = give_alias(aview,iindex);

	    if (a) {

		if (alias_matches(a,pattern))
		    vector[count++] = iindex;		
	    }
	}

    } else if (based_on == BY_PERSON) {

	int ac = get_alias_count(aview);
	
	for (iindex = 0; iindex < ac; iindex++) {

	    struct aliasview_record *a = give_alias(aview,iindex);

	    if (a) {

		const struct string *firstn   = NULL;
		const struct string *lastn    = NULL;
		const struct address *address = NULL;
		
		const struct address_alias  * aliasval = aliasview_address_alias(a);

		int   is_person = address_alias_get_person(aliasval,&firstn,&lastn,&address);

		if (is_person)
		    vector[count++] = iindex;   
	    }
	}


    } else if (based_on == BY_GROUP) {

	int ac = get_alias_count(aview);
	
	for (iindex = 0; iindex < ac; iindex++) {

	    struct aliasview_record *a = give_alias(aview,iindex);

	    if (a) {

		const struct string       *phrase = NULL;
		const struct alias_vector *avector = NULL;

		const struct address_alias  * aliasval = aliasview_address_alias(a);

		int  is_group  = address_alias_get_group(aliasval,&phrase,&avector);

		if (is_group)
		    vector[count++] = iindex; 
	    }
	}

    } else {
	int ac = get_alias_count(aview);

	for (iindex = 0; iindex < ac; iindex++) {
	    struct aliasview_record  *a = give_alias(aview,iindex);

	    if (aliasview_have_type_mask(a,based_on))
		vector[count++] = iindex;
	}
    }

    DPRINT(Debug,9,(&Debug, 
		    "limit_alias_selection=%d\n",count));

    return count;
}


int mc_limit_helper_alias(u,str,retarr, page)
     union mcommon_union *u;
     struct string *str;
     int **retarr;
     struct menu_context  *page;
{
    int ret = -1;
    struct string *first = NULL;
    struct string *rest  = NULL;
    int L = string_len(str);
    uint16 delim;
    int pos = 0;
    int *vector = NULL;
    struct AliasView *aview = u->alias.aw;
    int n = get_alias_count(aview);

    if (!get_word_from_string(str,&first,&pos,GWF_lowercase,
			      /* ASCII assumed */
			      s2us(" \t"),&delim))
	goto fail;

    if (pos < L)
	pos++;

    if (pos < L &&
	0x0020 /* space */ == give_unicode_from_string(str,pos))
	pos++;


    if (n < 1) 
	goto fail;
    
    vector = safe_calloc(n, sizeof(vector[0]));

    rest = clip_from_string(str,&pos,L);

   
    if (string_matches_ascii(first, s2us("name"),0,SMA_op_normal))
	ret = limit_alias_selection(BY_NAME, rest, vector,
			      aview);
    else if (string_matches_ascii(first, s2us("alias"),0,SMA_op_normal))
	ret = limit_alias_selection(BY_ALIAS, rest,vector,
			      aview);
    else if (string_matches_ascii(first, s2us("person"),0,SMA_op_normal))
	ret = limit_alias_selection(BY_PERSON, rest, vector,
				    aview);
    else if (string_matches_ascii(first, s2us("group"),0,SMA_op_normal))
	ret = limit_alias_selection(BY_GROUP, rest, vector,
				    aview);
    else if (string_matches_ascii(first, s2us("user"),0,SMA_op_normal))
	ret = limit_alias_selection(USER, rest, vector,
				    aview);
    else if (string_matches_ascii(first, s2us("system"),0,SMA_op_normal))
	ret = limit_alias_selection(SYSTEM, rest, vector,
				    aview);
    else {
	lib_error(CATGETS(elm_msg_cat, ElmSet, 
			  ElmLimitNotValidCriterion,
			  "\"%S\" not a valid criterion."), 
		  first);
    }

 fail:
    
    if (first)
	free_string(&first);
    if (rest)
	free_string(&rest);

    if (ret <= 0) {
	if (vector)
	    free(vector);
	*retarr = NULL;
    } else
	*retarr = vector;
    
    return ret;
}

void mc_limit_print_help_alias(last_selected)
     int last_selected;
{

    if (last_selected)
         lib_transient(CATGETS(elm_msg_cat, AliasesSet, 
			       AliasesEnterLastSelected,
			       "Enter:{\"name\",\"alias\"} [pattern] OR {\"person\",\"group\",\"user\",\"system\", \"tagged\"} OR \"all\""));
    else
          lib_transient(CATGETS(elm_msg_cat, AliasesSet, 
				AliasesEnterSelected,
				"Enter: {\"name\",\"alias\"} [pattern] OR {\"person\",\"group\",\"user\",\"system\",\"tagged\"}"));
    
}
void mc_limit_print_result_alias(u)
     union mcommon_union *u;
{
   struct AliasView *aview = u->alias.aw;

   if (get_alias_selected(aview) > 1)
       lib_error(CATGETS(elm_msg_cat, AliasesSet,
			 AliasesLimitMessagesSelected, 
			 "%d aliases selected."),
		 get_alias_selected(aview));
   else if (get_alias_selected(aview) == 1)
       lib_error(CATGETS(elm_msg_cat, AliasesSet,
			 AliasesLimitMessageSelected, 
			 "1 alias selected."));
   else
       lib_error(CATGETS(elm_msg_cat, AliasesSet,
			 AliasesLimitNoMessagesSelected, 
			 "No aliases selected."));
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
