/* $Id: def_mcommon.h,v 2.11 2018/06/28 07:37:39 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "mboxlib.h"
#include "me.h"

#define MENU_COMMON_magic       0xF700
#define MCOMMON_TYPE_magic      0xF701

struct menu_alias {
    unsigned short         magic;
    struct mcommon_type  * mtype;
    struct AliasView     * aw;
};

struct menu_mailbox {
    unsigned short         magic;
    struct mcommon_type  * mtype;
    struct MailboxView   * mw;
};


union mcommon_union {
    struct menu_common     gen;
    struct menu_alias      alias;
    struct menu_mailbox    mbx;
};

typedef int mc_get_type_common    P_((union mcommon_union *u, int idx));
typedef int mc_setf_status_common  P_((union mcommon_union *u, int idx, 
				       enum status_x t, int mask));
typedef int mc_get_current_common P_((union mcommon_union *u));
typedef int mc_ison_status_common  P_((union mcommon_union *u, int idx, 
				       enum status_x t, int mask));
typedef int mc_clearf_status_common  P_((union mcommon_union *u, int idx, 
					 enum status_x t, int mask));
typedef char * mc_show_status_common  P_((union mcommon_union *u, int idx));
typedef int mc_get_count_common P_((union mcommon_union *u));
typedef int mc_matches_common   P_((union mcommon_union *u, int idx, struct string * meta_pattern));
typedef int mc_get_selected_common P_((union mcommon_union *u));
typedef void mc_set_current_common P_((union mcommon_union *u, int cur));
typedef void mc_set_selected_common P_((union mcommon_union *u, int cur));

typedef int mc_limit_helper_common P_((union mcommon_union *u,
				       struct string *str,
				       int **retarr,
				       struct menu_context  *page));

typedef void mc_limit_print_help_common P_((int last_selected));
typedef void mc_limit_print_result_common P_((union mcommon_union *u));
typedef enum pattern_result mc_match_in_text_common P_((union mcommon_union *u,
					struct string * meta_pattern,
					struct menu_context  *page,
					struct screen_parts *LOC));
typedef void mc_screen_print_common_line P_((union mcommon_union * u,
					     int                   idx,
					     struct menu_context * page,
					     struct menu_param   * list
					     ));
typedef const struct string * mc_give_item_common P_((enum mcommon_item I));

typedef struct string * mc_title_common P_((union mcommon_union *u));

typedef void mc_screen_print_common_sepline P_((union mcommon_union * u,
						int                   idx,
						struct menu_context * page,
						struct menu_param   * list
						));
typedef int mc_init_common_sep P_((union mcommon_union *u,struct menu_context * page));
typedef int mc_common_sepcount P_((union mcommon_union *u));
typedef int mc_get_common_separator_index P_((union mcommon_union *u,
					      int idx));
typedef int mc_screen_setup_common_init  P_((union mcommon_union * u,
					     struct menu_context * page,
					     struct menu_param   * list));
typedef void mc_screen_setup_common_line  P_((union mcommon_union * u,
					      int                   idx,
					      struct menu_context * page,
					      struct menu_param   * list));

struct mcommon_type {
    unsigned short         magic;

    mc_get_type_common      * mc_get_type_it;
    mc_setf_status_common   * mc_setf_status_it;
    mc_get_current_common   * mc_get_current_it;
    mc_ison_status_common   * mc_ison_status_it;
    mc_clearf_status_common * mc_clearf_status_it;
    mc_show_status_common   * mc_show_status_it;
    mc_get_count_common     * mc_get_count_it;
    mc_matches_common       * mc_matches_it;
    mc_get_selected_common  * mc_get_selected_it;
    mc_set_current_common   * mc_set_current_it;   
    mc_set_selected_common  * mc_set_selected_it;   
    mc_limit_helper_common  * mc_limit_helper_it;
    mc_limit_print_help_common   * mc_limit_print_help_it;
    mc_limit_print_result_common * mc_limit_print_result_it;
    mc_match_in_text_common * mc_match_in_text_it;
    mc_screen_print_common_line * mc_screen_print_it_line;
    mc_give_item_common         * mc_give_item_it;
    mc_title_common             * mc_title_it;
    mc_screen_print_common_sepline * mc_screen_print_it_sepline;
    mc_init_common_sep             * mc_init_it_sep;
    mc_common_sepcount             * mc_it_sepcount;
    mc_get_common_separator_index  * mc_get_it_separator_index;
    mc_screen_setup_common_init    * mc_screen_setup_it_init;
    mc_screen_setup_common_line    * mc_screen_setup_it_line;
};

#if ANSI_C 
extern mc_limit_helper_common mc_limit_helper_alias;
extern mc_limit_helper_common mc_limit_helper_mbx;
extern mc_limit_print_help_common mc_limit_print_help_alias;
extern mc_limit_print_help_common mc_limit_print_help_mbx;
extern mc_limit_print_result_common mc_limit_print_result_alias;
extern mc_limit_print_result_common mc_limit_print_result_mbx;

extern mc_matches_common mc_matches_alias;
extern mc_matches_common mc_matches_mbx;
extern mc_match_in_text_common mc_match_in_text_alias;
extern mc_match_in_text_common mc_match_in_text_mbx;
extern mc_screen_print_common_line mc_screen_print_alias_line;
extern mc_screen_print_common_line mc_screen_print_mbx_line;

extern mc_screen_print_common_sepline  mc_screen_print_alias_sepline;
extern mc_screen_print_common_sepline  mc_screen_print_mbx_sepline;

extern mc_give_item_common mc_give_item_alias;
extern mc_give_item_common mc_give_item_mbx;

extern mc_screen_setup_common_init mc_screen_setup_alias_init;
extern mc_screen_setup_common_init mc_screen_setup_mbx_init;

extern mc_screen_setup_common_line mc_screen_setup_alias_line;
extern mc_screen_setup_common_line mc_screen_setup_mbx_line;
#endif

extern int mc_limit_helper_alias P_((union mcommon_union *u,
				     struct string *str,
				     int **retarr,
				     struct menu_context  *page));
extern int mc_limit_helper_mbx P_((union mcommon_union *u,
				   struct string *str,
				   int **retarr,
				   struct menu_context  *page));

extern void mc_limit_print_help_alias P_((int last_selected));
extern void mc_limit_print_help_mbx P_((int last_selected));

extern void mc_limit_print_result_alias P_((union mcommon_union *u));
extern void mc_limit_print_result_mbx P_((union mcommon_union *u));

extern int mc_matches_alias   P_((union mcommon_union *u, int idx, 
				  struct string * meta_pattern));
extern int mc_matches_mbx   P_((union mcommon_union *u, int idx, 
				struct string * meta_pattern));
extern enum pattern_result mc_match_in_text_alias P_((union mcommon_union *u,
				      struct string * meta_pattern,
				      struct menu_context  *page,
				      struct screen_parts *LOC));
extern enum pattern_result mc_match_in_text_mbx P_((union mcommon_union *u,
				    struct string * meta_pattern,
				    struct menu_context  *page,
				    struct screen_parts *LOC));

extern void mc_screen_print_alias_line P_((union mcommon_union * u,
					   int                   idx,
					   struct menu_context * page,
					   struct menu_param   * list));
extern void mc_screen_print_mbx_line P_((union mcommon_union * u,
					 int                   idx,
					 struct menu_context * page,
					 struct menu_param   * list));

extern void mc_screen_print_alias_sepline P_((union mcommon_union * u,
					      int                   idx,
					      struct menu_context * page,
					      struct menu_param   * list));
extern void mc_screen_print_mbx_sepline P_((union mcommon_union * u,
					    int                   idx,
					    struct menu_context * page,
					    struct menu_param   * list));

extern int mc_screen_setup_alias_init  P_((union mcommon_union * u,
					   struct menu_context * page,
					   struct menu_param   * list));
extern int mc_screen_setup_mbx_init  P_((union mcommon_union * u,
					 struct menu_context * page,
					 struct menu_param   * list));

extern void mc_screen_setup_alias_line  P_((union mcommon_union * u,
					    int                   idx,
					    struct menu_context * page,
					    struct menu_param   * list));
extern void mc_screen_setup_mbx_line  P_((union mcommon_union * u,
					  int                   idx,
					  struct menu_context * page,
					  struct menu_param   * list));



extern const struct string * mc_give_item_alias P_((enum mcommon_item I));
extern const struct string * mc_give_item_mbx P_((enum mcommon_item I));


extern int from_matches P_((struct header_rec *mss,
			    struct string *pattern));
extern int to_matches P_((struct header_rec *mss,
			  struct string * pattern));
extern int cc_matches P_((struct header_rec *mss,
			  struct string * pattern));
extern int subject_matches P_((struct header_rec *mss,
			       struct string * pattern));

extern int addr_matches P_((const struct address *address, 
			    const struct string *pattern));
extern int list_addr_matches P_((const struct addr_list *list,
				 const struct string *pattern));
extern int list_group_matches P_((const struct addr_list *list,
				  const struct string *pattern));

extern int alias_matches P_((struct aliasview_record  * a, 
			     struct string *pat));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
