/* $Id: def_messages.h,v 2.17 2021/01/10 15:47:32 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.17 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "mboxlib.h"
#include "schedule_time.h"

#include "me.h"
#include "mailerlib.h"

#if ANSI_C
struct MailboxView;
#endif

typedef void mt_init_mailbox P_((struct MailboxView *mbx));
/* Data is free'ed also when wait is canceled */
typedef int mt_free_mailbox P_((struct MailboxView *mbx,
				 struct cancel_data *cd
				 ));
typedef void mt_add_mailbox_storage P_((struct MailboxView *mailbox,
					struct current_storage *storage));

/* Return 1 if redraw required */
typedef int mt_update_view_mailbox P_((struct MailboxView *mailbox));

typedef struct folder_info * mt_get_main_mailbox_folder P_((struct MailboxView *mailbox));

/* Can be called from signal handler */
typedef struct current_storage * mt_get_mailbox_storage P_((struct MailboxView *mailbox,
							    int i));

/* Can be called from signal handler */
typedef int mt_get_mailbox_storage_count P_((struct MailboxView *mailbox));

typedef struct header_rec * mt_give_header_mailbox P_((struct MailboxView *mailbox,
						       int index, 
						       struct folder_view *v));

typedef void mt_sort_mailbox_view P_((struct MailboxView *mailbox,
				      hdr_compare_func   *func));

/* Return 1 if succeed, 0 is fails --
   seeks to {header}->offset   (if ret_F set)
*/
typedef int mt_give_message_data_mailbox P_((struct MailboxView *mailbox,
					     int index,
					     struct header_rec **ret_header,
					     FILE              **ret_F,
					     struct counter_data *counter,
					     parse_mime_callback *parse_mime,
					     struct folder_view *v));

typedef void mt_write_mailbox_info P_((FILE *fp, struct MailboxView *mailbox,
				       int s, int cur_idx));
typedef struct string * mt_mailbox_title P_((struct MailboxView *mailbox));
typedef void mt_make_mailbox_view P_((struct MailboxView *mailbox));

typedef void mt_add_mailbox_digest P_((struct MailboxView *mailbox,
				       mime_t *list,
				       time_t received_time,
				       char *env_from,
				       FILE *F,
				       charset_t defcharset));

typedef const struct remote_server * mt_give_message_remote_server_mailbox P_((
           struct MailboxView *mailbox,
	   int index,
	   struct folder_view *v));

typedef int mt_give_message_menu_size P_(( struct MailboxView * mailbox,
					   struct folder_view * v,
					   unsigned long      * ret_size));


#define MAILBOXTYPE_magic       0xF502

struct mailbox_type {
    unsigned short            magic;      /* MAILBOXTYPE_magic */

    mt_init_mailbox                * mt_init_it;
    mt_free_mailbox                * mt_free_it;
    mt_add_mailbox_storage         * mt_add_it_storage;
    mt_update_view_mailbox         * mt_update_view_it;
    mt_get_main_mailbox_folder     * mt_get_main_it_folder;
    mt_get_mailbox_storage         * mt_get_it_storage;
    mt_get_mailbox_storage_count   * mt_get_it_storage_count;
    mt_give_header_mailbox         * mt_give_header_it;
    mt_sort_mailbox_view           * mt_sort_it_view;
    mt_give_message_data_mailbox   * mt_give_message_data_it;
    mt_write_mailbox_info          * mt_write_it_info;
    mt_mailbox_title               * mt_it_title;
    mt_make_mailbox_view           * mt_make_it_view;
    mt_add_mailbox_digest          * mt_add_it_digest;
    mt_give_message_remote_server_mailbox * mt_give_message_remote_server_it;
    mt_give_message_menu_size      * mt_give_message_msize_it;
};

#define STATUSTYPE_magic	0xF508

typedef char * mt_show_status_message P_((struct MailboxView *mailbox,
					  int index, 
					  struct folder_view *v));
typedef int   mt_ison_status_message  P_((struct MailboxView *mailbox,
					  int index, 
					  struct folder_view *v,
					  enum status_x t, int mask));
typedef int   mt_setf_status_message  P_((struct MailboxView *mailbox,
					  int index, 
					  struct folder_view *v,
					  enum status_x t, int mask));
typedef int   mt_clearf_status_message  P_((struct MailboxView *mailbox,
					    int index, 
					    struct folder_view *v,
					    enum status_x t, int mask));


extern struct status_type {
    unsigned short            magic;      /* STATUSTYPE_magic */


    mt_show_status_message   * mt_show_status_it;
    mt_ison_status_message   * mt_ison_status_it;
    mt_setf_status_message   * mt_setf_status_it;
    mt_clearf_status_message * mt_clearf_status_it;

} status_common;

#define MAILBOXVIEW_magic	0xF500

struct MailboxView {
    unsigned short            magic;      /* MAILBOXVIEW_magic */
    struct mailbox_type     * mailbox_type;
    struct status_type      * status_type;

    union {
	struct mv_storage           * storage;

	struct mv_digest            * digest;
	
	struct mv_partial           * partial;

	struct mv_canceldir         * canceldir;

	struct mv_duplicate         * duplicate;

	struct mv_thread            * one_thread;

	void                        * dummy;                      
    } u;

    struct folder_view      * view;
    int                       view_len;

    struct ThreadView       * thread_view;

    struct menu_separator  ** separators;
    int                       separators_len;

    struct today_info       * today_info;
    
    /* Values set by caller */
    int        current;
    int        selected;
    struct string           * mailbox_title;

    unsigned int   rebuild_menu_date:1;   /* Need recall make_menu_date() 
					    update_separators() resets this
					 */
};

extern void free_thread_view P_((struct ThreadView **thread_view));

typedef struct header_rec * sdt_give_header_s P_((struct sort_data *s,
						  struct folder_view *v));

#define SORTDATATYPE_magic      0xF503

struct sort_data_type {
    unsigned short            magic;      /* SORTDATATYPE_magic */

    sdt_give_header_s       * sdt_give_header;
};

/* Needed extra structure for sorting so passing of
   global data is not needed
*/
struct sort_data {
    struct sort_data_type  * sort_data_type;
    struct folder_view       w;
    struct ThreadView      * t;
    union {
	struct current_storage *mbx;
	struct current_digest  *dgt;
	struct partial_sort    *part;
	struct mv_canceldir    *canceldir;
	struct duplicate_sort  * dup;
	struct one_thread_sort * thread;
	void                   *dummy;
    } u;
};

extern struct MailboxView *give_canceldir P_((void));

/* messages.c */

extern struct MailboxView * malloc_view P_((struct mailbox_type *t));
extern void NO_add_mailbox_storage P_((struct MailboxView *mailbox,
				       struct current_storage *storage));

/* status_common.c */

extern char *show_message_status P_((struct header_rec *hdr));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
