static char rcsid[] = "@(#)$Id: status.c,v 2.4 2014/11/15 11:00:25 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_messages.h"

DEBUG_VAR(Debug,__FILE__,"messages");

char * show_status_message(mailbox,index)
     struct MailboxView *mailbox;
     int index;
{
    if (mailbox->magic         != MAILBOXVIEW_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"show_status_message",
	      "Bad magic number",0);

    if (mailbox->status_type->magic != STATUSTYPE_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"show_status_message",
	      "Bad type magic number",0);

    if (index < 0 || index >= mailbox->view_len)
	return NULL;

    return mailbox->status_type->mt_show_status_it(mailbox,index,
						   & mailbox->view[index]);
}

int  ison_status_message(mailbox,index,t,mask)
     struct MailboxView *mailbox;
     int index;
     enum status_x t; 
     int mask;
{
    if (mailbox->magic         != MAILBOXVIEW_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"ison_status_message",
	      "Bad magic number",0);
    
    if (mailbox->status_type->magic != STATUSTYPE_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"ison_status_message",
	      "Bad type magic number",0);
    
    if (index < 0 || index >= mailbox->view_len)
	return 0;
    
    return mailbox->status_type->mt_ison_status_it(mailbox,index,
						   & mailbox->view[index],
						   t,mask);
}

int  setf_status_message(mailbox,index,t,mask)
     struct MailboxView *mailbox;
     int index;
     enum status_x t; 
     int mask;
{
    if (mailbox->magic         != MAILBOXVIEW_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"setf_status_message",
	      "Bad magic number",0);
    
    if (mailbox->status_type->magic != STATUSTYPE_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"setf_status_message",
	      "Bad type magic number",0);
    
    if (index < 0 || index >= mailbox->view_len)
	return 0;
    
    return mailbox->status_type->mt_setf_status_it(mailbox,index,
						   & mailbox->view[index],
						   t,mask);
}

int  clearf_status_message(mailbox,index,t,mask)
     struct MailboxView *mailbox;
     int index;
     enum status_x t; 
     int mask;
{
    if (mailbox->magic         != MAILBOXVIEW_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"clearf_status_message",
	      "Bad magic number",0);
    
    if (mailbox->status_type->magic != STATUSTYPE_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"clearf_status_message",
	      "Bad type magic number",0);
    
    if (index < 0 || index >= mailbox->view_len)
	return 0;
    
    return mailbox->status_type->mt_clearf_status_it(mailbox,index,
						   & mailbox->view[index],
						   t,mask);
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
