static char rcsid[] = "@(#)$Id: status_common.c,v 2.7 2021/05/24 16:26:45 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * show_message_status() is based on show_status() on Elm 2.4 
 *   ../src/screen.c.
 * That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 * Incorparated Elm 2.5 code from src/screen.c (show_message_status()):
 * That code was following copyright:
 *
 *  The Elm Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_messages.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"messages");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

char *show_message_status(hdr)
     struct header_rec *hdr;
{
    /* Based on show_status() on src/screen.c */

    /** This routine returns a pair of characters indicative of
	the status of this message.  The first character represents
	the interim status of the message (e.g. the status within 
	the mail system):

	x = Message downloaded but not on mailbox (message lost)
	E = Expired message
	N = New message
	O = Unread old message	dsi mailx emulation addition
	D = Deleted message
	r = Message replied
	_ = (space) default 

        X = eXpunged (IMAP)

	and the second represents the permanent attributes of the
	message:

	C = Company Confidential message
	U = Urgent (or Priority) message
	P = Private message
	A = Action associated with message
	M = MIME compliant message which needs metamail
	? = Unsupported MIME version
	m = Non-MIME message which needs metamail
	a = is a attachment
	h = header error
	f = Includes message fragment (message/partial)
	! = Message not downloaded
        # = Message not handled (NODATA)
	d = Message is delivery status notification (DSN)
	_ = (space) default
    **/

    static char mybuffer[3];
    
    DPRINT(Debug,11,(&Debug,"show_message_status: hdr=%p\n",hdr));
    
    /** the first character, please **/
    
    mybuffer[0] = ' ';
    mybuffer[1] = ' ';
    mybuffer[2] = '\0';

    mbx_status_hook(hdr,mybuffer);

    if (' ' == mybuffer[0]) {
	if (hdr->status1 & S1_RECONNECT_LOST) mybuffer[0] = 'x';	
	else if (hdr->status & DELETED)	mybuffer[0] = 'D';
	else if (hdr->status & EXPIRED)	mybuffer[0] = 'E';
	else if (hdr->status & NEW)	mybuffer[0] = 'N';
	else if (hdr->status & UNREAD)	mybuffer[0] = 'O';
 	else if ((show_reply) && 
 		 (hdr->status & REPLIED_TO))	mybuffer[0] = 'r';
    }

    /** and the second... **/
    
    if (' ' == mybuffer[1]) {
	int z;
	if (! hdr->body_parsed) {             
	    if (hdr->status1 & S1_NODATA)
		mybuffer[1] = '#';
	    else
		mybuffer[1] = '!';
	} else if (hdr->header_error)        mybuffer[1] = 'h';
	else if (mime_type_is_dsn(& (hdr->mime_rec)))
		                             mybuffer[1] = 'd';
	else if (hdr->status & CONFIDENTIAL) mybuffer[1] = 'C';
	else if (hdr->status & URGENT)       mybuffer[1] = 'U';
	else if (hdr->status & PRIVATE_MAIL) mybuffer[1] = 'P';
	else if (hdr->status & ACTION)       mybuffer[1] = 'A';
	else if (hdr->encrypted)             mybuffer[1] = 'e';
	else if ((hdr->status & MIME_MESSAGE) && 
		 (hdr->status & MIME_UNSUPPORTED))
	                                     mybuffer[1] = '?';
	else if ((hdr->status & MIME_MESSAGE) && 
		 hdr->mime_rec.disposition != DISP_INLINE) 
	                                     mybuffer[1] = 'a'; 
	else if ((hdr->status & MIME_MESSAGE) && hdr->mime_rec.mime_flags) {
	    int flags = get_type_flags(hdr->mime_rec.TYPE);
	    if (flags & MIME_SIGNED)         mybuffer[1] = 's';
	    else if (flags & MIME_ENCRYPTED) mybuffer[1] = 'p';
	    else if (flags & MIME_PARTIAL)   mybuffer[1] = 'f';
	    else                             mybuffer[1] = 'M';

	}
	else if ((hdr->status & MIME_MESSAGE) &&
		 (z = get_type_flags(hdr->mime_rec.TYPE)) &&
		 ( z & MIME_PARTIAL))        mybuffer[1] = 'f';       
	else if ((hdr->status & PRE_MIME_CONTENT) && hdr->mime_rec.mime_flags)
	                                     mybuffer[1] = 'm';
	else if (hdr->partial_len)           mybuffer[1] = 'f';
	
	else if (use_PGP) {
	    if (hdr->pgp & PGP_MESSAGE)     mybuffer[1] = 'P';
	    else if (hdr->pgp & PGP_SIGNED_MESSAGE) mybuffer[1] = 'S';
	    else if (hdr->pgp & PGP_PUBLIC_KEY)  mybuffer[1] = 'K';
	    else goto no_pgp;
	} else 
	no_pgp:
	    if (hdr->override_charset)      mybuffer[1] = 'o';
    }

    DPRINT(Debug,11,(&Debug, "show_message_status=%s\n", mybuffer));
    
    return( mybuffer);
}

S_(mt_show_status_message mt_show_status_common)
static char * mt_show_status_common P_((struct MailboxView *mailbox,
					int index, 
					struct folder_view *v));
static char * mt_show_status_common(mailbox,index,v)
     struct MailboxView *mailbox;
     int index; 
     struct folder_view *v;
{
    struct header_rec *hdr;

    if (mailbox->mailbox_type->magic != MAILBOXTYPE_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"mt_show_status_common",
	      "Bad type magic number",0);

    hdr = mailbox->mailbox_type->mt_give_header_it(mailbox,index,v);

    if (!hdr)
	return NULL;	

    return show_message_status(hdr);
}

S_(mt_ison_status_message mt_ison_status_common)
static int   mt_ison_status_common  P_((struct MailboxView *mailbox,
					int index, 
					struct folder_view *v,
					enum status_x t, int mask));
static int   mt_ison_status_common(mailbox,index,v,t,mask)
     struct MailboxView *mailbox;     int index;
     struct folder_view *v;
     enum status_x t; 
     int mask;
{
    struct header_rec *hdr;
    int r = 0;
    
    if (mailbox->mailbox_type->magic != MAILBOXTYPE_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"mt_ison_status_common",
	      "Bad type magic number",0);

    hdr = mailbox->mailbox_type->mt_give_header_it(mailbox,index,v);

	
    if (hdr) {
	switch (t) {
	case status_basic:
	    r = ison(hdr->status,mask);
	    break;
	case status_1:
	    r = ison(hdr->status1,mask);
	    break;
	default:
	    panic("MBX VIEW PANIC",__FILE__,__LINE__,
		  "mt_ison_status_common",
		  "bad status type",0);		
	}
    }

    return r;
}

S_(mt_setf_status_message mt_setf_status_common)
static int   mt_setf_status_common  P_((struct MailboxView *mailbox,
					int index, 
					struct folder_view *v,
					enum status_x t, int mask));
static int   mt_setf_status_common(mailbox,index,v,t,mask)
     struct MailboxView *mailbox;
     int index;
     struct folder_view *v;
     enum status_x t; 
     int mask;
{
    struct header_rec *hdr;
    int r = 0;

    if (mailbox->mailbox_type->magic != MAILBOXTYPE_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"mt_setf_status_common",
	      "Bad type magic number",0);

    hdr = mailbox->mailbox_type->mt_give_header_it(mailbox,index,v);

    if (hdr) {
	switch (t) {
	    
	case status_basic:
	    setit(hdr->status,mask);
	    r = hdr->status;
	    break;
	    
	case status_1:
	    setit(hdr->status1,mask);
	    r = hdr->status1;
	    break;
	    
	default:
	    panic("MBX VIEW",__FILE__,__LINE__,"mt_setf_status_common",
		  "bad status type",0);	    
	}

	/* TODO: What status codes should cause flagging??? */
	hdr->status_chgd = TRUE;
    }
	
    return r;
}

S_(mt_clearf_status_message mt_clearf_status_common)
static int   mt_clearf_status_common  P_((struct MailboxView *mailbox,
					   int index, 
					   struct folder_view *v,
					   enum status_x t, int mask));
static int   mt_clearf_status_common(mailbox,index,v,t,mask)
     struct MailboxView *mailbox;
     int index;
     struct folder_view *v;
     enum status_x t; 
     int mask;
{
    struct header_rec *hdr;
    int r = 0;

    if (mailbox->mailbox_type->magic != MAILBOXTYPE_magic)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"mt_clearf_status_common",
	      "Bad type magic number",0);

    hdr = mailbox->mailbox_type->mt_give_header_it(mailbox,index,v);

    if (hdr) {
	switch (t) {
	case status_basic:
	    clearit(hdr->status,mask);
	    r = hdr->status;
	    break;

	case status_1:
	    clearit(hdr->status1,mask);
	    r = hdr->status1;
	    break;
	    
	default:
	    panic("MBX VIEW PANIC",__FILE__,__LINE__,
		  "mc_clearf_status_mbx",
		  "bad status type",0);		
	}
	    
	/* TODO: What statuses should cause flagging??? */
	hdr->status_chgd = TRUE;
    }

    return r;
}

struct status_type status_common = {
    STATUSTYPE_magic,
    mt_show_status_common,
    mt_ison_status_common,
    mt_setf_status_common,
    mt_clearf_status_common
};

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
