static char rcsid[] = "@(#)$Id: openmailbox.c,v 2.13 2020/01/29 16:20:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * This routine mimics some routines from src/quit.c
 * That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_elm.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"ELM");

/* Opens new mailbox to current mailbox view without closing current mailbox */
int OpenMailbox(mailbox,aview,parent_page)
     struct MailboxView *mailbox;
     struct AliasView *aview;
     struct menu_context  *parent_page;
{
    int retch = '\0';
    
    struct folder_info *new_folder = NULL;
    struct folder_browser * XXX = new_browser(selection_folder);
    struct string         * buffer = NULL;

    enum sessionlock_status ret = sessionlock_fail;
    
    struct fbrowser_call * Fcall = 
	alloc_fbrowser_call_f(FB_EXIST|FB_READ,
			     CATGETS(elm_msg_cat, MeSet, 
				     MeAskOpenFolderFB,
				     "Folder opening selection"));

    int mc;

    int current = get_current(mailbox);
    struct cancel_data *cd = NULL;
    
    const struct remote_server * remote_server =
	give_message_remote_server(mailbox,current-1);

    if (remote_server)
	browser_set_remote_server(XXX,remote_server);

 ask_again:
    while(1) {
	int mbc,i;
	
	new_folder = folder_browser(parent_page,
				    XXX,&buffer,
				    Fcall,
				    aview,
				    mailbox,
				    CATGETS(elm_msg_cat, MeSet, 
					    MeAskOpenFolder,
					    "Open which folder: "));
	if (!new_folder)
	    break;
	
	DPRINT(Debug,3,(&Debug,  
			"OpenMailbox(%p): new folder = %p\n",
			mailbox,new_folder));
	

	mbc = get_storage_count(mailbox);
	
	for (i = 0; i < mbc; i++) {
	    struct current_storage *storage = get_storage(mailbox,i);

	    if (!storage)
		continue;

	    /* do not accept the same file as the current */
	    if (storage->current_folder && 
		selection_is_folder(XXX,storage->current_folder)) {
		int r;
		
		lib_error(CATGETS(elm_msg_cat, MeSet, 
				  MeFolderAlreadyOpened,
				  "Folder %S is already opened to current view."),
			  buffer);
	    
		/* Closing of IMAP folder may clear that error message
		 * so sleep on here ...
		 */
		
		FlushBuffer();
		sleep_message();

		setup_mbx_cancel_message(&cd,mbx_leaving_mailbox);

		DPRINT(Debug,9, (&Debug, 
				 "OpenMailbox: leaving new_folder\n"));		
		r = leave_old_folder(&new_folder,CLOSE_NORMAL,cd);
		if (!r) {
		    DPRINT(Debug,9, (&Debug, 
				     "OpenMailbox: leave_old_folder failed\n"));
		}	
		if (is_canceled(cd)) {
		    DPRINT(Debug,9, (&Debug, 
				     "OpenMailbox: Cancel on leave_old_folder\n"));
		}
		free_cancel(&cd);
		
		
		goto ask_again;	/* prompt again */
	    }	
	}


	/* Make sure this is a file the user can open, unless it is 
	 * the default mailfile, which is openable even if empty 
	 */

	ret = sessionlock_folder(new_folder,SESSIONLOCK_CHECK,NULL,NULL);
	switch (ret) {
	    int r;

	case sessionlock_fail:
	    setup_mbx_cancel_message(&cd,mbx_leaving_mailbox);

	    DPRINT(Debug,9, (&Debug, 
			     "OpenMailbox: leaving new_folder\n"));	
	    r = leave_old_folder(&new_folder,CLOSE_NORMAL,cd);
	    if (!r) {
		DPRINT(Debug,9, (&Debug, 
				 "OpenMailbox: leave_old_folder failed\n"));
	    }	
	    if (is_canceled(cd)) {
		DPRINT(Debug,9, (&Debug, 
				 "OpenMailbox: Cancel on leave_old_folder\n"));
	    }
	    free_cancel(&cd);
		
	    continue; 	/* prompt again */
	case sessionlock_open:
	    DPRINT(Debug,4,(&Debug,
			    "OpenMailbox: Folder can be opened.\n"));
	    break;
	case sessionlock_reconnect:
	    DPRINT(Debug,4,(&Debug,
			    "OpenMailbox: Folder reconnected.\n"));

	    break;
	}
	
	break;  /* exit loop - we got the name of a good file */
    }

    if (new_folder) {	
	struct quota_display * quotad = NULL;
	struct mail_quota    * mquota = NULL;	
	
	int  old = get_selected(mailbox);

	enum show_mail_quota_v  smq =
	    give_dt_enumerate_as_int(&show_mail_quota_e); 
	
	DPRINT(Debug,20, (&Debug, 
			  "OpenMailbox: show-mail-quota=%d",smq));
	switch (smq) {
	case show_mquota_OFF:     DPRINT(Debug,20, (&Debug, " show_mquota_OFF"));     break;
	case show_mquota_ON_open: DPRINT(Debug,20, (&Debug, " show_mquota_ON_open")); break;
	case NUM_show_mail_quota: DPRINT(Debug,20, (&Debug, " NUM_show_mail_quota")); break;
	}
	DPRINT(Debug,20, (&Debug, "\n"));
	
	if (old) {
	    DPRINT(Debug,4,(&Debug,
			    "OpenMailbox: %d messages was selected.\n",old));
	    
	}

	switch (smq) {
	case show_mquota_OFF:
	    DPRINT(Debug,20, (&Debug, 
			      "OpenMailbox: mail quota display disabled\n"));
	    break;
	case show_mquota_ON_open: 	    
	    mquota = have_folder_quota(new_folder);
	    DPRINT(Debug,20, (&Debug, 
			      "OpenMailbox: mail quota %s\n",
			      mquota ? "supported" : "not available"));
	    break;
	case NUM_show_mail_quota:  break;
	}

	
	if (mquota) {
	    setup_mbx_cancel_message(&cd,mbx_checking_mailbox);

	    quotad = new_quota_display(mquota,parent_page,cd);
	    
	    if (is_canceled(cd)) {
		DPRINT(Debug,9, (&Debug, 
				 "OpenMailbox: Cancel on new_quota_display\n"));
		goto cleanup1;
	    }
	    free_cancel(&cd);
	}
	    	    
	add_new_mailbox(new_folder,mailbox,parent_page, quotad);
	new_folder = NULL;

	mc = get_message_count(mailbox);
	DPRINT(Debug,4,(&Debug,
			"OpenMailbox: %d messages total.\n",mc));

	if (old) {
	    int i, selected = 0;
	    
	    for (i = 0; i < mc; i++) {
		if ( ison_status_message(mailbox,i,status_basic,VISIBLE))
		    selected++;
	    }
	    
	    DPRINT(Debug,4,(&Debug,"  -> Now %d messages selected  (was %d).\n",
			selected,old));

	    set_selected(mailbox,selected);
	}

	if (quotad)
	    retch = quota_display_show(quotad,NULL /* No commands list */);

    cleanup1:
	if (mquota)
	    free_mail_quota(&mquota);
	if (quotad)
	    free_quota_display(&quotad,parent_page);
    }

     if (new_folder) {
	int r;
	DPRINT(Debug,9, (&Debug, 
			 "OpenMailbox: cleanup new folder\n"));

	setup_mbx_cancel_message(&cd,mbx_leaving_mailbox);

	DPRINT(Debug,9, (&Debug, 
			 "OpenMailbox: leaving new_folder\n"));	
	r = leave_old_folder(&new_folder,CLOSE_NORMAL,cd);
	if (!r) {
	    DPRINT(Debug,9, (&Debug, 
			     "OpenMailbox: leave_old_folder failed\n"));
	}	
	if (is_canceled(cd)) {
	    DPRINT(Debug,9, (&Debug, 
			     "OpenMailbox: Cancel on leave_old_folder\n"));
	}	
    }
    
    if (cd)
	free_cancel(&cd);
    
    free_fbrowser_call(&Fcall);
    free_dir(&XXX);
    if (buffer)
	free_string(&buffer);

    DPRINT(Debug,9, (&Debug,
		     "OpenMailbox=%d",
		      retch));
     if (isascii(retch) && isprint(retch)) {
	 DPRINT(Debug,9, (&Debug," (%d)",
			  retch));
     } else if (EOF == retch) {
	 DPRINT(Debug,9, (&Debug," EOF"));
     }
     DPRINT(Debug,9, (&Debug,"\n"));

    return retch;
}

void OpenMailboxPost(mailbox,page,LOC)
     struct MailboxView *mailbox;
     struct menu_context  *page;
     struct screen_parts *LOC;
{
    
    {
	struct menu_common MENU;
	set_mcommon_from_mbxview(&MENU,mailbox);

	get_page(&MENU, LOC->header_page);  /* resort_mailbox no longer call get_page() */
    }

    menu_trigger_redraw(LOC->header_page);
    menu_trigger_redraw(LOC->title_page);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
