static char rcsid[] = "@(#)$Id: helper.c,v 1.7 2024/10/13 10:57:10 hurtta Exp $";

/************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *  Partially based on src/builtin++.c, which is initially 
 *     written by: Michael Elkins <elkins@aero.org>, 1995
 *
 ************************************************************************/

#include "def_pager.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"pager");

#define PAGER_HELPER_DATA_magic	0xEB22

     
const struct pager_helper_data NULL_pager_helper_data = {
    PAGER_HELPER_DATA_magic,

    0,-1,
    0,
    
    0,0,0,0
};
				  				
enum pager_helper_status pager_helper_process_line(ctx,get_line,
						   pager_buffer,helper_data_sp,
						   wrap_info,current_line,
						   current_pager_range,
						   helper_data_pg,current_alt_data,
						   get_range_param)
     struct menu_context      * ctx;
     helper_get_line_f        * get_line;
     union pager_help_param     pager_buffer;
     struct span_helper_data  * helper_data_sp;
     struct pg_wrap_info      * wrap_info;
     struct string           ** current_line;
     struct pager_range      ** current_pager_range;
     struct pager_helper_data * helper_data_pg;
     struct string_alt       ** current_alt_data;   /* NULL if not supported */
     helper_get_param_f       * get_range_param;
{
    enum pager_helper_status ret = phelper_failure;
    enum span_result span_line_result = span_failure;
    
    int was_start_of_line;
    int buffer_len = 0;

    struct string           * L_buffer      = *current_line;
    struct string_alt       * L_alt_data    = NULL;
    struct pager_range      * L_pager_range = *current_pager_range;
    enum pager_range_opcode opcode = pr_opcode_none;

    if (current_alt_data)
	L_alt_data = * current_alt_data;
    
    if (SPAN_HELPER_DATA_magic != helper_data_sp->magic)
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "pager_helper_process_line",
	      "Bad magic number (span_helper_data)",0);

    was_start_of_line = helper_data_sp->start_of_line;

    helper_data_sp->this_flags  = 0;
    helper_data_sp->range_flags = 0;
    
    DPRINT(Debug,9,(&Debug, 
		    "pager_helper_process_line: before line  idx = %d (virtual %d) buffer_x=%d start_of_line=%d",
		    helper_data_sp->idx,
		    helper_data_sp->virtual_line,
		    helper_data_sp->buffer_x,
		    helper_data_sp->start_of_line));

    if (helper_data_sp->start_of_line && helper_data_sp->on_space) {
	DPRINT(Debug,9,(&Debug, ", resetting on_space"));
	helper_data_sp->on_space = 0;
    } else {
	DPRINT(Debug,9,(&Debug,
			" on_space=%d",
			helper_data_sp->on_space));
    }
    DPRINT(Debug,9,(&Debug,"\n"));

    DPRINT(Debug,10,(&Debug, 
		     "pager_helper_process_line: cur_line=%d, cur_col=%d\n",
		     helper_data_sp->cur_line,helper_data_sp->cur_col));

    if (PAGER_HELPER_DATA_magic != helper_data_pg->magic)
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "pager_helper_process_line",
	      "Bad magic number (pager_helper_data)",0);
    
    if ((!L_buffer && !L_alt_data) || 
	(L_buffer && helper_data_sp->buffer_x >= (buffer_len = string_len(L_buffer)))) {

	enum range_changed range_changed = rc_same_range;
	/* caller of get_line_from_stringbuffer is expected to 
	   free_string () resulting buffer */
	
	if (L_buffer) {
	    if (helper_data_sp->buffer_x >= buffer_len &&
		!helper_data_sp->lineext) {

		DPRINT(Debug,9,(&Debug, 
				"pager_helper_process_line: buffer_x = %d (buffer_len = %d) end of line %d\n",
				helper_data_sp->buffer_x,buffer_len,helper_data_sp->idx));

		helper_data_sp->idx++;

	    }
	    free_string (&L_buffer);
	    if (L_alt_data)
		free_string_alt(& L_alt_data);
	}
		
	helper_data_sp->buffer_x = 0;

	/* There is no pending data to output, so we need to grab 
	 * another line.
	 */

	if (helper_data_sp->lineext) {

	    if (current_alt_data) {
		L_alt_data = get_lineext_alt_and_walk(&(helper_data_sp->lineext),
						      &(helper_data_pg->pg_flags),
						      &range_changed,
						      &L_pager_range);
		buffer_len = -1;

		if (L_alt_data) {
		    enum string_alt_type alt_data_type = string_alt_none;
		    const union string_alt_value alt_data_value
			= get_string_alt_value(L_alt_data,&alt_data_type);

		    switch (alt_data_type) {
		    case string_alt_none:
			DPRINT(Debug,9,(&Debug,
					"pager_helper_process_line: new line extension on line %d (alt data) -- no data\n"));

			break;
		    case string_alt_text:
			L_buffer = dup_string(alt_data_value.text);
			buffer_len = string_len(L_buffer);

			DPRINT(Debug,9,(&Debug,
					"pager_helper_process_line: new line extension on line %d (alt data) -- len = %d\n",
					helper_data_sp->idx,
					buffer_len));
						
			break;
		    case string_alt_entity:
			DPRINT(Debug,9,(&Debug,
					"pager_helper_process_line: new line extension on line %d (alt data) -- entity\n"));

			break;
		    }


		} else {
		    ret = phelper_EOD;  /* End of data */
		    goto out;
		}
		
	    } else {
		L_buffer = get_lineext_and_walk(&(helper_data_sp->lineext),
						&(helper_data_pg->pg_flags),
						&range_changed,
						&L_pager_range);   
		
		buffer_len = string_len(L_buffer);
		
		DPRINT(Debug,9,(&Debug,
				"pager_helper_process_line: new line extension on line %d -- len = %d\n",
				helper_data_sp->idx,
				buffer_len));		
	    }
	} else {

	    L_buffer = get_line(pager_buffer,
				helper_data_sp->idx,
				&(helper_data_pg->pg_flags),
				&range_changed,
				&L_pager_range,
				&(helper_data_sp->lineext));   
	    if (!L_buffer) {
		/* End of buffer */
		
		ret = phelper_EOD;  /* End of data */
		goto out;
	    }
	    
	    buffer_len = string_len(L_buffer);
	    
	    DPRINT(Debug,9,(&Debug, 
			    "pager_helper_process_line: new line idx=%d -- len = %d\n",
			    helper_data_sp->idx,
			    buffer_len));
	}	

	if (L_buffer) {
	    DEBUG_PRINT_STRING(Debug,12,
			       "pager_helper_process_line: buffer = ",
			       "                         : buffer > ",
			       L_buffer);
	}

	if (helper_data_sp->lineext) {
	    DPRINT(Debug,12,(&Debug, 
			     "pager_helper_process_line: have line extension\n"));
	}
	
	if (range_changed != rc_same_range || helper_data_sp->start_of_line) {
	    DPRINT(Debug,9,(&Debug, 
			    "pager_helper_process_line: range_changed=%d",
			    range_changed));
	    switch (range_changed) {
	    case rc_same_range: DPRINT(Debug,9,(&Debug, " rc_same_range")); break;
	    case rc_newline:    DPRINT(Debug,9,(&Debug, " rc_newline"));   break;
	    case rc_same_line:  DPRINT(Debug,9,(&Debug, " rc_same_line")); break;
	    }
	    if (helper_data_sp->start_of_line) {
		DPRINT(Debug,9,(&Debug, ", already on start of line"));
	    }
	    if (helper_data_sp->on_space) {
		DPRINT(Debug,9,(&Debug, ", resetting on_space"));
		helper_data_sp->on_space = 0;
	    }
	    DPRINT(Debug,9,(&Debug, "\n"));		
	}
	
	if (!(helper_data_sp->start_of_line)) {
	    switch (range_changed) {
	    case rc_same_range: break;

	    case rc_newline:
		/* Need new line */
		
		DPRINT(Debug,9,(&Debug, 
				"pager_helper_process_line: wrapping line because of pager range change\n"));
	    	    
		helper_data_sp->start_of_line = 1;
		goto wrap_line;
	    case rc_same_line:
		DPRINT(Debug,9,(&Debug, 
				"pager_helper_process_line: range changed without line wrapping\n"));
		helper_data_sp->start_of_range = 1;
		break;
	    }
	}
    }

    if (L_pager_range) {
	opcode = get_pager_range_opcode(L_pager_range);
	
	DPRINT(Debug,9,(&Debug, 
			"pager_helper_process_line: opcode=%d",
			opcode));
	switch (opcode) {
	case pr_opcode_none:           DPRINT(Debug,9,(&Debug," pr_opcode_none"));          break;
	case pr_opcode_pager_replace:  DPRINT(Debug,9,(&Debug," pr_opcode_pager_replace")); break;
	}
	DPRINT(Debug,9,(&Debug, "\n"));

	if (helper_data_sp->start_of_line &&
	    0 == helper_data_sp->buffer_x &&
	    L_buffer &&
	    buffer_len > 0) {
	    
	    int range_flags = get_pager_range_flags(L_pager_range);

	    DPRINT(Debug,9,(&Debug, 
			    "pager_helper_process_line: range_flags=%d, buffer_len=%d",
			    range_flags,buffer_len));

	    if (ison(range_flags,PR_COLLAPSE_NOINHERIT)) {
		int pos;
		int on_space = 0;

		 DPRINT(Debug,9,(&Debug, 
				 ", collapse space"));
		
		for (pos = 0; pos < buffer_len; pos++) {
		    uint16         ch     = UNICODE_BAD_CHAR;

		    int gchar_flags = give_character_from_string(L_buffer,pos,
								 &ch,NULL);
		    
		    if (isoff(gchar_flags,GCHAR_unicode)) 
			break;
		    
		    if (ch == UNICODE_NO_BREAK_SPACE)
			break;
		    
		    if (0 == unicode_ch(ch,UOP_space))
			break;

		    on_space = 1;
		}
		
		if (pos == buffer_len && on_space) {
		    DPRINT(Debug,9,(&Debug, 
				    ", only space on line, skipping\n"));
		    
		    helper_data_sp->on_space = 1;
		    helper_data_sp->buffer_x = pos;
		    ret = phelper_done;
		    goto out;
		}		
	    }
	    DPRINT(Debug,9,(&Debug, "\n"));	    
	}	
    }
    
    switch (opcode) {
    case pr_opcode_pager_replace:

	if (0 == helper_data_sp->buffer_x) {
	    
	    if (L_pager_range) {
		int next_param_pos = 0;
		int found_param_pos = -1;
		struct pager_param_value * builtin_param =
		    get_range_param(pager_buffer,L_pager_range,
				    pp_opcode_builtin,
				    &next_param_pos,
				    &found_param_pos);
		
		if (builtin_param) {
		    int replaced_text = 0;
		    
		    enum pager_param_type param_type = pp_type_none;
		    const union pager_param_uvalue uvalue =
			get_pager_param_uvalue(builtin_param,
					       &param_type);
		    
		    switch (param_type) {
		    case pp_type_none:     break;
			
		    case pp_type_text:
			if (L_buffer)
			    free_string(& L_buffer);

			L_buffer = dup_string(uvalue.text);
			buffer_len = string_len(L_buffer);
			replaced_text = 1;

			break;
		    }
		    		    
		    free_pager_param_value(&builtin_param);
		    if (replaced_text) {
			DPRINT(Debug,9,(&Debug, 
					"pager_helper_process_line: Changed text\n"));
			
			goto proceed_text;

		    }
		}
	    }
	    
	    helper_data_sp->buffer_x = buffer_len;
	    ret = phelper_done;
	    	    
	    /* Now hiding */
	
	    DPRINT(Debug,9,(&Debug, 
			    "pager_helper_process_line: Hiding line\n"));
	    
	    goto out;
	}
		
	/* FALLTHRU */

    proceed_text:
    case pr_opcode_none:
    
	if (helper_data_pg->search_matches >= 0 &&
	    helper_data_pg->search_matches == helper_data_sp->idx)
	    helper_data_sp->this_flags = pg_STANDOUT;
	else
	    helper_data_sp->this_flags = helper_data_pg->pg_flags;


	if (L_buffer) { 	
	    span_line_result = span_helper(ctx,L_pager_range,wrap_info,L_buffer,
					   helper_data_sp);
	} else if (L_alt_data) {

	    span_line_result = span_alt_data_helper(ctx,L_pager_range,wrap_info,
						    L_alt_data,
						    &L_buffer,
						    &(helper_data_pg->pg_flags),
						    helper_data_sp);

	    if (L_buffer)
		buffer_len = string_len(L_buffer);	    
	}

	break;    
    }

    DPRINT(Debug,9,(&Debug, 
		    "pager_helper_process_line: span_line_result=%d ",
		    span_line_result));
    
    switch (span_line_result) {
    case span_clear_alt_data:

	if (L_alt_data) {
	    DPRINT(Debug,9,(&Debug, "clearing alt data"));
	    
	    free_string_alt(& L_alt_data);

	    if (!L_buffer &&  !helper_data_sp->lineext) {
		DPRINT(Debug,9,(&Debug, "\n"));
		DPRINT(Debug,9,(&Debug, 
				"pager_helper_process_line: end of line %d",
				helper_data_sp->idx));

		helper_data_sp->idx++;
		helper_data_sp->buffer_x = 0;
	    }
	    
	    break;
	}
	DPRINT(Debug,9,(&Debug, 
			"no alt data (clearing alt data) - "));

	/* PASSTHRU */
	
    case span_failure:
	
	if (!was_start_of_line) {
	    DPRINT(Debug,9,(&Debug, 
			    "failure, trying restart from next line"));
	    
	    
	    helper_data_sp->start_of_line = 1;
	} else {
	    
	default:
	    DPRINT(Debug,9,(&Debug, 
			    "failure, OOPS\n"));
		    
	    ret = phelper_failure;
	    goto out;
	}
	break;
				    
    case span_ok:
	DPRINT(Debug,9,(&Debug, 
			"ok"));
	break;
    case span_FF_seen:
	DPRINT(Debug,9,(&Debug, 
			"FF_seen"));
	helper_data_pg->FF_seen = 1;
	helper_data_sp->start_of_line = 1;
	break;
    case span_EOS:
	DPRINT(Debug,9,(&Debug, 
			"at end of string"));
	break;
    case span_NL_seen:
	DPRINT(Debug,9,(&Debug, 
			"new line seen"));
	helper_data_sp->start_of_line = 1;

	break;
    case span_wrapping:
	DPRINT(Debug,9,(&Debug, 
			"wrapping"));
	helper_data_sp->start_of_line = 1;
	helper_data_pg->hard_wrapped  = 1;

	if (ison(helper_data_sp->range_flags,PR_PREFORMAT))
	    helper_data_pg->preformatted = 1;
	break;
    case span_wordwrapped:
	DPRINT(Debug,9,(&Debug, 
			"word wrapped"));
	helper_data_sp->start_of_line = 1;
	helper_data_pg->word_wrapped = 1;
	break;
    case span_space_collapsed:
	DPRINT(Debug,9,(&Debug, 
			"space collapsed"));
    }
    DPRINT(Debug,9,(&Debug, "\n"));
    
    /* Make sure that carbage from previous
       output is not left */
    if (helper_data_sp->mayclear) {
	menu_CleartoEOLN(ctx);
	helper_data_sp->mayclear = 0;
    }
  
    if (helper_data_sp->start_of_line) {
    wrap_line:
	menu_Writechar(ctx,'\r');		    
	menu_Writechar(ctx,'\n');		    
	helper_data_sp->cur_line++;
	helper_data_sp->cur_col = 0;

	helper_data_sp->joined_line = 0;
	helper_data_sp->p_start_COL = 0;
    }

    if (helper_data_pg->scroll_line) {
	int x, y;
	
	menu_GetXYLocation (ctx,&x, &y);
	if (x != helper_data_sp->cur_line) {
	    DPRINT(Debug,9,(&Debug, 
			    "pager_helper_process_line: line scrolled, lines=%d (not %d)\n",
			    x,helper_data_sp->cur_line));
	    helper_data_sp->cur_line = x;
	    helper_data_pg->scroll_line--;
	}
    }
    ret = phelper_done;

 out:
    *current_line        = L_buffer;
    *current_pager_range = L_pager_range;

    if ( current_alt_data)
	* current_alt_data = L_alt_data;
    else if (L_alt_data)
	free_string_alt(& L_alt_data);
    

    DPRINT(Debug,10,(&Debug, 
		     "pager_helper_process_line=%d",ret));
    switch(ret) {
    case phelper_EOD:     DPRINT(Debug,10,(&Debug," end of data")); break;
    case phelper_failure: DPRINT(Debug,10,(&Debug," failure")); break;
    case phelper_done:    DPRINT(Debug,10,(&Debug," done")); break;
    }


    DPRINT(Debug,10,(&Debug,"\n"));
    return ret;
}

void pager_helper_end_of_page(ctx,helper_data_sp,helper_data_pg,
			      limit,print_tilde)
     struct menu_context      * ctx;
     struct span_helper_data  * helper_data_sp;
     struct pager_helper_data * helper_data_pg;
     int limit;
     int print_tilde;
{
    int LINES, COLUMNS;

    menu_get_sizes(ctx, &LINES, &COLUMNS);

    if (SPAN_HELPER_DATA_magic != helper_data_sp->magic)
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "pager_helper_end_of_page",
	      "Bad magic number (span_helper_data)",0);
    
    if (PAGER_HELPER_DATA_magic != helper_data_pg->magic)
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "pager_helper_end_of_page",
	      "Bad magic number (pager_helper_data)",0);
       
    if (! helper_data_sp->start_of_line) {
	menu_Writechar(ctx,'\r');		    
	menu_Writechar(ctx,'\n');		    
	helper_data_sp->cur_line++;
    }
    
    menu_CleartoEOS(ctx);
    if (helper_data_sp->cur_line < LINES-1 
	&& (limit < 0 || helper_data_sp->cur_line < limit)
	&& helper_data_pg->FF_seen) {
	menu_StartXX(ctx,pg_BOLD);
	menu_PutLineX (ctx,
		       helper_data_sp->cur_line, 0, 
		       CATGETS(elm_msg_cat, ElmSet, ElmBuiltinNewPage,
			       "~ (new page) "));
	menu_EndXX(ctx,pg_BOLD);  
	menu_CleartoEOLN(ctx);
	menu_Writechar(ctx,'\r');		    
	menu_Writechar(ctx,'\n');		    
	
	helper_data_sp->cur_line++;
    }

    while (helper_data_sp->cur_line < LINES-1
	   && (limit < 0 || helper_data_sp->cur_line < limit)
	   ) {
	if (print_tilde)
	    menu_Writechar(ctx,'~');
	menu_CleartoEOLN(ctx); 
	menu_Writechar(ctx,'\r');		    
	menu_Writechar(ctx,'\n');		    
	
	helper_data_sp->cur_line++;
    }

}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */



