static char rcsid[] = "@(#)$Id: wraprecord.c,v 1.5 2016/03/21 20:26:15 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *****************************************************************************/
#include "def_pager.h"

DEBUG_VAR(Debug,__FILE__,"pager");

#define PG_WRAP_INFO_magic   0xEB11

struct pg_wrap_info {
    unsigned short magic;    /* PG_WRAP_INFO_magic */

    struct {
	int buffer_idx; 
	int buffer_x;
	struct pager_lineext *buffer_lineext;
    } * wrap_info;
    int wrap_info_len;

} * new_pg_wrap_info()
{
    struct pg_wrap_info * ret = safe_malloc(sizeof (*ret));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)ret,sizeof (*ret));

    ret->wrap_info     = NULL;
    ret->wrap_info_len = 0;

    ret->magic = PG_WRAP_INFO_magic;

    return ret;
}

void free_pg_wrap_info(info)
     struct pg_wrap_info **info;

{
    if (PG_WRAP_INFO_magic != (*info)->magic) 
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "free_pg_wrap_info",
	      "Bad magic number",0);

    if ((*info)->wrap_info) {
	int i;

	for (i = 0; i < (*info)->wrap_info_len; i++) 
	    if ((*info)->wrap_info[i].buffer_lineext)
		free_pager_lineext(& ((*info)->wrap_info[i].buffer_lineext));

	free((*info)->wrap_info);
	(*info)->wrap_info = NULL;
    }
    (*info)->wrap_info_len = 0;

    free(*info);
    *info = NULL;
}

#define ALLOC_INCREMENT  256

/* Increments *virtual_line */
void record_pg_wrap_info(info,virtual_line,
			 buffer_idx,buffer_x,buffer_lineext)
     struct pg_wrap_info *info;
     int *virtual_line;
     int buffer_idx; 
     int buffer_x;
     struct pager_lineext *buffer_lineext;
{
    if (PG_WRAP_INFO_magic != info->magic) 
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "free_pg_wrap_info",
	      "Bad magic number",0);
    if (*virtual_line < 0 || buffer_idx < 0 || buffer_x < 0)
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "free_pg_wrap_info",
	      "Bad parameter",0);

    if (info->wrap_info_len <= *virtual_line) {
	int new_len = ( (*virtual_line) / ALLOC_INCREMENT + 1 ) 
	    * ALLOC_INCREMENT;
	
	info->wrap_info = safe_array_realloc(info->wrap_info,
					     new_len,
					     sizeof(info->wrap_info[0]));

	while (info->wrap_info_len < new_len) {
	    info->wrap_info[info->wrap_info_len]. buffer_idx = -1;
	    info->wrap_info[info->wrap_info_len]. buffer_x = -1;
	    info->wrap_info[info->wrap_info_len]. buffer_lineext = NULL;
	    info->wrap_info_len++;
	}
    }

    if (info->wrap_info_len <= *virtual_line) 
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "free_pg_wrap_info",
	      "Not alloced",0);	

    info->wrap_info[*virtual_line].buffer_idx = buffer_idx;
    info->wrap_info[*virtual_line].buffer_x   = buffer_x;

    if (info->wrap_info[*virtual_line].buffer_lineext)
	free_pager_lineext(& (info->wrap_info[*virtual_line].buffer_lineext));
    info->wrap_info[*virtual_line].buffer_lineext = buffer_lineext;
    if (info->wrap_info[*virtual_line].buffer_lineext)
	inc_pager_lineext_refcount(info->wrap_info[*virtual_line].buffer_lineext);

    (*virtual_line)++;
}

/* Returns 1 if info found and *buffer_idx, *buffer_x updated */
int goto_pg_wrap_info(info,virtual_line,
		      buffer_idx,buffer_x,buffer_lineext)
     struct pg_wrap_info *info;
     int virtual_line;
     int *buffer_idx; 
     int *buffer_x;
     struct pager_lineext ** buffer_lineext;
{
    if (PG_WRAP_INFO_magic != info->magic) 
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "goto_pg_wrap_info",
	      "Bad magic number",0);

    if (virtual_line < 0)
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "free_pg_wrap_info",
	      "Bad virtual_line",0);

    if (virtual_line < info->wrap_info_len &&
	info->wrap_info[virtual_line].buffer_idx >= 0 &&
	info->wrap_info[virtual_line].buffer_x >= 0) {

	if (buffer_idx)
	    *buffer_idx = info->wrap_info[virtual_line].buffer_idx;
	if (buffer_x)
	    *buffer_x   = info->wrap_info[virtual_line].buffer_x;
	
	if (buffer_lineext) {
	    if (*buffer_lineext)
		free_pager_lineext(buffer_lineext);
	    *buffer_lineext = info->wrap_info[virtual_line].buffer_lineext;
	    if (*buffer_lineext)
		inc_pager_lineext_refcount(*buffer_lineext);
	}

	return 1;
    }

    return 0;
}


/* Returns virtual line or -1 if not found
 *
 *   *real_buffer_idx gives really found ( *real_buffer_idx <= buffer_idx)
 */

int find_pg_wrap_info(info,buffer_idx,real_buffer_idx,buffer_x,buffer_lineext)
     struct pg_wrap_info * info;
     int                   buffer_idx;
     int                 * real_buffer_idx;
     int                 * buffer_x;
     struct pager_lineext ** buffer_lineext;
{
    int found_buffer_idx    = -1;
    int found_virtual_line  = -1;

    if (PG_WRAP_INFO_magic != info->magic) 
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "find_pg_wrap_info",
	      "Bad magic number",0);

    if (buffer_idx < 0)
	panic("PAGER PANIC",__FILE__,__LINE__,
	      "find_pg_wrap_info",
	      "Bad buffer_idx",0);

    if (info->wrap_info) {

	if (buffer_idx < info->wrap_info_len &&
	    info->wrap_info[buffer_idx].buffer_idx >= 0 &&
	    info->wrap_info[buffer_idx].buffer_x >= 0) {

	    /* first assume 1 <==> 1   division */

	    if (buffer_idx == info->wrap_info[buffer_idx].buffer_idx ) {
	    
		found_virtual_line = buffer_idx;
		found_buffer_idx   = buffer_idx;

	    } else if (buffer_idx < info->wrap_info[buffer_idx].buffer_idx ) {
		
		int scan;
		
		for (scan = buffer_idx; scan >= 0; scan--) {
		    if (info->wrap_info[scan].buffer_idx <= buffer_idx &&
			info->wrap_info[scan].buffer_idx >= 0 &&
			info->wrap_info[scan].buffer_x >= 0) {
			
			found_virtual_line = scan;
			found_buffer_idx   = info->wrap_info[scan].buffer_idx;
			break;
		    }
		}
		
	    } else if (buffer_idx > info->wrap_info[buffer_idx].buffer_idx) {
		
		int scan;
		
		for (scan = buffer_idx; scan < info->wrap_info_len; scan++) {
		    if (info->wrap_info[scan].buffer_idx <= buffer_idx &&
			info->wrap_info[scan].buffer_idx >= 0 &&
			info->wrap_info[scan].buffer_x >= 0) {
			
			found_virtual_line = scan;
			found_buffer_idx   = info->wrap_info[scan].buffer_idx;
		    } else
			break;		
		}

	    } else
		panic("PAGER PANIC",__FILE__,__LINE__,
		      "find_pg_wrap_info",
		      "buffer_idx ???",0);
	} else {

	    int scan;

	    for (scan = 0; scan < info->wrap_info_len; scan++) {
		if (info->wrap_info[scan].buffer_idx <= buffer_idx &&
		    info->wrap_info[scan].buffer_idx >= 0 &&
		    info->wrap_info[scan].buffer_x >= 0) {
		    
		    found_virtual_line = scan;
		    found_buffer_idx   = info->wrap_info[scan].buffer_idx;
		} else
		    break;		
	    }	   
	}       
    }

    if (real_buffer_idx) {  /* can also return previous line */
	*real_buffer_idx = found_buffer_idx;

	if (buffer_x)
	    *buffer_x   = info->wrap_info[found_virtual_line].buffer_x;

	if (buffer_lineext) {
	    if (*buffer_lineext)
		free_pager_lineext(buffer_lineext);
	    *buffer_lineext = info->wrap_info[found_virtual_line].
		buffer_lineext;
	    if (*buffer_lineext)
		inc_pager_lineext_refcount(*buffer_lineext);
	}

	return found_virtual_line;
    } else if (buffer_idx == found_buffer_idx) {

	if (buffer_x)
	    *buffer_x   = info->wrap_info[found_virtual_line].buffer_x;

	if (buffer_lineext) {
	    if (*buffer_lineext)
		free_pager_lineext(buffer_lineext);
	    *buffer_lineext = info->wrap_info[found_virtual_line].
		buffer_lineext;
	    if (*buffer_lineext)
		inc_pager_lineext_refcount(*buffer_lineext);
	}


	return found_virtual_line;
    } else
	return -1;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
