static char rcsid[] = "@(#)$Id: reconnect.c,v 2.1 2019/03/16 06:03:19 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_elm.h"
#include "s_me.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ELM");


const char * found_disconnected(mailbox)
     struct MailboxView *mailbox;
{
    int mbxcount          = get_storage_count(mailbox);
    int idx;

    for (idx = 0 ; idx < mbxcount; idx++) {
	struct current_storage * storage = get_storage(mailbox, idx);
	int mode;

	 if (!storage ||
	     !storage->current_folder)
	     continue;

	 mode = get_folder_mode(storage->current_folder);

	 if (ison(mode,FOLDER_DISCONNECTED)) {
	      const char * ftype = folder_type(storage->current_folder);

	      DPRINT(Debug,12, (&Debug,
				"found_disconnected=%s\n",
				ftype));

	      return ftype;
	 }
    }

    DPRINT(Debug,12, (&Debug,
		      "found_disconnected=NULL\n"));
    return NULL;
}
    
void update_selected_counter (mailbox)
     struct MailboxView *mailbox;
{
    int mc = get_message_count(mailbox);
    int old = get_selected(mailbox);
    
    int i, selected = 0;
    
    DPRINT(Debug,12,(&Debug, 
		     "update_selected_counter: %d messages total (was %d selected).\n",
		     mc,old));
    
    for (i = 0; i < mc; i++) {
	if ( ison_status_message(mailbox,i,status_basic,VISIBLE))
	    selected++;
        }
    
    DPRINT(Debug,12,(&Debug, 
		     "update_selected_counter: Now %d messages selected  (was %d).\n",
		     selected,old));
    
    set_selected(mailbox,selected);
}


int  ReconnectMailbox(mailbox,page)
     struct MailboxView *mailbox;
     struct menu_context  *page;
{
    int ch = '\0';

    int idx;
    int mbxcount   = get_storage_count(mailbox);
    int selected   = get_selected(mailbox);
    int found = 0;

    int   LINES, COLUMNS;	
    menu_get_sizes(page,&LINES, &COLUMNS);
       
     for (idx = 0 ; idx < mbxcount; idx++) {
	 struct current_storage * storage = get_storage(mailbox, idx);
	 int mode;

	 if (!storage ||
	     !storage->current_folder)
	     continue;

	 mode = get_folder_mode(storage->current_folder);

	 if (ison(mode,FOLDER_DISCONNECTED)) {
	     int last_in_folder = storage->message_count;
	     
	     int ok = reconnect_mails(storage,page);

	     if (ok) 
		 clear_error();

	      ClearLine(LINES-2);	     /* remove reading message... */
	      
	      if (ok) {
		  if ((storage->message_count - last_in_folder) == 1)
		      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNewMessageRecv,
					"1 new message received."));
		  else if (storage->message_count > last_in_folder)
		      lib_error(CATGETS(elm_msg_cat, ElmSet, 
					ElmNewMessageRecvPlural,
					"%d new messages received."), 
				storage->message_count - last_in_folder);		
	      }
	     
	     found = 1;
	 }
     }

     if (found && selected)
	 update_selected_counter(mailbox);

     if (!found)
	 lib_error(CATGETS(elm_msg_cat, MeSet,
			   MeNoDisconMailboxes,
			   "No disconnected mailboxes found"));

    return ch;
}

void ReconnectMailboxPost(mailbox,page,LOC)
     struct MailboxView *mailbox;
     struct menu_context  *page;
     struct screen_parts *LOC;
{
    menu_trigger_redraw(LOC->header_page);	
    menu_trigger_redraw(LOC->title_page);	
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

