static char rcsid[] = "@(#)$Id: save_opts.c,v 2.8 2023/12/13 16:55:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/save_opts.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains the routine needed to allow the users to change the
    Elm parameters and then save the configuration in a ".elm/elmrc" file in
    their home directory.  With any luck this will allow them never to have
    to actually EDIT the file!!

**/

#include "def_elm.h"
#include "s_elmrc.h"
#include <errno.h>

DEBUG_VAR(Debug,__FILE__,"config");

#undef onoff
#define   onoff(n)	(n == 0? "OFF":"ON")

#define absolute(x)		((x) < 0? -(x) : (x))

#ifndef errno
extern  int errno;
#endif
extern char version_buff[];



#include "rc_imp.h"
#include "save_opts.h"

int  check_options_backup_suffix(option,backup_suffix)
     const char * option /* for error message */;
     const char * backup_suffix;
{        
    return check_file_backup_suffix(user_rc_file,option,backup_suffix);
}



void save_options(backup_suffix)
     const char *backup_suffix;
{
    /** Save the options currently specified to a file.  This is a
	fairly complex routine since it tries to put in meaningful
	comments and such as it goes along.  The comments are
	extracted from the file ELMRC_INFO as defined in the sysdefs.h
	file.  THAT file has the format;

		varname
		  <comment>
		  <comment>
		<blank line>

	and each comment is written ABOVE the variable to be added.  This
	program also tries to make 'pretty' stuff like the alternatives
	and such.
    **/

    int r = 0;


    save_file_stats(user_rc_file,NULL);

    if (backup_suffix) {
	char * bck = elm_message(FRM("%s%s"),
				 user_rc_file,
				 backup_suffix);

	enum syscall_status r = link(user_rc_file,bck);

	switch (r) {
	    int err UNUSED_VAROK;
	case syscall_success:
	    DPRINT(Debug,4, (&Debug,
			     "save_options: Created backup %s => %s\n",
			     user_rc_file,bck));
	    break;
	    
	case syscall_error:
	    err = errno;
	    DPRINT(Debug,4, (&Debug,
			     "save_options: Backup link %s => %s failed: %s\n",
			     user_rc_file,bck,
			     strerror(err)));
			    
	    lib_error(CATGETS(elm_msg_cat, ElmrcSet, ElmrcBackupFailed,
			      "Backup %s => %s failed: %s"),
		      user_rc_file,bck,strerror(err));

	    free(bck);
	    return;
	}

	free(bck);
	
    } else {
	/* Use old routine */
	
	enum syscall_status  r1;
    
	/** first off, let's see if they already HAVE a .elm/elmrc file **/
	
	r1 = access(user_rc_file, ACCESS_EXISTS);
	switch (r1) {
	    int err UNUSED_VAROK;
	    enum syscall_status  r2;
	    char * oldfname;
	    
	case syscall_success:
	    /** YES!  Copy it to the file ".elm/elmrc.old".. **/
	    
	    oldfname = elm_message(FRM("%s/%s"), 
				   home, old_elmrcfile);
	    
	    r2 = rename(user_rc_file, oldfname);
	    switch (r2) {
	    case syscall_error:
		err = errno;
		DPRINT(Debug,4,(&Debug,
				"save_options: Unable to rename %s to %s: %s\n", 
				user_rc_file, oldfname,strerror(err)));
		break;
	    case syscall_success:

		DPRINT(Debug,4,(&Debug,
				"save_options: Config file %s renamed to %s\n",
				user_rc_file, oldfname));

		(void) elm_chown(oldfname, userid, groupid, NULL);
	    }
	    	    
	    free(oldfname);
	    
	    break;
	case syscall_error:
	    err = errno;
	    DPRINT(Debug,4,(&Debug,
			     "save_options: Config file %s: %s\n",
			     user_rc_file,strerror(err)));
	    break;
	}
    }
	
    /** now let's open the datafile if we can... **/

    /* write_rc writes to <user_rc_file>.N and then renames */
    
    r = write_rc(user_rc_file,NULL,0,"ELM",full_username_s,version_buff);
    
    restore_file_stats(user_rc_file);

    if (r) 
	lib_error(CATGETS(elm_msg_cat, ElmrcSet, ElmrcOptionsSavedIn,
			  "Options saved in file %s."), user_rc_file);
}

static int find_opt P_((char *s));
static int find_opt(s)
     char *s;
{
	int x, y = 0;

	for (x = 0; x < NUMBER_OF_SAVEABLE_OPTIONS; x++) {
	    y = strcmp(s, save_info[x].name);
	    if (y <= 0)
		break;
	}

	if (y != 0)
	    return(-1);
	return(x);
}

char *str_opt_nam(s, f)
     char *s;
     int f;
{
    char *t = NULL;
    
    if (0 == strcmp("aliassortby",s))
	t = alias_sort_name(SHORT);
    else if (0 == strcmp("sortby",s))
	t = sort_name(SHORT);
    else if (0 == strcmp("userlevel",s))
	t = level_name(give_dt_enumerate_as_int(&user_level));
    else {
	int x = find_opt(s);
	if (x >= 0) {
	    
	    if (RCTYPE_magic != save_info[x].dt_type->magic)
		panic("RC PANIC",__FILE__,__LINE__,"str_opt_nam",
		      "Bad config item type",0);

	    /* Returns pointer to static buffer */
	    t = save_info[x].dt_type->get_value(& save_info[x]);	    
	}
    }
    return(t);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
