case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	ln ../../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot="../../"
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting src/screen/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.10 2018/08/01 09:36:26 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
# Variables
#	Variables established by Configure
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
CHMOD		=	$chmod
LINT		=	$lint
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
RM		= 	$rm -f
CP		=	$cp
TOUCH		=	$touch
TAGS		=	ctags
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'
#	Other general variables
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) $(DEBUG) 
INCLDIR		=	$(SRCROOT)/hdrs
IHDR		=	../../hdrs
SHELL		=	/bin/sh

OBJ		=	screen.o curses.o curs_input.o termbuffer.o \
 termtitle.o termcharset.o cur_process.o context.o init.o subpage.o \
 wrapper.o menu_param.o scommon.o header.o knode.o

all:			Makefile libscreen.a

install_s:		Makefile libscreen.a

uninstall_s:		

clean:
	$(RM) $(OBJ) libscreen.a

Makefile: Makefile.SH ../../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

libscreen.a:		$(OBJ)
			$(AR) r $@ $?
			$(RANLIB) $@

#	Dependencies of header files upon other header files they include
.PRECIOUS:		def_screen.h $(IHDR)/defs.h  $(IHDR)/me.h \
 $(IHDR)/misclib.h $(IHDR)/elm_defs.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs.h:	../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_screen.h:		$(IHDR)/elm_defs.h $(IHDR)/me.h \
 $(INCLDIR)/elm_globals.h  $(INCLDIR)/mboxlib.h 
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(IHDR)/misclib.h: $(INCLDIR)/mlist_common.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/me.h:	$(INCLDIR)/melib.h $(IHDR)/misclib.h $(INCLDIR)/addrlib.h \
 $(INCLDIR)/aliaslib.h $(INCLDIR)/mime.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

#	Dependencies of C object files

screen.o:	     def_screen.h $(INCLDIR)/s_me.h
curses.o:	     def_screen.h $(INCLDIR)/s_me.h
curs_input.o:	     def_screen.h 
termbuffer.o:	     def_screen.h 
termtitle.o:	     def_screen.h 
termcharset.o:	     def_screen.h
cur_process.o:	     def_screen.h $(INCLDIR)/s_elm.h
context.o:	     def_screen.h
init.o:		     def_screen.h
wrapper.o:	     def_screen.h
menu_param.o:	     def_screen.h
knode.o:	     def_screen.h
#
subpage.o:	     def_screen.h def_scommon.h
scommon.o:	     def_screen.h def_scommon.h
header.o:	     def_screen.h def_scommon.h

!NO!SUBS!

