static char rcsid[] = "@(#)$Id: cur_process.c,v 2.5 2014/11/15 11:00:25 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_screen.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"screen");

static void print_status_1 P_((struct run_state *rs,int sig,int exit_code,
			       struct menu_context *page));
static void print_status_1(rs,sig,exit_code,page) 
     struct run_state *rs;
     int sig, exit_code;
     struct menu_context *page;
{
  int LINES, COLUMNS;

  DPRINT(Debug,10,(&Debug,
		   "print_status_1: exit_code=%d, sig=%d\n", 
		   exit_code,sig));   

 redraw:
    menu_get_sizes( page, &LINES, &COLUMNS);

    if (sig) 
	PutLineX(LINES-1,0,
		 CATGETS(elm_msg_cat, ElmSet, 
			 ElmTerminatedWithSignal,
			 "Terminated with signal %d. Press any key to continue: "),
		 sig);
    else if (exit_code)
	PutLineX(LINES-1,0,
		 CATGETS(elm_msg_cat, ElmSet, 
			 ElmExitedWithStatus,
			 "Exited with status %d. Press any key to continue: "),
		 exit_code);
    else
	PutLineX(LINES-1,0,
		 CATGETS(elm_msg_cat, ElmSet, 
			 ElmDoneCont,
			 "Done. Press any key to continue: "));
    if (menu_ReadCh(page,REDRAW_MARK) == REDRAW_MARK) 
	goto redraw;
}


void print_status_cooked(rs,sig,exit_code) 
     struct run_state *rs;
     int sig, exit_code;
{
    struct menu_context *cpage;

    cpage = Raw(ON | NO_TITE);

    print_status_1(rs,sig,exit_code, cpage);

    Raw(OFF | NO_TITE);
    printf("\n\r");
}


void print_status(rs,sig,exit_code) 
     struct run_state *rs;
     int sig, exit_code;
{
    if (rs->raw == ON && ( SY_CLRWAIT & rs->options )) {
	
	print_status_1(rs,sig,exit_code, default_context);
    }
}


void start_run_tty_init()
{
    int LINES, COLUMNS;

    menu_get_sizes( default_context, &LINES, &COLUMNS);
    

    MoveCursor(LINES-1,0);
    CleartoEOLN();
    FlushBuffer();
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
