/* $Id: def_screen.h,v 2.11 2022/07/14 14:16:01 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "elm_globals.h"
#include "mboxlib.h"
#include "me.h"

#ifdef I_CURSES
#include <curses.h>             /* <term.h> requires ... */
#endif /* I_CURSES */
#ifdef I_TERM
#include <term.h>               /* Defination for tgetent.h and so on ... */
#endif /* I_TERM */

#undef lines                    /* ... But undefine lines macro */
#undef columns                  /* ... But undefine columns macro */

#ifdef TERMIOS
#  include <termios.h>
   typedef struct termios term_buff;
#else
# ifdef TERMIO
#  include <termio.h>
#  define tcgetattr(fd,buf)	ioctl((fd),TCGETA,(buf))
   typedef struct termio term_buff;
# else
#  include <sgtty.h>
typedef struct tty_modes {
  struct sgttyb sgttyb;
  struct tchars tchars;
#ifdef TIOCLGET
  struct ltchars ltchars;
#endif
} term_buff;

int tcgetattr P_((int,term_buff *));  /* Prototype */
# endif
#endif




#define DEFAULT_LINES_ON_TERMINAL	24
#define DEFAULT_COLUMNS_ON_TERMINAL	80

extern int InGetPrompt;         /* set if in GetPrompt() in read() */
/* HACK */

extern int CUR_modes;
extern void EndSyncronize P_((struct menu_context *ctx));
extern void Syncronize P_((struct menu_context *ctx));


/* screen.c */

extern void enter_terminal_hook P_((void));

/* curses.c */

struct cur_printarea {
    /* Currently disables scrolling */

    int   first_line, last_line;

    int  gone_out;
};

extern int cur_tabspacing;           /* Default? */

extern int cur_InitScreen P_((void));

extern int terminal_fd;
extern int outchar P_((int c));

extern charset_t target_display_charset;
extern struct charset_state * last_state;
extern screen_info_p  last_display_state;

extern char terminal_type[];

/* DO NOT return lines-1 (as ScreenSize() did) */

extern void cur_ScreenSize P_((int *lines, int *columns));
extern void cur_GetXYLocation P_((int *line, int *col));
extern void  cur_ClearScreen P_((void));
extern void cur_MoveCursor P_((int row, int col,     struct cur_printarea *lim));

extern void cur_changemode P_((int *mode, int set, int reset));

/* This assumes one byte charset */
extern void cur_Writechar P_((int ch, struct cur_printarea *lim));

/* Writes UTF-8 if possible */
extern void cur_WriteUnicode P_((int unicode, struct cur_printarea *lim));

extern void cur_PutLineS P_((struct string *S, struct cur_printarea *lim));

extern void cur_PutLine0 P_((int row, int col, const char *line,
			     struct cur_printarea *lim));
extern void cur_CleartoEOLN P_((void));
extern void cur_CleartoEOS P_((void));

extern enum rawstate cur_RawState P_((void));

/* NOTE: Is called from signal handler! */
extern void cur_leave_screen_signal P_((int tite, int charset));



/* Do not call from signal handler */
extern void cur_leave_screen P_((int tite, int charset));
extern void cur_enter_screen P_((int tite, int charset));

extern volatile int do_clear_input;
extern volatile int do_enter_terminal;
extern volatile int was_on_cooked;
extern int     utf8_input_mode;
extern int     utf8_error;     /* Locale was not utf-8 */

void limit_position P_((int *row, int *col));

extern void transmit_functions P_((int newstate));

extern void init_system_charset P_((void));
extern void clear_input_buffer P_((void));  

extern void set_last_state P_((charset_t cs));
extern struct charset_state * cur_ReadCh2 P_((int flags,
					      int break_flag));

extern void cur_FlushInput P_((void));


extern int  cursor_control;
extern int CUR_intransmit;	        /* are we transmitting keys? */
extern char *CUR_transmit_on,  *CUR_transmit_off; 

#if !defined(I_CURSES) && !defined(I_TERM)
char *tgetstr();
int  tgetent();      /* get termcap entry */
char *tgoto();
#endif

/* ----------------------------------------- */

#ifdef TERMIOS
# include <termios.h>

struct tf_state {
    struct termios old_raw;
    int old_raw_ok;
};

extern int toggle_lflag P_((struct tf_state *T,int enab,int disab) );
extern void reset_lfag P_((struct tf_state *T));
#endif

/* cur_process.c */

extern void print_status P_((struct run_state *rs,int sig,int exit_code));
extern void start_run_tty_init P_((void));
extern void print_status_cooked P_((struct run_state *rs,int sig,
				    int exit_code));

/* -------------------------------------------------------------------- */


#define MENU_CONTAINER_magic      0xF802

struct menu_subpages {
    unsigned short         magic; /* MENU_CONTAINER_magic */

    struct cur_printarea   location;
    struct menu_context   * subpage;

    struct menu_context   * parent;
    struct menu_subpages  * prev;
    struct menu_subpages  * next;
};

#define MENU_CONTEXT_magic      0xF800

extern struct menu_context {
    unsigned short         magic; /* MENU_CONTEXT_magic */

    struct  menu_draw_routine  * routine;
    struct  menu_subpages      * subpages;
    struct  menu_subpages      * container;

    int lines, columns;
    int changed;
    int redraw;

    /* absolute cordinates */
    int modes;
    int row, col;

    union {
	void                   * dummy;
	struct subpage_common  * common;
	struct menu_subpage    * subpage;
	struct menu_header     * header;

    } u;

    struct menu_context * next_menu;
    struct menu_context * prev_menu;
} ROOT_MENU, COOKED_MENU;

extern void check_changes P_((void));
extern void attach_subpage P_((struct menu_context *parent,
			       struct menu_context *subpage,
			       /* absolute screen cordinates */
			       int first_line, int last_line));

extern void detach_subpage P_((struct menu_context *subpage));

/* init.c */

extern int get_term_chars P_((int fd, term_buff *tty));

extern char backspace,		/* the current backspace char */
    kill_line,		        /* the current kill-line char */
    word_erase,		        /* the current word-erase char */
    interrupt_char,		/* the current interrupt char */
    reprint_char,		/* the current reprint-line char */
    eof_char;			/* the current end-of-file char */

extern char VQUIT_char,         /* the current quit char */
    VSUSP_char;                 /* the current suspend char */

/* ----------------------------------------  */

typedef void w_menu_Writechar P_((struct menu_context * ctx,
				  int ch));
typedef void w_menu_PutLineS P_((struct menu_context * ctx,
				 struct string *text));
typedef void w_menu_PutLine0 P_((struct menu_context * ctx,
				 int x, int y,
				 const char *line));
typedef void w_menu_CleartoEOLN P_((struct menu_context * ctx));
typedef void w_menu_CleartoEOS P_((struct menu_context * ctx));
typedef struct charset_state * w_menu_ReadCh2 P_((struct menu_context *ctx,
						  int flags,
						  int break_flag));
typedef void w_menu_ScreenSize P_((struct menu_context *ctx,
				   int *lines, int *columns));
typedef void w_menu_GetXYLocation P_((struct menu_context *ctx,
				      int *x, int *y));
typedef void w_menu_ClearScreen P_((struct menu_context *ctx));
typedef void w_menu_MoveCursor P_((struct menu_context *ctx,
				   int row, int col));
typedef void w_menu_changemode P_((struct menu_context *ctx,
				   int start, int end));
typedef void w_menu_SyncEnter P_((struct menu_context *ctx));
typedef void w_menu_SyncLeave P_((struct menu_context *ctx));


typedef void w_menu_init P_((struct menu_context *ctx));
typedef void w_menu_free P_((struct menu_context *ctx));

typedef void w_menu_resized P_((struct menu_context *ctx));
typedef void w_menu_calculate_line P_((struct menu_context *ctx,
				       int rel_line, int *result));
typedef void w_menu_get_linelimit P_((struct menu_context *ctx,
				      int *startline, int *endline));
typedef void w_menu_reset_redraw P_((struct menu_context *ctx));
typedef int w_menu_do_redraw P_((struct menu_context *ctx));

typedef void w_menu_WriteUnicode P_((struct menu_context * ctx, int unicode));

/* Reverse to w_menu_calculate_line -- return 1 if succeed */
typedef int w_menu_calculate_rline P_((struct menu_context *ctx,
					 int absline, int *result));


#define MENU_DRAW_magic         0xF801
extern struct  menu_draw_routine {
    unsigned short         magic; /* MENU_DRAW_magic */

    w_menu_init               * wra_init;
    w_menu_free               * wra_free;

    w_menu_Writechar          * wra_Writechar;
    w_menu_PutLineS           * wra_PutLineS;
    w_menu_PutLine0           * wra_PutLine0;
    w_menu_CleartoEOLN        * wra_CleartoEOLN;
    w_menu_CleartoEOS         * wra_CleartoEOS;
    w_menu_ReadCh2            * wra_ReadCh2;
    w_menu_ScreenSize         * wra_ScreenSize;
    w_menu_GetXYLocation      * wra_GetXYLocation;
    w_menu_ClearScreen        * wra_ClearScreen;
    w_menu_MoveCursor         * wra_MoveCursor;
    w_menu_changemode         * wra_changemode;
    w_menu_SyncEnter          * wra_SyncEnter;
    w_menu_SyncLeave          * wra_SyncLeave;
    w_menu_resized            * wra_resized;
    w_menu_calculate_line     * wra_calculate_line;
    w_menu_get_linelimit      * wra_get_linelimit;
    w_menu_reset_redraw       * wra_reset_redraw;
    w_menu_do_redraw          * wra_do_redraw;
    w_menu_WriteUnicode       * wra_WriteUnicode;
    w_menu_calculate_rline    * wra_calculate_rline;
    
} CURSES_ROUTINES;

extern struct menu_context  * new_menu_type P_((struct  menu_draw_routine *T));
extern void mp_set_any1 P_((struct menu_param *list, int idx, struct menu_param *v));

/* knode.c */

extern void get_terminal_keys P_((char **TP));

/* kval == 0   (re)initialize */
extern int knode_parse P_((int kval));   

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
