static char rcsid[] = "@(#)$Id: knode.c,v 2.6 2016/03/21 20:26:15 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/curses.c. 
 *  That code have following copyright:
 *
 *  The Elm Mail System
 *                      Copyright (c) 1988-1995 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_screen.h"

DEBUG_VAR(Debug,__FILE__,"screen");

/* 
 * Multi-byte special function keys are parsed by traversing
 * a tree constructed of (struct knode) elements.
 */
#define KCHUNK 8


#define KNODE_magic		0xF806

struct knode {
    unsigned short            magic; /* KNODE_magic */

    int kcode;		/* return value for terminal nodes	*/

    struct {
	unsigned char  kval;	/*  "next byte" values		*/
	struct knode  *knext;	/* node corresponding 	*/
    } * keylist;

    int keylist_len;	/* number entries in above lists	*/
    int keylist_alloc;	/* allocated size of these lists	*/
};

/* root of the multi-byte parsing tree */
static struct knode *Knode_root = NULL;

static struct knode *knode_new P_((void));
static int knode_addkey P_((char *capname, char **tp, int kcode));

void get_terminal_keys(TP)
     char **TP;
{
    char * tp = *TP; 

    if (Knode_root)
      	panic("CURSES PANIC",__FILE__,__LINE__,"get_terminal_keys",
	      "Called several times",0);


    /* get the cursor control keys... */
    Knode_root = knode_new();

    knode_addkey("kd", &tp, DOWN_MARK);
    knode_addkey("ku", &tp, UP_MARK);
    knode_addkey("kl", &tp, LEFT_MARK);
    knode_addkey("kr", &tp, RIGHT_MARK);
  
    knode_addkey("kh", &tp, HOME_MARK);
    knode_addkey("kD", &tp, DELETE_MARK);
    knode_addkey("kI", &tp, INSERT_MARK);   /* FIXME: Not used */
    knode_addkey("kN", &tp, PAGEDOWN_MARK);
    knode_addkey("kP", &tp, PAGEUP_MARK);
    knode_addkey("kB", &tp, BACKTAB_MARK);  /* FIXME: Not used */

    knode_addkey("kH", &tp, END_MARK);	/* termcap-ish */
    knode_addkey("@7", &tp, END_MARK);	/* terminfo-ish */

    /* Only on Elm ME+ -- not in Elm 2.5 */

    knode_addkey("%1", &tp, HELP_MARK);
    knode_addkey("@0", &tp, FIND_MARK);
    knode_addkey("kb", &tp, TERMCH_backspace);

    /* Function keys F1 - F9 ... mostly not used */

    knode_addkey("k1", &tp, F1_KEY_MARK);
    knode_addkey("k2", &tp, F2_KEY_MARK);
    knode_addkey("k3", &tp, F3_KEY_MARK);
    knode_addkey("k4", &tp, F4_KEY_MARK);
    knode_addkey("k5", &tp, F5_KEY_MARK);
    knode_addkey("k6", &tp, F6_KEY_MARK);
    knode_addkey("k7", &tp, F7_KEY_MARK);
    knode_addkey("k8", &tp, F8_KEY_MARK);
    knode_addkey("k9", &tp, F9_KEY_MARK);
    knode_addkey("k;", &tp, F10_KEY_MARK);
    knode_addkey("F1", &tp, F11_KEY_MARK);
    knode_addkey("F2", &tp, F12_KEY_MARK);

    *TP = tp;
}

/*
 * Allocate an empty (struct knode).
 */
static struct knode *knode_new()
{
    struct knode *knode;

    knode = safe_malloc(sizeof(*knode));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)knode,sizeof (*knode));

    knode->magic = KNODE_magic;
    
    knode->kcode = 0;
    knode->keylist = safe_calloc(KCHUNK,sizeof(* (knode->keylist)));

    knode->keylist_len = 0;
    knode->keylist_alloc = KCHUNK;

    return(knode);
}

/*
 * Place key rooted at "knode".  The "kstr" is the string that
 * corresponds to the value when the key is struck, and the "kcode"
 * is the code that should be assigned to this key.
 */
static int knode_addkey(capname, tp, kcode)
     char *capname;
     char **tp;
     int kcode;
{
    int i;
    char *kstr;
    struct knode *knode;

    if ((kstr = tgetstr(capname, tp)) == NULL || strlen(kstr) < 2)
	return -1;

    knode = Knode_root;
    while (*kstr != '\0') {


	if (KNODE_magic != knode->magic)
	    panic("CURSES PANIC",__FILE__,__LINE__,"knode_addkey",
		  "bad magic number",0);
	
	/* see if this character already is in the tree */
	for (i = 0 ; i < knode->keylist_len ; ++i) {
	    if (knode->keylist[i].kval == (unsigned char) *kstr)
		break;
	}
	
	/* nope ... need to add it */
	if (i >= knode->keylist_len) {
	    if (knode->keylist_len >= knode->keylist_alloc) {
		knode->keylist_alloc += KCHUNK;
		
		knode->keylist = safe_array_realloc(knode->keylist,
						    knode->keylist_alloc,
						    sizeof(* (knode->keylist)));
	    }
	    
	    if (i != knode->keylist_len)
		panic("CURSES PANIC",__FILE__,__LINE__,"knode_addkey",
		      "Internal error", 0);
	    
	    knode->keylist[i].kval  = (unsigned char) *kstr;
	    knode->keylist[i].knext = knode_new();
	    ++knode->keylist_len;
	}
	
	/* descend into the tree */
	knode = knode->keylist[i].knext;
	++kstr;    
    }
    
    /* place this key code at the terminal node */
    if (knode->keylist_len != 0)
      	panic("CURSES PANIC",__FILE__,__LINE__,"knode_addkey",
	      "key code not at the terminal node", 0);

    knode->kcode = kcode;

    return 0;
}


/*
 * Iteratively parse a multi-byte special function key.
 *
 * This routine should be called once with a "kval" of zero.
 * Then it is called iteratively for each byte in the key sequence.
 * Returns a positive value (the key code) once the key sequence is resolved.
 * Returns 0 if more bytes are needed to resolve this key.
 * Returns -1 if the sequence cannot be mapped to a key.
 */
int knode_parse(kval)
     int kval;
{
    static struct knode *knode = NULL;
    int code, i;

    /* initialize for new key sequence */
    if (kval == 0) {
	knode = Knode_root;
	return 0;
    }
   
    if (KNODE_magic != knode->magic)
	panic("CURSES PANIC",__FILE__,__LINE__,"knode_parse",
	      "bad magic number",0);

    /* locate this byte in the tree */
    code = -1;
    for (i = 0 ; i < knode->keylist_len ; ++i) {
	if (knode->keylist[i].kval == kval) {
	    knode = knode->keylist[i].knext;
	    code = knode->kcode;
	    break;
	}
    }

    if (code != 0) {
	/* either key is resolved, or it is something we don't understand */
	knode = NULL;
    }
    return code;
}





/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
