static char rcsid[] = "@(#)$Id: subpage.c,v 2.6 2022/07/14 14:16:01 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_screen.h"
#include "def_scommon.h"

DEBUG_VAR(Debug,__FILE__,"screen");

#define MENU_SUBPAGE_magic      0xF803

struct menu_subpage {
    struct subpage_common  c;
    unsigned short         magic;      /* MENU_SUBPAGE_magic */

    subpage_simple_redraw * redraw_routine;
};


#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

int subpage_simple_noredraw P_((struct menu_context  *ptr,
				struct menu_param *list));

S_(w_menu_init subpage_init)
static void subpage_init P_((struct menu_context *ctx));
static void subpage_init(ctx)
     struct menu_context *ctx;
{

    DPRINT(Debug,10, (&Debug, "subpage_init: %p\n",
		      ctx));

    ctx->u.subpage = safe_malloc (sizeof (* ctx->u.subpage));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)ctx->u.subpage,sizeof (* ctx->u.subpage));

    scommon_zero(&(ctx->u.subpage->c)); 
    ctx->u.subpage->magic          = MENU_SUBPAGE_magic;

    ctx->u.subpage->redraw_routine = subpage_simple_noredraw;
}

S_(w_menu_free subpage_free)
static void subpage_free P_((struct menu_context *ctx));
static void subpage_free(ctx)
     struct menu_context *ctx;
{

    DPRINT(Debug,10, (&Debug, "subpage_free: %p\n",
		      ctx));

    if (MENU_SUBPAGE_magic != ctx->u.subpage->magic)
	panic("SCREEN PANIC",__FILE__,__LINE__,"subpage_free",
	      "Bad magic number",0);

    scommon_clear( & (ctx->u.subpage->c) );

    ctx->u.subpage->magic = 0;    /* Invalidate */
    free(ctx->u.subpage);
    ctx->u.subpage = NULL;
}


S_(w_menu_do_redraw subpage_do_redraw)
static int subpage_do_redraw P_((struct menu_context *ctx));
static int subpage_do_redraw(ctx)
     struct menu_context *ctx;
{
    if (MENU_SUBPAGE_magic != ctx->u.subpage->magic)   
	panic("SCREEN PANIC",__FILE__,__LINE__,"subpage_do_redraw",
	      "Bad magic number",0);

    return ctx->u.subpage->redraw_routine(ctx,
					  ctx->u.subpage->c.param_ptr);
}


static struct  menu_draw_routine SUBPAGE_ROUTINES = {
    MENU_DRAW_magic,

    subpage_init,
    subpage_free,
	
    scommon_Writechar,
    scommon_PutLineS,
    scommon_PutLine0,
    scommon_CleartoEOLN,
    scommon_CleartoEOS,
    scommon_ReadCh2,
    scommon_ScreenSize,
    scommon_GetXYLocation,
    scommon_ClearScreen,
    scommon_MoveCursor,
    scommon_changemode,
    scommon_SyncEnter,
    scommon_SyncLeave,
    scommon_resized,
    scommon_calculate_line,
    scommon_get_linelimit,
    scommon_reset_redraw,
    subpage_do_redraw,
    scommon_WriteUnicode,
    scommon_calculate_rline
};

int subpage_simple_noredraw(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    return 0;
}

struct menu_context * new_menu_subpage(parent,rel_start_line,lines,redraw,
				       list)
     struct menu_context  *parent;
     int rel_start_line;
     int lines;
     subpage_simple_redraw redraw;
     struct menu_param *list;
{
    int rline = 0;
    int lline = 0;

    struct menu_context  *ret =  new_menu_type(&SUBPAGE_ROUTINES);

    if (MENU_CONTEXT_magic != parent->magic)
	panic("SCREEN PANIC",__FILE__,__LINE__,"new_menu_subpage",
	      "Bad parent magic number",0);

    ret->lines                = lines;
    ret->columns              = parent->columns;
    ret->u.subpage->c.rel_start_line = rel_start_line;
    ret->u.subpage->c.param_ptr     = list;
    ret->u.subpage->redraw_routine = redraw;

    if (MENU_DRAW_magic  != parent->routine->magic)
	panic("SCREEN PANIC",__FILE__,__LINE__,"new_menu_subpage",
	      "Bad parent draw magic number",0);

    parent->routine->wra_calculate_line(parent,rel_start_line,&rline);

    lline = rline + lines -1;    /* calculate_printing_area() fixes */

    attach_subpage(parent,ret,rline,lline);

    calculate_printing_area(ret);

    return ret;
}

#if 0
/* Creates copy of subpage which is attached to new page */
struct menu_context * dup_menu_subpage(new_parent,orig)
     struct menu_context *new_parent;
     struct menu_context *orig;
{
    int rline = 0;
    int lline = 0;
    int rel_start_line;
    int lines;

    struct menu_context  *ret =  new_menu_type(&SUBPAGE_ROUTINES);

    if (MENU_CONTEXT_magic != new_parent->magic)
	panic("SCREEN PANIC",__FILE__,__LINE__,"dup_menu_subpage",
	      "Bad new_parent magic number",0);
    if (MENU_CONTEXT_magic != new_parent->magic)
	panic("SCREEN PANIC",__FILE__,__LINE__,"dup_menu_subpage",
	      "Bad orig magic number",0);

    lines = orig->lines;
    ret->lines                = lines;
    ret->columns              = new_parent->columns;

    if (&SUBPAGE_ROUTINES != orig->routine)
	panic("SCREEN PANIC",__FILE__,__LINE__,"dup_menu_subpage",
	      "(orig) not a subpage",0);


    if (MENU_SUBPAGE_magic != orig->u.subpage->magic)   
	panic("SCREEN PANIC",__FILE__,__LINE__,"dup_menu_subpage",
	      "Bad subpage magic number",0);

    rel_start_line         = orig->u.subpage->c.rel_start_line;

    ret->u.subpage->c.rel_start_line = rel_start_line;
    ret->u.subpage->c.param_ptr      = orig->u.subpage->c.param_ptr;
    ret->u.subpage->redraw_routine   = ret->u.subpage->redraw_routine;

    if (MENU_DRAW_magic  != new_parent->routine->magic)
	panic("SCREEN PANIC",__FILE__,__LINE__,"dup_menu_subpage",
	      "Bad new_parent draw magic number",0);


    new_parent->routine->wra_calculate_line(new_parent,rel_start_line,&rline);

    lline = rline + lines -1;    /* calculate_printing_area() fixes */

    attach_subpage(new_parent,ret,rline,lline);

    calculate_printing_area(ret);

    return ret;
}
#endif

void menu_subpage_relocate(subpage,parent,rel_start_line,lines)
     struct menu_context  *subpage;
     struct menu_context  *parent;
     int rel_start_line;
     int lines;
{

    if (&SUBPAGE_ROUTINES != subpage->routine)
	panic("SCREEN PANIC",__FILE__,__LINE__,"menu_subpage_relocate",
	      "Not a subpage",0);

    scommon_relocate(subpage,parent,rel_start_line,lines);
}

					
/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
