static char rcsid[] = "@(#)$Id: showmsg_1.c,v 2.11 2019/03/11 18:23:56 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * Some code copied from Elm 2.4 src/elm.c. That file is following
 * copyright:
 *
 *  The Elm Mail System 
 *
 * This file and all associated files and documentation:
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_elm.h"

DEBUG_VAR(Debug,__FILE__,"ELM");


int show_message_with_headers(mailbox,cmdX,aview,page,header_area,pager_cmds)
     struct MailboxView *mailbox;
     showmsg_cmd  cmdX;
     struct AliasView *aview;
     struct menu_context  *page;
     struct menu_context  *header_area;
     struct elm_commands *pager_cmds;
{
    struct menu_common MENU;

    int current = get_current(mailbox);

    int j = elm_filter;
    int i = 0;
    
    
    struct pager_page * PP = init_pager_page(&MENU);
    elm_filter = FALSE;
   
    set_mcommon_from_mbxview(&MENU,mailbox);
    
    i = mbx_show_msg(mailbox,current-1,PP, pager_cmds);
    
    while (i > 0) {
	i = process_showmsg_cmd(i, mailbox, cmdX, aview, 
				PP,0, pager_cmds);
	
	switch (i) {
	case EOF:
	    exit_pager_page(&PP,page);
	    return EOF;/* Read failed, control tty died? */
	    
	case 'X':      /* Quick Exit */
	case 'x':      /* Exit       */
	    
	    exit_pager_page(&PP,page);
	    return i;   /* "call" parent */
	case 0:
	    break;
	    
	default:
	    DPRINT(Debug,3,(&Debug, 
			    "Looping showmsg command %d\n",
			    i,i));
	    if (isascii(i) && isprint(i)) {
		DPRINT(Debug,3,(&Debug, " (%c)",
				i));
	    }
	    DPRINT(Debug,3,(&Debug, "\n"));
	}
    }
    
    exit_pager_page(&PP,page);
    
    elm_filter = j;
    menu_trigger_redraw(page);
    get_page(&MENU, header_area);
    
    
    return 0;
}

int show_message_normal(mailbox,cmdX,aview,page,header_area,flags,pager_cmds)
     struct MailboxView *mailbox;
     showmsg_cmd  cmdX;
     struct AliasView *aview;
     struct menu_context  *page;
     struct menu_context  *header_area;
     int flags;
     struct elm_commands *pager_cmds;
{
    struct menu_common MENU;

    int current = get_current(mailbox);

    int i = 0;	    
    struct pager_page * PP = init_pager_page(&MENU);
    
    /* define_softkeys(READ); */

    set_mcommon_from_mbxview(&MENU,mailbox);

    i = mbx_show_msg(mailbox,current-1,PP,pager_cmds);
    
    while (i > 0) {
	i = process_showmsg_cmd(i, mailbox, cmdX, aview, 
				PP,flags,pager_cmds);
	
	switch (i) {
	case EOF:
	    exit_pager_page(&PP,page);
	    return EOF;/* Read failed, control tty died? */
	    
	case 'X':      /* Quick Exit */
	case 'x':      /* Exit       */
	    
	    exit_pager_page(&PP,page);
	    return i;   /* "call" parent */
	case 0:
	    break;
	    
	default:
	    if (isascii(i)) {
		DPRINT(Debug,3,(&Debug, 
				"Looping showmsg command %d\n",
				i));

	    } else {
		DPRINT(Debug,3,(&Debug, 
				"Looping showmsg command %d (%c)\n",
				i,i));
	    }		    
	}
    }
    
    exit_pager_page(&PP,page);
    
    menu_trigger_redraw(page);
    get_page(&MENU, header_area);
    
    return 0;
}

int show_next_message(mailbox,cmdX,aview,page,header_area,pager_cmds)
     struct MailboxView *mailbox;
     showmsg_cmd  cmdX;
     struct AliasView *aview;
     struct menu_context  *page;
     struct menu_context  *header_area;
     struct elm_commands *pager_cmds;
{
    struct menu_common MENU;

    int current = get_current(mailbox);

    int i = 0;	    
    int mc;
    struct pager_page * PP = init_pager_page(&MENU);

    set_mcommon_from_mbxview(&MENU,mailbox);
    
    i = mbx_show_msg(mailbox,current-1,PP,pager_cmds);
    
    while (i >0) {
	i = process_showmsg_cmd(i, mailbox, cmdX, aview, 
				PP,0,pager_cmds);
	
	switch (i) {
	case EOF:
	    
	    exit_pager_page(&PP,page);
	    return EOF;/* Read failed, control tty died? */
	    
	case 'X':      /* Quick Exit */
	case 'x':      /* Exit       */
	    
	    exit_pager_page(&PP,page);
	    return i;   /* "call" parent */
	    
	case 0:
	    break;
	    
	default:
	    if (isascii(i)) {
		DPRINT(Debug,3,(&Debug, 
				"Looping showmsg command %d\n",
				i));		
	    } else {
		DPRINT(Debug,3,(&Debug, 
				"Looping showmsg command %d (%c)\n",
				i,i));
	    }
	}
    }
    
    exit_pager_page(&PP,page);
    current = get_current(mailbox);
    
    menu_trigger_redraw(page);
    if (++current > (mc = get_message_count(mailbox)))
	current = mc;
    set_current(mailbox,current);

    get_page(&MENU, header_area);
    
    return 0;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
