static char rcsid[] = "@(#)$Id: snd_preview.c,v 2.4 2021/07/07 16:28:00 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_sndmail.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"mail");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(subpage_simple_redraw sb_update_preview_title)
static int sb_update_preview_title P_((struct menu_context  *ptr,
                                       struct menu_param *list));
static int sb_update_preview_title(ptr,list)
     struct menu_context * ptr;
     struct menu_param  * list;
{  
    menu_ClearScreen(ptr);

    menu_StartXX(ptr,pg_BOLD);
    
    menu_print_format_center(ptr,0, 
			     CATGETS(elm_msg_cat, ElmSet,
				     ElmPreviewScreenTitle, 
				     "Mail Preview Screen"));
    
    menu_EndXX(ptr,pg_BOLD);

    return 1;
}

S_(subpage_simple_redraw sb_update_preview_prompt)
static int sb_update_preview_prompt P_((struct menu_context  *ptr,
                                       struct menu_param *list));
static int sb_update_preview_prompt(ptr,list)
     struct menu_context * ptr;
     struct menu_param  * list;
{    

    menu_ClearScreen(ptr);

    show_last_error();

    menu_PutLineX(ptr,0, 0, 
		  CATGETS(elm_msg_cat, ElmSet,
			  ElmPreviewPrompt0,
			  "Command: "));

    menu_print_format_center(ptr,1,
			     CATGETS(elm_msg_cat, ElmSet,
				     ElmPreviewMenu1,
				     "Press <space> to view the message, 'v' to view MIME structure (attachments), "));
  
    menu_print_format_center(ptr,2,
			     CATGETS(elm_msg_cat, ElmSet,
				     ElmPreviewMenu2,
				     "'m' to mail message or 'f' to forget message. ? = help"));

    return 1;
}

enum snd_preview_result preview_message(converted_buffer,command_ch,
					parent_page,snd_cmds,
					ft_code,mime_info,headers,
					aview,mailbox,remote_server)
     FILE *converted_buffer;
     int *command_ch;
     struct menu_context  *parent_page;
     struct elm_commands *snd_cmds;
     enum verify_trans_result ft_code;     
     mime_send_t *mime_info;
     struct mailing_headers * headers;
     struct AliasView *aview;
     struct MailboxView *mailbox;
     const struct remote_server  * remote_server;
{
    enum snd_preview_result ret = sp_none;    
    int                     encode_hdr;
    struct header_rec       Header;
    header_list_ptr         hdr = NULL;
    const char * tmp = give_dt_estr_as_str(&temp_dir_e,"tmpdir",NULL,NULL);
    static int              preview_count = 0;
    char *                  preview_filename = NULL;
    FILE *                  preview_fp       = NULL;
    struct out_state  *     preview_out_state =  new_out_state(STATE_out_file);

    long                    preview_size;
    long                    content_start;

    int err = 0;
    
    header_zero(&Header);

    if (!tmp)
	goto fail;

    preview_filename = elm_message(FRM("%selmpv-%d-%d"),
				   tmp, getpid (),
				   preview_count++);

    preview_fp = safeopen_rdwr(preview_filename,&err);
    if (!preview_fp) {

	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedOpenPreviewMess,
			  "Failed to open temp file for preview message: %s: %s"),
		  preview_filename, strerror(err));

	goto fail;
    }

    set_out_state_file(preview_fp,preview_out_state);
    write_header_info(preview_out_state, headers, cm_across_preview, mime_info);    

    if (!copy_message_across(mime_info,preview_out_state,
			     cm_across_preview,converted_buffer)) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedFormatPreviewMess,
			  "Failed to format preview message: %s"),
		  preview_filename);
	goto fail;
    }


    Header.header_charset = mime_info->hdr_charset /* lazy */;
    encode_hdr       = mime_info->encode_hdr /* lazy */;

    Header.status |= MIME_MESSAGE;
    if (!encode_hdr)
	Header.status |= NOHDRENCODING;


    rewind(preview_fp);
    hdr = file_read_headers(preview_fp,0);

    if (!hdr || ferror(preview_fp)) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedReadPreviewMess,
			  "Failed to read headers from preview message: %s"),
		  preview_filename);
    
	goto fail;
    }
       
    header_parse_helper(&Header,hdr);

    Header.offset = Header.mime_rec.begin_offset = 0L;
    Header.mime_rec.offset = content_start = ftell(preview_fp);
    preview_size = fsize(preview_fp);

    if (preview_size >= content_start) {
	Header.content_length = preview_size - content_start;
	
	DPRINT(Debug,10,(&Debug,
			 "preview_message: content start=%ld, size=%ld => content legth=%ld\n",
			 content_start,preview_size,
			 Header.content_length));
    }

    start_body_helper(&Header,content_start,hdr);

    if (mime_parse_routine1(&Header,preview_fp)) {

	struct menu_context   * page = new_menu_context();
	struct menu_context   * prompt_area = NULL;	
	struct menu_context   * title_area = NULL;
	int LINES, COLUMNS;
	int cmd = *command_ch;
	int do_redraw = 1;
	int printed_prompt = 0;
	int def_cmd = 'm';
	int lin,col;
	struct elm_commands *cmds = give_preview_commands();
	struct elm_commands *all_cmds =
	    give_merged_commands(cmds,snd_cmds,0,0);


	menu_get_sizes(page,&LINES, &COLUMNS);

	prompt_area = 
	    new_menu_subpage(page,LINES-4,4,
			     sb_update_preview_prompt,NULL);
	title_area =
	    new_menu_subpage(page,0,1,
			     sb_update_preview_title,NULL);

	switch(ft_code) {
	case ft_preview:
	    DPRINT(Debug,10,(&Debug,
			     "preview_message: ft_code=%d (ft_preview)\n",
			     ft_code));
	    goto preview_message;
	case ft_preview_hdrs:
	    DPRINT(Debug,10,(&Debug,
			     "preview_message: ft_code=%d (ft_preview_hdrs)\n",
			     ft_code));
	    goto preview_msg_headers;
	case ft_preview_menu:
	    DPRINT(Debug,10,(&Debug,
			     "preview_message: ft_code=%d (ft_preview_menu)\n",
			     ft_code));
	    break;
	case ft_preview_mime:
	    DPRINT(Debug,10,(&Debug,
			     "preview_message: ft_code=%d (ft_preview_mime)\n",
			     ft_code));
	    goto preview_parts;

	default:
	    DPRINT(Debug,10,(&Debug,
			     "preview_message: ft_code=%d (unexpected)\n",
			     ft_code));
	}


	for (;;) {
	    menu_set_default(page);

	    if (0) {
	    redraw:
		do_redraw = 1;
	    }

	resize_mark:
	    if (menu_resized(page)) {
		
		menu_get_sizes(page,&LINES, &COLUMNS);
		
		menu_subpage_relocate(prompt_area,page,LINES-4,4);
		
		do_redraw = 1;
		
	    } else if (menu_need_redraw(page))
		do_redraw = 1;

	    if (do_redraw) {
		
		do_redraw = 0;
		
		menu_ClearScreen(page);
		
		show_last_error();
		
		menu_redraw_children(page);
	    }

	    if (menu_resized(title_area) ||
		menu_need_redraw(title_area)) {

		sb_update_preview_title(title_area,NULL);

	    }

	    if (menu_resized(prompt_area) ||
		menu_need_redraw(prompt_area)) {
			    
		sb_update_preview_prompt(prompt_area,NULL);
		
	    }

	    menu_PutLineX(prompt_area,0, 0, 
			  CATGETS(elm_msg_cat, ElmSet,
				  ElmPreviewPrompt,
				  "Command: %c"),
			  def_cmd);

	    menu_GetXYLocation(prompt_area,&lin,&col);
	    col--;

	    menu_CleartoEOLN(prompt_area);
	    show_last_error();
	    FlushBuffer();
	    
	    menu_MoveCursor(prompt_area,
			    lin, col);

	    cmd = menu_ReadCh(prompt_area,REDRAW_MARK|READCH_resize);

	    if (isascii(cmd) && 
		isprint(cmd)) {
		DPRINT(Debug,10,(&Debug,"preview_message: ... command: '%c'\n",
				cmd));
	    } else {
		DPRINT(Debug,10,(&Debug,"preview_message: ... command: %d\n",
				cmd));
	    }

	    if (cmd == REDRAW_MARK) {
		DPRINT(Debug,10, (&Debug,"preview_message:       .... redrawing\n"));
		menu_ClearScreen(page);   /* Clear possible redraw mark */
		
		/* Call refresh routines of children */
		menu_redraw_children(page);
		
		if (menu_need_redraw(prompt_area))		    
		    menu_ClearScreen(prompt_area);   /* Clear redraw mark from prompt_area*/
		
		goto redraw;
	    }

	    if (cmd == RESIZE_MARK) {

		DPRINT(Debug,10, (&Debug,"       .... resizing\n"));
		goto resize_mark;
	    }

	    if (cmd == EOF) {
		ret = sp_EOF;
		goto quit;
	    }

	    printed_prompt = 1;
	    clear_error();

	    /* Put cursor pack to correct place */
	    menu_MoveCursor(prompt_area,lin,col);

	got_command:
	    switch (cmd) {
	    case '\n':
	    case '\r':
		cmd = def_cmd;
		
		if (isascii(cmd) && 
		    isprint(cmd)) {
		    DPRINT(Debug,10,(&Debug,"preview_message: ... default command: '%c'\n",
				    cmd));
		} else {
		    DPRINT(Debug,10,(&Debug,"preview_message: ... default command: %d\n",
				    cmd));
		}
	    }

	    switch (cmd) {
	
	    preview_message:
	    case ' ': {
		struct pager_page *PP = init_pager_page(NULL);

		if (printed_prompt) {
		    menu_Write_to_screen(prompt_area,
					 CATGETS(elm_msg_cat, ElmSet, 
						 ElmPreviewMenuViewMessage,
						 "View message"));
		    FlushBuffer();
		}
	       
		cmd = metapager(preview_fp,&Header,
				METAPAGER_do_headers|METAPAGER_no_index,
				0,0,PP,all_cmds);
		
		exit_pager_page(&PP,page);

		if (menu_need_redraw(page)) {
		    menu_ClearScreen(page);
		    
		    do_redraw = 1;
		}

		if (cmd == EOF) {
		    ret = sp_EOF;
		    goto quit;
		}

		if (cmd) {

		    DPRINT(Debug,10,(&Debug,
				     "preview_message: metapager gives command %d\n",
				     cmd));
		    printed_prompt = 0;
		    goto got_command;
		}
	    }
		break;

	    case '?': {
		if (printed_prompt) {
		    menu_Write_to_screen(prompt_area,
				      FRM("?"));
		    FlushBuffer();
		}

		cmd = help_generic(all_cmds,TRUE,page,prompt_area);

		if (menu_need_redraw(page)) {
		    menu_ClearScreen(page);
		    
		    do_redraw = 1;
		}

		if (cmd == EOF) {
		    ret = sp_EOF;
		    goto quit;
		}

		if (cmd) {
		    printed_prompt = 0;
		    goto got_command;
		}
	    }
		break;

	    case 'f': {
		if (printed_prompt) {
		    menu_Write_to_screen(prompt_area,
					 CATGETS(elm_msg_cat, ElmSet, 
						 ElmPreviewMenuForgetMessage,
						 "Forget message"));
		    FlushBuffer();
		}

		ret = sp_forget;
		goto quit;
	    }
		break;

	    preview_msg_headers:
	    case 'H': {
		int sf = elm_filter;
		struct pager_page *PP = init_pager_page(NULL);

		if (printed_prompt) {
		    if (elm_filter)
			menu_Write_to_screen(prompt_area,
					     CATGETS(elm_msg_cat, ElmSet, 
						     ElmPreviewMenuViewMssAllHdrs,
						     "View message with headers..."));
		    else
			menu_Write_to_screen(prompt_area,
					     CATGETS(elm_msg_cat, ElmSet, 
						     ElmPreviewMenuViewMessage,
						     "View message"));
		    FlushBuffer();
		}

		elm_filter = 0;
		cmd = metapager(preview_fp,&Header,
				METAPAGER_do_headers|METAPAGER_no_index,
				0,0,PP,all_cmds);
		
		exit_pager_page(&PP,page);
		elm_filter = sf;
		if (menu_need_redraw(page)) {
		    menu_ClearScreen(page);
		    
		    do_redraw = 1;
		}

		if (cmd == EOF) {
		    ret = sp_EOF;
		    goto quit;
		}

		if (cmd) {

		    DPRINT(Debug,10,(&Debug,
				     "preview_message: metapager gives command %d\n",
				     cmd));
		    printed_prompt = 0;
		    goto got_command;
		}
	    }
		break;
		

	    case ctrl('L'):
		goto redraw;

	    case 'm': {
		if (printed_prompt) {
		    menu_Write_to_screen(prompt_area,
					 CATGETS(elm_msg_cat, ElmSet, 
						 ElmPreviewMenuMailMessage,
						 "Mail message"));
		    FlushBuffer();
		}
		
		ret = sp_send;
		goto quit;
	    }
		break;

	    preview_parts:
	    case 'v': {
		if (printed_prompt) {
		    menu_Write_to_screen(prompt_area,
					 CATGETS(elm_msg_cat, ElmSet, 
						 ElmViewParts,
						 "View parts of message"));
		    FlushBuffer();
		}

		attach_menu(preview_fp,&Header.mime_rec,
			    NULL,Header.header_charset,
			    NULL,&Header,aview,mailbox,
			    &Header.header_error,
			    remote_server);
		do_redraw = 1;
	    }
		break;
		
	    case 'V': {
		if (printed_prompt) {
		    menu_Write_to_screen(prompt_area,
					 CATGETS(elm_msg_cat, ElmSet, 
						 ElmPreviewMenuPreSendScreen,
						 "Go to Mail Pre-Send Screen"));
		    FlushBuffer();
		}

		ret = sp_verify_trans;
		*command_ch = '\0';
		goto quit;
	    }
		break;

	    default: {

		const struct elm_command * snd_cmd =
		    lookup_elm_command(snd_cmds,cmd);

		if (snd_cmd) {
		    if (printed_prompt) {
			const struct string * S =
			    elm_command_key_desc(snd_cmd);

			if (S) {
			    /* uses description as prompt text! */
			    menu_Write_to_screen(prompt_area,
						 FRM("%S"),
						 S);
			    FlushBuffer();
			}
		    }
		    *command_ch = cmd;
		    ret = sp_verify_trans;
		    goto quit;

		} else {

		    DPRINT(Debug,10,(&Debug,
				     "preview_message: command %d not found\n",
				     cmd));

		    menu_Write_to_screen(prompt_area,
					 FRM("%c??"), 07);
		    FlushBuffer();
		    if (sleepmsg > 0)
			error_sleep((sleepmsg + 1) / 2);
		}
		
	    }
		break;

	    }
	}

	*command_ch = cmd;

    quit:
	free_commands(&all_cmds);
	free_commands(&cmds);
	erase_menu_context(&title_area);
	erase_menu_context(&prompt_area);
	erase_menu_context(&page);
	if (parent_page)
	    menu_trigger_redraw(parent_page);
    } else {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedParsePreviewMess,
			  "Failed to parse Mime structure from preview message: %s"),
		  preview_filename);
    }

    
 fail:


    if (preview_filename) {

	if (preview_fp) {
	    fclose(preview_fp);
	    preview_fp = NULL;

	    unlink(preview_filename);	    
	}

	free(preview_filename);
	preview_filename = NULL;
    }
   
    if (hdr)
	delete_headers(&hdr);

    header_clear(&Header);
    free_out_state(&preview_out_state);

    DPRINT(Debug,10,(&Debug,"preview_message="));
    switch (ret) {
    case sp_none: DPRINT(Debug,10,(&Debug,"sp_none")); break;
    case sp_send: DPRINT(Debug,10,(&Debug,"sp_send")); break;
    case sp_verify_trans: DPRINT(Debug,10,(&Debug,"sp_verify_trans")); break;
    case sp_forget: DPRINT(Debug,10,(&Debug,"sp_forget")); break;
    case sp_EOF: DPRINT(Debug,10,(&Debug,"sp_EOF")); break;
    }
    DPRINT(Debug,10,(&Debug," (%d)\n",ret));
    return ret;
}
/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
