static char rcsid[] = "@(#)$Id: strings.c,v 2.4 2015/11/01 18:23:37 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/strings.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 		  Copyright (c) 1986, 1987 Dave Taylor
 * 		  Copyright (c) 1988, 1989, 1990, 1991 USENET Community Trust
 *****************************************************************************/

/** This file contains all the string oriented functions for the
    ELM Mailer, and lots of other generally useful string functions! 

    For BSD systems, this file also includes the function "tolower"
    to translate the given character from upper case to lower case.

**/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"misc");

void Centerline(line, string, page)
     int line;
     char *string;
     struct menu_context  *page;
{
    /** Output 'string' on the given line, centered. **/
    
    int length, col;
    int LINES, COLUMNS;
    
    menu_get_sizes(page, &LINES, &COLUMNS);   
    
    length = strlen(string);
    
    if (length > COLUMNS) {
	DPRINT(Debug,8,(&Debug,
			"Centerline: length=%d > columns=%d",
			length,COLUMNS));
	col = 0;
    } else
	col = (COLUMNS - length) / 2;
    
    menu_PutLine0(page,line, col, string);
}

char *argv_zero(string)
     const char *string;
{
    /** given a string of the form "/something/name" return a
	string of the form "name"... **/

    static char buffer[NLEN];
    int i, j=0;

    for (i=strlen(string)-1; string[i] != '/'; i--)
	buffer[j++] = string[i];
    buffer[j] = '\0';

    reverse(buffer);

    return( (char *) buffer);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
