static char rcsid[] = "@(#)$Id: imap.c,v 2.6 2020/01/18 20:07:41 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_url.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"url");

#define URL_imap_magic		0xEC08

struct url_imap {

    unsigned short        magic;     /* URL_imap_magic */

    struct string       * params;
    struct string       * query;
};

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(uh_init_url uh_init_imap)
static void uh_init_imap  P_((struct url *url));
static void uh_init_imap(url)
     struct url *url;
{
    url->u.imap = safe_malloc (sizeof (*  url->u.imap));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)url->u.imap,sizeof (* url->u.imap));

    url->u.imap->magic = URL_imap_magic;

    url->u.imap->params = NULL;    
    url->u.imap->query  = NULL;    
}

S_(uh_free_url uh_free_imap)
static void uh_free_imap  P_((struct url *url));
static void uh_free_imap(url)
     struct url *url;
{
    if (URL_imap_magic != url->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_free_imap",
	      "bad  magic number",0);

    if (url->u.imap->params)
	free_string(& (url->u.imap->params));
    if (url->u.imap->query)
	free_string(& (url->u.imap->query));

    url->u.imap->magic = 0;  /* Invalidate */
    free(url->u.imap);
    url->u.imap = NULL;
}


S_(uh_parse_url_not_path  uh_parse_imap_not_path)
static int uh_parse_imap_not_path  P_((struct url *url, 
					     struct string *scheme_pesifix,
					     struct header_errors **header_error));

static int uh_parse_imap_not_path(url,scheme_pesifix,header_error)
     struct url *url;
     struct string *scheme_pesifix;
     struct header_errors **header_error;
{

    /* Should not be called */

    return 0;
}

S_(uh_dup_url_not_path uh_dup_imap_not_path)
static int uh_dup_imap_not_path  P_((struct url *url,
				       struct url *source));
static int uh_dup_imap_not_path(url,source)
     struct url *url;
     struct url *source;
{
    /* Should not be called */

    return 0;
}


S_(uh_parse_url_params uh_parse_imap_params)
static int uh_parse_imap_params  P_((struct url *url, 
				     struct string *scheme_pesifix,
				     struct header_errors **header_error));
static int uh_parse_imap_params(url,scheme_pesifix,header_error)
     struct url *url;
     struct string *scheme_pesifix;
     struct header_errors **header_error;
{
    if (URL_imap_magic != url->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_parse_imap_params",
	      "bad  magic number",0);

    /* Params are currently not supported */

    url->u.imap->params = dup_string(scheme_pesifix);

    return 1;
}



S_(uh_dup_url_params uh_dup_imap_params)
static int uh_dup_imap_params  P_((struct url *url,
				   struct url *source));
static int uh_dup_imap_params(url,source)
     struct url *url;
     struct url *source;
{
    if (URL_imap_magic != url->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_imap_params",
	      "bad  magic number (url)",0);

    if (URL_imap_magic != source->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_imap_params",
	      "bad  magic number (source)",0);

    /* Params are currently not supported */
    
    if (source->u.imap->params)
	url->u.imap->params = dup_string(source->u.imap->params);

    return 1;
}


S_(uh_parse_url_query uh_parse_imap_query)
static int uh_parse_imap_query  P_((struct url *url, 
					  struct string *scheme_pesifix,
					  struct header_errors **
					  header_error));
static int uh_parse_imap_query(url,scheme_pesifix,header_error)
     struct url *url;
     struct string *scheme_pesifix;
     struct header_errors **header_error;
{
    if (URL_imap_magic != url->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_parse_imap_query",
	      "bad  magic number",0);


    /* query is currently not supported */
    url->u.imap->query = dup_string(scheme_pesifix);

    return 1;
}

S_(uh_dup_url_query uh_dup_imap_query)
static int uh_dup_imap_query  P_((struct url *url,
				       struct url *source));
static int uh_dup_imap_query(url,source)
     struct url *url;
     struct url *source;
{
    if (URL_imap_magic != url->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_imap_query",
	      "bad  magic number (url)",0);

    if (URL_imap_magic != source->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_imap_query",
	      "bad  magic number (source)",0);

    /* query is currently not supported */
    if (source->u.imap->query)
	url->u.imap->query = dup_string(source->u.imap->query);

    return 1;
}


S_(uh_set_mailing_headers_from_url uh_set_mailing_headers_from_imap)
static int uh_set_mailing_headers_from_imap P_((struct mailing_headers *hdrs,
						  const struct url *url,
						  struct mailer_info 
						  *mailer_info));
static int uh_set_mailing_headers_from_imap(hdrs,url,mailer_info)
     struct mailing_headers *hdrs;
     const struct url *url;
     struct mailer_info  *mailer_info;
{

    /* Should not be called */

    return 0;
}


S_(uh_get_body_string_from_url uh_get_body_string_from_imap)
static const struct string * uh_get_body_string_from_imap P_((const struct 
								url *url,
								int *errors));
static const struct string * uh_get_body_string_from_imap(url,errors)
     const struct url *url;
     int *errors;
{
    /* Should not be called */

    return NULL;
}

S_(uh_not_path_to_raw_url uh_not_path_to_raw_imap)
static struct string * uh_not_path_to_raw_imap P_((const struct url *url));
static struct string * uh_not_path_to_raw_imap(url) 
     const struct url *url;
{
    /* Should not be called */
  
    return NULL;
}


S_(uh_params_to_raw_url uh_params_to_raw_imap)
static int uh_params_to_raw_imap P_((const struct url *url, 
				       struct string **result));
static int uh_params_to_raw_imap(url,result)
     const struct url *url; 
     struct string **result;
{
    *result = NULL;

    if (URL_imap_magic != url->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_params_to_raw_imap",
	      "bad magic number",0);

    /* Params are currently not supported */
    if (url->u.imap->params)
	*result = dup_string(url->u.imap->params);

    return 1;
}


S_(uh_query_to_raw_url uh_query_to_raw_imap)
static int uh_query_to_raw_imap P_((const struct url *url, 
				      struct string **result));
static int uh_query_to_raw_imap(url,result)
     const struct url *url; 
     struct string **result;
{
    *result = NULL;

    if (URL_imap_magic != url->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_query_to_raw_imap",
	      "bad magic number",0);

    /* Query is not currently supported */

     if (url->u.imap->query)
	*result = dup_string(url->u.imap->query);

    return 1;
}

#ifdef REMOTE_MBX
static struct folder_info * 
  get_folder_from_x P_((const struct url *url,
			verify_remote_url_f *verify_remote,
			const struct browser_url_method  *schema,
			int   * ret_letter /* returns '\0' or EOF */
			));
static struct folder_info * get_folder_from_x(url,verify_remote,schema,ret_letter)
     const struct url *url;
     verify_remote_url_f *verify_remote;
     const struct browser_url_method  *schema;
     int   * ret_letter /* returns '\0' or EOF */;
{
    struct folder_browser * browser = get_browser_from_host_url(url,schema,verify_remote,
								ret_letter);
    struct folder_info    * ret = NULL;

    if (!browser) {
	DPRINT(Debug,11,(&Debug,
			 "get_folder_from_x: Failed to get browser\n"));
	
	goto fail;
    }

    if (! browser_select_url_path(browser,url,schema)) {

	DPRINT(Debug,11,(&Debug,
			 "get_folder_from_x: Failed to select folder\n"));


	goto fail;
    }


    /* FIXME --- Is TreatAsSpooled  is on correct place ? */
    ret = folder_from_dir_item(browser,TreatAsSpooled);

    if (!ret) {
	DPRINT(Debug,11,(&Debug,
			 "get_folder_from_x: Failed to get folder\n"));
    }

 fail:

    if (browser)
	free_dir (& browser);

    return ret;
}
#endif


S_(uh_get_folder_from_url uh_get_folder_from_imap)
static struct folder_info * uh_get_folder_from_imap
      P_((const struct url *url,
	  verify_remote_url_f *verify_remote,
	  int   * ret_letter /* returns '\0' or EOF */
	  ));
static struct folder_info * uh_get_folder_from_imap(url,verify_remote,ret_letter)
     const struct url *url;
     verify_remote_url_f verify_remote;
     int   * ret_letter /* returns '\0' or EOF */;
{
#ifdef REMOTE_MBX
    return get_folder_from_x(url,verify_remote,&URL_imap,ret_letter);
#else
    return NULL;
#endif
}

S_(uh_get_url_type uh_get_imap_type)
static enum url_type uh_get_imap_type P_((const struct url *url));
static enum url_type uh_get_imap_type(url)
     const struct url *url;
{
    if (URL_imap_magic != url->u.imap->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_get_imap_type",
	      "bad magic number",0);
    
#ifdef REMOTE_MBX

    if (! url->host)
	return url_unknown;

    /* Params are currently not supported */
    if (url->u.imap->params)
	return url_unknown;

    /* Query is not currently supported */
    if (url->u.imap->query)
	return url_unknown;

    if (url->path) {
	int len = url_path_len(url->path);
	int i;
	const struct url_path_elem *x1;

	/* Is refering folder (mailbox)? */

	/* 1) Check path elements */
	for (i = 0; i < len-1; i++) {
	    const struct url_path_elem *x = get_url_path_element(url->path,i);
	    if (!x)
		return url_unknown;

	    if (! x->trailing_slash)
		return url_unknown;
	}

	if (len < 1)
	    return url_unknown;

	/* 2) Last element must not end to / */

	x1 = get_url_path_element(url->path,len-1);

	if (x1->trailing_slash)
	    return url_mailbox_list;     /* Not supported */

	return url_mailbox;
    }

    /* If there is not path, it is whole imap server */

    return url_mailbox_list;    /* Not supported */

#else

    /* If remote mailboxes are not supported, then 
       imap urls can not be supported ...
    */

    return url_unknown;

#endif
}


struct url_handler URL_imap_handler = {
    URL_handler_magic,
    URLFLAG_common|URLFLAG_username|URLFLAG_port|URLFLAG_path|
    URLFLAG_params|URLFLAG_query,
    url_unknown,
    uh_init_imap,
    uh_free_imap,
    uh_parse_imap_not_path,
    uh_dup_imap_not_path,
    uh_parse_imap_params,
    uh_dup_imap_params,
    uh_parse_imap_query,
    uh_dup_imap_query,
    uh_set_mailing_headers_from_imap,
    uh_get_body_string_from_imap,
    uh_not_path_to_raw_imap,
    uh_params_to_raw_imap,
    uh_query_to_raw_imap,
    uh_get_folder_from_imap,
    uh_get_imap_type
};

S_(uh_get_folder_from_url uh_get_folder_from_imaps)
static struct folder_info * uh_get_folder_from_imaps P_((const struct url *url,
							 verify_remote_url_f *verify_remote,
							 int   * ret_letter /* returns '\0' or EOF */
							 ));
static struct folder_info * uh_get_folder_from_imaps(url,verify_remote,ret_letter)
     const struct url *url;
     verify_remote_url_f verify_remote;
     int   * ret_letter /* returns '\0' or EOF */;
{
#ifdef REMOTE_MBX
    return get_folder_from_x(url,verify_remote,&URL_imaps,ret_letter);
#else
    return NULL;
#endif
}

struct url_handler URL_imaps_handler = {
    URL_handler_magic,
    URLFLAG_common|URLFLAG_username|URLFLAG_port|URLFLAG_path|
    URLFLAG_params|URLFLAG_query,
    url_unknown,
    uh_init_imap,
    uh_free_imap,
    uh_parse_imap_not_path,
    uh_dup_imap_not_path,
    uh_parse_imap_params,
    uh_dup_imap_params,
    uh_parse_imap_query,
    uh_dup_imap_query,
    uh_set_mailing_headers_from_imap,
    uh_get_body_string_from_imap,
    uh_not_path_to_raw_imap,
    uh_params_to_raw_imap,
    uh_query_to_raw_imap,
    uh_get_folder_from_imaps,
    uh_get_imap_type
};



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

