static char rcsid[] = "@(#)$Id: view_one_thread.c,v 2.25 2021/01/10 15:47:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.25 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_elm.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"mail");

#if ANSI_C
static subpage_simple_redraw sb_thread1_menu;
#endif
static int sb_thread1_menu P_((struct menu_context  *ptr,
			       struct menu_param *list));
static int sb_thread1_menu(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    enum user_level_v ul = 
	give_dt_enumerate_as_int(&user_level);

    menu_ClearScreen(ptr);
    
    if (ul == user_level_beginner) {	/* a rank beginner.  Give less options  */
	menu_print_format_center(ptr,0,
				 CATGETS(elm_msg_cat, MeSet, 
					 MeLevel0Thread1Line1,
					 "You can use any of the following commands by pressing the first character;"));
	menu_print_format_center(ptr,1,
				 CATGETS(elm_msg_cat, MeSet, 
					 MeLevel0Thread1Line2,
					 "m)ail a message, r)eply mail, return to thread i)ndex"));
	menu_print_format_center(ptr,2,
				 CATGETS(elm_msg_cat, MeSet, 
					 MeLevel0Thread1Line3,
					 "To read a message, press <return>.  j = move down, k = move up"));
    } else {
	menu_print_format_center(ptr,0,
				 CATGETS(elm_msg_cat, MeSet, 
					 MeLevel1Thread1Line1,
					 "|=pipe, !=shell, ?=help, <n>=set current to n, /=search pattern"));
        menu_print_format_center(ptr,1,
				 CATGETS(elm_msg_cat, MeSet, 
					 MeLevel1Thread1Line2,
					 "a)lias, C)opy, d)elete, f)orward, g)roup reply, m)ail,"));
	menu_print_format_center(ptr,2, 
				 CATGETS(elm_msg_cat, MeSet, 
					 MeLevel1Thread1Line3,
					 "n)ext, o)ptions, P)rint text, r)eply, s)ave, t)ag, or i)ndex"));
    }

    return 1;
}

static int showmsg_thread1_cmd P_((     struct MailboxView *mailbox,
					int cmd, 
					struct pager_page *pager_page));
static int showmsg_thread1_cmd(mailbox,cmd,pager_page)
     struct MailboxView *mailbox;
     int cmd; 
     struct pager_page *pager_page;
{
    struct menu_common MENU;
    
    set_mcommon_from_mbxview(&MENU,mailbox);

    switch (cmd) {
    case '|' : {
	int current = get_current(mailbox);
	
	put_cmd_name(pager_page, TRUE,
		     CATGETS(elm_msg_cat, MeSet, MePipe, "Pipe"));
	
	if (give_message_data(mailbox,current-1,
			      NULL,NULL,NULL,
			      NO_mime_parse))
	    do_pipe(mailbox, 
		    pager_page->root,
		    pager_page->prompt_area);     
	    
	else {
	    DPRINT(Debug,3,(&Debug, 
			    "give_message_data [%d] fails",current-1));
	}
    }
	break;
    }

    return cmd;
}

static void set_mailbox_screen P_((struct menu_context  *page, 
				   struct screen_parts *LOC,
				   struct menu_param   *LIST));
static void set_mailbox_screen(page,LOC, LIST)
     struct menu_context  *page;
     struct screen_parts *LOC;
     struct menu_param   *LIST;
{    
    int   LINES, COLUMNS;	

    menu_get_sizes(page,&LINES, &COLUMNS);

    /* 1)  Title part of screen */

    if (! LOC->title_page)
	LOC->title_page = new_menu_subpage(page,0,4,sb_update_title,LIST);
    else
	menu_subpage_relocate(LOC->title_page,page,0,4);

    /* 2) menu part */

    if (LOC->menu_page && LINES < 14)
	erase_menu_context (&(LOC->menu_page));
    else if (LOC->menu_page)
	menu_subpage_relocate(LOC->menu_page,page,LINES-8,4);
    else if (mini_menu && LINES > 14)
	LOC->menu_page = new_menu_subpage(page,LINES-8,4,
					  sb_thread1_menu,LIST);
   

    mailbox_screen_common(page,LOC, LIST);	
}

static void check_mailbox_screen P_((struct screen_parts *LOC,
				     struct menu_param *list));
static void check_mailbox_screen(LOC,list)
     struct screen_parts *LOC;
     struct menu_param *list;
{
    if (menu_resized(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page resized\n"));

    }
    if (menu_need_redraw(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page redraw???\n"));
	sb_update_title(LOC->title_page,list);	
    }
    if (LOC->menu_page) {
	/* 2) menu page */
	if (menu_resized(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page resized\n"));
	    
	}
	if (menu_need_redraw(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page redraw???\n"));
	    sb_thread1_menu(LOC->menu_page,list);
	}
    }

    /* 3) prompt part */
    if (menu_resized(LOC->prompt_page)) {
	DPRINT(Debug,1, (&Debug, "prompt page resized\n"));
    }
    if (menu_need_redraw(LOC->prompt_page)) {
	menu_ClearScreen(LOC->prompt_page);

	show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
    }    

    /* 4) headers part */
    if (menu_resized(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page resized\n"));
    }
    if (menu_need_redraw(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page redraw\n"));
	menu_ClearScreen(LOC->header_page);
    }
}

/* May return EOF */
static int thread1_loop P_((struct MailboxView *mailbox,
			     struct AliasView *aview,
			     int *needresort));
static int thread1_loop(mailbox, aview,needresort)
     struct MailboxView *mailbox;
     struct AliasView *aview;     
     int *needresort;
{
    int leave = 0;
    int retch = '\0';

    struct menu_context  *page = new_menu_context();
    struct screen_parts LOC = { NULL };
    struct menu_common MENU;
    struct menu_param  PARAM[elm_mp_COUNT+1] = { 
	{ mp_menu_common, { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_END,         { 0 } }
    };

    struct elm_commands *pager_cmds = give_view_thread_pager_commands();
    struct elm_commands *menu_cmds  = give_view_thread_mail_commands();


    int   LINES, COLUMNS;	

    mp_list_set_mcommon(PARAM,elm_mp_menu,&MENU);


    menu_get_sizes(page,&LINES, &COLUMNS);

    set_mcommon_from_mbxview(&MENU,mailbox);
    set_mailbox_screen(page,&LOC,PARAM);

    resort_mailbox(mailbox,1);

    get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
    copy_current(&MENU,LOC.header_page);

    showscreen(page);


    while (!leave) {
	int ch;

	menu_set_default(page);

	if (menu_resized(page)) {
	
	    set_mailbox_screen(page,&LOC,PARAM);
		    
	    menu_get_sizes(page,&LINES, &COLUMNS);

	    menu_trigger_redraw(page);
	} 

	new_mail_check(mailbox, page, &LOC, NULL);
	
	if (update_view(mailbox)) {
	    resort_mailbox(mailbox,1);

	    get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
	    menu_trigger_redraw(LOC.header_page);
	    menu_trigger_redraw(LOC.title_page);	 

	    *needresort = 1;
	}

	if (menu_need_redraw(page)) 
	    showscreen(page);
	check_mailbox_screen(&LOC, PARAM);

	{   
	    int lin,col;
	    
	    menu_PutLineX(LOC.prompt_page,0,0,
			    FRM("%S"),mcommon_give_item(&MENU, m_Prompt));
	    menu_GetXYLocation(LOC.prompt_page,&lin,&col);
	    
	    menu_CleartoEOLN(LOC.prompt_page);
	    ch = GetPrompt(LOC.prompt_page,elm_timeout);
	    
	    menu_CleartoEOS(LOC.prompt_page);
	    
	    if (isascii(ch) && isprint(ch)) {
		  DPRINT(Debug,4,(&Debug, 
				  "\nCommand: %c [%d]\n\n", ch, ch));
	    } else {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %d\n\n", ch));
	    }
	    
	    set_error("");	/* clear error buffer */
	    
	    menu_MoveCursor(LOC.prompt_page,lin,col);
	}

	ch = mailbox_command(mailbox,ch, &LOC,
			     showmsg_thread1_cmd, aview, 
			     page,pager_cmds,0,menu_cmds);

	switch (ch) {
	case 0:  /* OK */
	    break;

	case F3_KEY_MARK:
	    mini_menu = ! mini_menu;

	    if (LOC.menu_page && !mini_menu)
		erase_menu_context (&(LOC.menu_page));

	    DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));
	    
	    set_mailbox_screen(page,&LOC,PARAM);
	    	    
	    menu_trigger_redraw(page);
	    
	    break;

	case '|'    :   {
	    int current = get_current(mailbox);
	    
	    menu_Writechar(LOC.prompt_page,
			   '|');
	    
	    if (current < 1) {
		lib_error(CATGETS(elm_msg_cat, MeSet, 
				  MeNoMailToPipe,
				  "No mail to pipe!"));
		
	    } else if (give_message_data(mailbox,current-1,
					 NULL,NULL,NULL,NO_mime_parse)) {
		
		/* softkeys_off(); */
		
		do_pipe(mailbox, page,LOC.prompt_page);			       

		/* softkeys_on(); */
	    } else {
		DPRINT(Debug,3,(&Debug, 
				"give_message_data [%d] fails",current-1));
	    }
	}
	    break;

	case 'o'    :  {
#if UNUSED
	    int current = get_current(mailbox);
#endif
	    int i;
	    int setscreen = 0;

	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, MeSet,
					 MeOptions,
					 "Options"));

	    i=options(mailbox, aview, page,&setscreen);

	    if (setscreen) {
		if (LOC.menu_page && !mini_menu)
		    erase_menu_context (&(LOC.menu_page));
		
		DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));

		set_mailbox_screen(page,&LOC,PARAM);

		menu_trigger_redraw(page);
	    }

	    if (i > 0) {
#if UNUSED
		current = get_current(mailbox);
#endif
		get_page(&MENU, LOC.header_page);
	    } else if (i < 0)
		goto OUT;
	    
	}
	      break;



	case ctrl('Q') :
	case 'q':
	case 'Q':
	case 'i':
	case 'x':
	case 'X':
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, MeSet,
					 MeReturnThreadIndex,
					 "Return to thread index"));  
	    FlushBuffer();

	    leave = 1;

	    break;
	case EOF:
	    retch = EOF;
	    goto OUT;

	default:
	    if (isascii(ch) && isprint(ch))
		lib_error(CATGETS(elm_msg_cat, MeSet,
				  MeThreadUnknownCommand,		       
				  "Unknown command: %c"), 
			  ch);
	    else
		lib_error(CATGETS(elm_msg_cat, MeSet,
				  MeUnknownCommand2,			
				  "Unknown command."));

	}
	
	if (menu_need_redraw(page))
	    showscreen(page);
	
	check_range(&MENU, &LOC);
	check_mailbox_screen(&LOC, PARAM);


    } /* the BIG while loop! */

 OUT:

    free_commands(&pager_cmds);   /* Decrement refcount */
    free_commands(&menu_cmds);   /* Decrement refcount */

    free_mailbox_screen(&LOC);	
    erase_menu_context(&page);

    return retch;
}

/* May return EOF */
int ViewThread1(parent_mailbox, aview,thread_index,parent_page, needresort)
     struct MailboxView *parent_mailbox;
     struct AliasView *aview;     
     int thread_index;
     struct menu_context  *parent_page;
     int *needresort;
{
    int retch = '\0';

    struct MailboxView *new_mailbox = NULL;

    new_mailbox = thread_to_mailbox_view(parent_mailbox,thread_index);

    if (new_mailbox) {
	int r;
        struct cancel_data *cd = NULL;
	
	if (get_message_count(new_mailbox) > 0) {
	    set_current(new_mailbox,1);   /* Set current to first message */

	    update_view(new_mailbox);
	}

	retch = thread1_loop(new_mailbox, aview, needresort);

	setup_mbx_cancel_message(&cd,mbx_leaving_mailbox);

        DPRINT(Debug,9, (&Debug, 
                         "ViewThread1: freeing mailbox\n"));	
	r = free_mailbox(& new_mailbox,cd);
	if (!r) {
            DPRINT(Debug,9, (&Debug, 
                             "ViewThread1: free_mailbox failed\n"));
        }       
        if (is_canceled(cd)) {
            DPRINT(Debug,9, (&Debug, 
                             "ViewThread1: Cancel on free_mailbox\n"));
        }
        free_cancel(&cd);

	/* If there is new messages arrived when running on thread1_loop()
	   parent mailbox is not sorted
	   
	   However, because thread1 collection mode uses original mailbox,
	   update_view() status of parent mailbox is reset, so we need
	   do resorting on here....
	   
	*/
	if (*needresort)
	    resort_mailbox(parent_mailbox,1);


	menu_trigger_redraw(parent_page);

	/* Force default return to parent page ... */
	menu_set_default(parent_page); 
    }

    return retch;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
