case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot=".."
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

: Avoid duplicate option
if $test "X$dynamic_opt" != "X$backtrace_opt" ; then
   XX="$backtrace_opt"
else
   XX=
fi

libx="../libs/libelmme-base.a ../libs/libelmme-mailer.a ../libs/libelmme-mbox.a ../libs/libelmme-addr.a ../libs/libelmme-misc.a ../libs/libelmme-mime.a"
libxs="../shlib/libelmme-base.so ../shlib/libelmme-mailer.so ../shlib/libelmme-mbox.so ../shlib/libelmme-addr.so ../shlib/libelmme-misc.so ../shlib/libelmme-mime.so"
headers="elm_defs.h defs_major.h"

echo "Extracting utils/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
# @(#)$Id: Makefile.SH,v 2.24 2023/12/13 16:55:32 hurtta Exp $
#
# Makefile for the Elm (ME+) system utilities
#
# Modified by Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
# 	      	      (was hurtta+elm@posti.FMI.FI)
#         or  Kari Hurtta <elm@elmme-mailer.org>
########################################################################
# Based on Elm 2.4 utils/Makefile.SH. That code was following copyright:
#
#         (C) Copyright 1986,1987, by Dave Taylor
#         (C) Copyright 1988-1992, USENET Community Trust
########################################################################
#
# Variables
#	Variables established by Configure
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
CHMOD		=	$chmod
CP		=	$cp
DEST		=	\$(ELM_ROOT)//$bin
ECHO		=	$echo
LFLAGS		=	$ldflags $dynamic_opt $XX $xenlf
LIB		=	\$(ELM_ROOT)//$lib
LIB2		= 	$dlopen_lib $libs
LIB1		=	$cryptlib
LIBS		=	$termlib $dbm
LINT		=	$lint
LN		=	$ln
MV		=	$mv
OPTIMIZE	=	$optimize
RM		= 	$rm -f
TOUCH		=	$touch
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

if $test "X$rpath_ok" = XOK ; then

# Use -rpath for directories need by shared_libs 
# It is is possbile to also use -rpath-link on Linux and SunOS
# but it may require extra Configure test....

	 rlink=
	 for domake in $shared_list ; do
		dir=
		varname="\$${domake}_lib_dir"
		eval "dir=$varname"
		if $test "X$dir" != X ; then
			rlink="$rlink $rpath_opt$dir"
		fi
	 done

	 cat >>Makefile <<!GROK!THIS!
RPATH           =       $rpath_opt$shlib $rlink
!GROK!THIS!

else
	 cat >>Makefile <<!GROK!THIS!
RPATH           =       
!GROK!THIS!

fi

if $test "$make_sets_make" != "$define" ; then  

	cat >>Makefile <<!GROK!THIS!
MAKE		=	$make
!GROK!THIS!

fi

case "$d_strstr" in
define)	strobj= ;;
*)	strobj="../lib/strstr.o"
	;;
esac
case "$d_dlopen_libs" in
define)  regshared="\$(BIN)/elmlibregister-shared"
	 regnoshared="\$(LIB)/elmlibregister"
	 regsharedbin="\$(BIN)/elmlibregister"  
	 regsharedobj=elmlibregister.o	
	 ;;
*)	 regshared=
	 regnoshared=
	 regsharedbin=	
	 regsharedobj=
	;;
esac
cat >>Makefile <<!GROK!THIS!
STROBJ		= 	$strobj
REGSHARED       =	$regshared 
REGNOSHARED	=       $regnoshared
REGSHAREDBIN	=	$regsharedbin
REGSHAREDOBJ	=	$regsharedobj
!GROK!THIS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'
SHLIST          =	$(BIN)/elmalias-shared		\
			$(BIN)/fastmail-shared		\
			$(BIN)/frm-shared		\
			$(BIN)/newalias-shared		\
			$(BIN)/newmail-shared		\
			$(BIN)/prlong-shared		\
			$(BIN)/elmaliases-write-shared	\
			$(BIN)/elmcharset-shared	\
			$(BIN)/elmiso2022sets-shared	\
			$(BIN)/elmconfwriter-shared	\
			$(BIN)/elmrc-write-shared	\
			$(BIN)/elmterminal-shared	\
			$(BIN)/elmmimetypes-shared	\
			$(BIN)/elmmailinglists-shared	\
			$(BIN)/elmmailservices-shared	\
			$(BIN)/elmtagfilterents-shared  \
			$(BIN)/elmunidata-shared	\
			$(BIN)/elmbindata-shared	\
			$(BIN)/elmstringconvert-shared  \
			$(BIN)/elmhashmarks-shared      \
			$(REGSHARED) 

# NOTE:                 No shared version for elmregister!
!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'
SHLIST          =

!NO!SUBS!

fi

cat >>Makefile <<'!NO!SUBS!'
#	Other general variables
BIN		=	../bin
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/hdrs
IHDR		=	../hdrs
SHELL		=	/bin/sh
REG             =       ../bin/elmregister

#	Lists
#		List of installed programs - excludes wnewmail and nfrm,
#		which are handled separately
INSTALL_LIST	=	$(DEST)/checkalias	\
			$(DEST)/elmalias	\
			$(DEST)/fastmail	\
			$(DEST)/frm		\
			$(DEST)/listalias	\
			$(DEST)/messages	\
			$(DEST)/newalias	\
			$(DEST)/newmail		\
			$(DEST)/printmail	\
			$(DEST)/elmstringconvert \
			$(LIB)/prlong		\
			$(LIB)/elmaliases-write	\
			$(LIB)/elmcharset       \
			$(LIB)/elmiso2022sets	\
			$(LIB)/elmconfwriter	\
			$(LIB)/elmrc-write	\
			$(LIB)/elmterminal	\
			$(LIB)/elmmimetypes	\
			$(LIB)/elmmailinglists  \
			$(LIB)/elmmailservices	\
			$(LIB)/elmtagfilterents \
			$(LIB)/elmunidata       \
			$(LIB)/elmbindata       \
			$(LIB)/elmregister	\
			$(LIB)/elmuninstall     \
			$(LIB)/elmhashmarks     \
			$(REGNOSHARED)


#		List of programs in bin directory
BINARY_LIST	=	$(BIN)/checkalias	\
			$(BIN)/elmalias		\
			$(BIN)/fastmail		\
			$(BIN)/frm		\
			$(BIN)/listalias	\
			$(BIN)/messages		\
			$(BIN)/newalias		\
			$(BIN)/newmail		\
			$(BIN)/printmail	\
			$(BIN)/prlong		\
			$(BIN)/elmaliases-write	\
			$(BIN)/elmcharset       \
			$(BIN)/elmiso2022sets	\
			$(BIN)/elmconfwriter	\
			$(BIN)/elmrc-write      \
			$(BIN)/elmterminal      \
			$(BIN)/elmmimetypes     \
			$(BIN)/elmmailinglists  \
			$(BIN)/elmmailservices	\
			$(BIN)/elmtagfilterents \
			$(BIN)/elmunidata       \
			$(BIN)/elmbindata       \
			$(BIN)/elmstringconvert \
			$(BIN)/elmregister      \
			$(BIN)/elmhashmarks     \
			$(REGSHAREDBIN) \
			$(SHLIST)

#		List of programs to $(LINT) - only C programs
LINT_LIST	=	elmalias_lint	\
			fastmail_lint	\
			frm_lint	\
			newalias_lint	\
			newmail_lint	\
			prlong_lint

#	List of all object files in all util programs (used in parallel makes)
UTIL_OBJ	=	elmalias.o		\
			fastmail.o		\
			from.o			\
			newalias.o		\
			newmail.o		\
			reghelper.o		\
			prlong.o		\
			elmaliases-write.o	\
			elmcharset.o            \
			elmiso2022sets.o	\
			elmconfwriter.o		\
			elmrc-write.o		\
			elmterminal.o		\
			elmmimetypes.o		\
			elmmailinglists.o	\
			elmmailservices.o	\
			elmunidata.o		\
			elmbindata.o		\
			elmstringconvert.o	\
			elmtagfilterents.o	\
			elmregister.o           \
			elmhashmarks.o		\
			$(REGSHAREDOBJ)

# Remove obsolete files
RMLIST          = rm-answer

#	Lists of source and object files for each C program
ELMALIAS_OBJ	=	elmalias.o
FASTMAIL_OBJ	=	fastmail.o
FRM_OBJ		=	from.o
NEWALIAS_OBJ	=	newalias.o reghelper.o aliases_helper.o
NEWMAIL_OBJ	=	newmail.o
PRLONG_OBJ	=	prlong.o
ELMALIASESWRITE_OBJ =	elmaliases-write.o reghelper.o aliases_helper.o
ELMCHARSET_OBJ  =       elmcharset.o reghelper.o  charmapcopy.o
ELMISO2022SETS_OBJ =	elmiso2022sets.o reghelper.o  charmapcopy.o
ELMCONFWRT_OBJ	=	elmconfwriter.o reghelper.o
ELMRCWRITE_OBJ	=	elmrc-write.o reghelper.o  
ELMTERMINAL_OBJ	=	elmterminal.o reghelper.o  
ELMMIMETYPES_OBJ =	elmmimetypes.o reghelper.o  
ELMMLIST_OBJ	=	elmmailinglists.o reghelper.o  
ELMMS_OBJ	=	elmmailservices.o reghelper.o 
ELMUNIDATA_OBJ	=	elmunidata.o reghelper.o  
ELMBINDATA_OBJ	=      elmbindata.o reghelper.o charmapcopy.o
ELMSCONV_OBJ	=	elmstringconvert.o
ELMTFILTENTS_OBJ =	elmtagfilterents.o reghelper.o
ELMLIBREG_OBJ	=       elmlibregister.o reghelper.o  
ELMHASHMARKS_OBJ =	elmhashmarks.o reghelper.o 

# Standard targets
all:			Makefile objects $(BINARY_LIST)
			cd readmsg; $(MAKE) $(MJ) $(MFLAGS) $@

#	This unusual target enables highly efficial compilation of object files
#	on systems that have the parallel make feature.
objects:		$& $(UTIL_OBJ)

install_s:		Makefile $(INSTALL_LIST) $(DEST)/wnewmail \
 $(DEST)/nfrm $(RMLIST)
			cd readmsg; $(MAKE) $(MJ) $(MFLAGS) $@

uninstall_s:		Makefile $(RMLIST)
			$(REG) rm $(INSTALL_LIST) $(DEST)/wnewmail $(DEST)/nfrm
			cd readmsg; $(MAKE) $(MJ) $(MFLAGS) $@

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1


#	This rule allows us to put lint output for each program on the
#	same file, but make sure we start off fresh each time.
lint:			
			$(RM) LINT.OUT; $(MAKE) $(MFLAGS) $(LINT_LIST)

clean:			
			$(RM) $(UTIL_OBJ) $(BINARY_LIST)

# Dependencies and rules
#	Dependencies and rules for compiling and linting C programs
.PRECIOUS:		def_utils.h $(IHDR)/elm_defs.h $(IHDR)/defs_major.h 

checkalias:		checkalias.SH	; sh $?
listalias:		listalias.SH	; sh $?
messages:		messages.SH	; sh $?
printmail:		printmail.SH	; sh $?


$(BIN)/elmalias:	$(ELMALIAS_OBJ) ../libs/libelmme-base.a \
 ../libs/libelmme-addr.a ../libs/libelmme-alias.a
			$(CC) $(LFLAGS) -o $@ $(ELMALIAS_OBJ) \
 ../libs/libelmme-alias.a ../libs/libelmme-addr.a \
 ../libs/libelmme-base.a $(LIB2)

$(BIN)/fastmail:	$(FASTMAIL_OBJ) ../libs/libelmme-base.a \
 ../libs/libelmme-addr.a ../libs/libelmme-mailer.a \
 ../libs/libelmme-misc.a
			$(CC) $(LFLAGS) -o $@ $(FASTMAIL_OBJ) \
 ../libs/libelmme-mailer.a ../libs/libelmme-addr.a \
 ../libs/libelmme-misc.a ../libs/libelmme-base.a $(LIB2)


$(BIN)/frm:		$(FRM_OBJ) ../libs/libelmme-base.a \
 ../libs/libelmme-addr.a ../libs/libelmme-mbox.a
			$(CC) $(LFLAGS) -o $@ $(FRM_OBJ) \
 ../libs/libelmme-mbox.a ../libs/libelmme-addr.a \
 ../libs/libelmme-base.a $(LIB2)

$(BIN)/newalias:	$(NEWALIAS_OBJ) ../libs/libelmme-base.a \
 ../libs/libelmme-alias.a ../libs/libelmme-addr.a 
			$(CC) $(LFLAGS) -o $@ $(NEWALIAS_OBJ) \
 ../libs/libelmme-alias.a ../libs/libelmme-addr.a \
 ../libs/libelmme-base.a $(LIB2)

$(BIN)/newmail:		$(NEWMAIL_OBJ) ../libs/libelmme-base.a ../libs/libelmme-addr.a ../libs/libelmme-mbox.a
			$(CC) $(LFLAGS) -o $@ $(NEWMAIL_OBJ) \
 ../libs/libelmme-mbox.a ../libs/libelmme-addr.a \
 ../libs/libelmme-base.a $(LIB2)

$(BIN)/prlong:		$(PRLONG_OBJ) ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(PRLONG_OBJ) ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmaliases-write: $(ELMALIASESWRITE_OBJ) ../libs/libelmme-base.a \
 ../libs/libelmme-addr.a ../libs/libelmme-alias.a 
			$(CC) $(LFLAGS) -o $@ $(ELMALIASESWRITE_OBJ) \
 ../libs/libelmme-alias.a ../libs/libelmme-addr.a \
 ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmcharset:      $(ELMCHARSET_OBJ) ../libs/libelmme-base.a \
  ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMCHARSET_OBJ) \
 ../libs/libelmme-misc.a ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmiso2022sets:	 $(ELMISO2022SETS_OBJ) ../libs/libelmme-base.a \
  ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMISO2022SETS_OBJ) \
 ../libs/libelmme-misc.a ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmconfwriter:	$(ELMCONFWRT_OBJ) ../libs/libelmme-misc.a \
  ../libs/libelmme-base.a ../libs/libelmme-mbox.a ../libs/libelmme-addr.a \
  ../libs/libelmme-alias.a ../libs/libelmme-mime.a
			$(CC) $(LFLAGS) -o $@ $(ELMCONFWRT_OBJ) \
  ../libs/libelmme-mime.a \
  ../libs/libelmme-misc.a ../libs/libelmme-alias.a \
  ../libs/libelmme-mbox.a ../libs/libelmme-addr.a \
  ../libs/libelmme-base.a $(LIB1) $(LIB2)

$(BIN)/elmrc-write:     $(ELMRCWRITE_OBJ) ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMRCWRITE_OBJ) ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmterminal:     $(ELMTERMINAL_OBJ) ../libs/libelmme-misc.a \
 ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMTERMINAL_OBJ) \
 ../libs/libelmme-misc.a ../libs/libelmme-base.a $(LIB2)


$(BIN)/elmmimetypes:     $(ELMMIMETYPES_OBJ) ../libs/libelmme-misc.a \
 ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMMIMETYPES_OBJ) \
 ../libs/libelmme-misc.a ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmmailinglists:     $(ELMMLIST_OBJ) ../libs/libelmme-misc.a \
 ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMMLIST_OBJ) \
 ../libs/libelmme-misc.a ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmmailservices: $(ELMMS_OBJ) ../libs/libelmme-misc.a \
 ../libs/libelmme-base.a 
			$(CC) $(LFLAGS) -o $@ $(ELMMS_OBJ) ../libs/libelmme-misc.a \
 ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmhashmarks: $(ELMHASHMARKS_OBJ) ../libs/libelmme-base.a ../libs/libelmme-mbox.a \
 ../libs/libelmme-addr.a
				$(CC) $(LFLAGS) -o  $@  $(ELMHASHMARKS_OBJ) \
 ../libs/libelmme-mbox.a ../libs/libelmme-addr.a ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmunidata:     $(ELMUNIDATA_OBJ) ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMUNIDATA_OBJ) ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmbindata:     $(ELMBINDATA_OBJ) ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMBINDATA_OBJ) ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmstringconvert: $(ELMSCONV_OBJ) ../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMSCONV_OBJ) ../libs/libelmme-base.a $(LIB2)

$(BIN)/elmtagfilterents: $(ELMTFILTENTS_OBJ) ../libs/libelmme-mime.a ../libs/libelmme-misc.a \
	../libs/libelmme-misc.a ../libs/libelmme-mbox.a ../libs/libelmme-addr.a \
 	../libs/libelmme-base.a
			$(CC) $(LFLAGS) -o $@ $(ELMTFILTENTS_OBJ) ../libs/libelmme-misc.a \
 ../libs/libelmme-mime.a ../libs/libelmme-misc.a ../libs/libelmme-mbox.a ../libs/libelmme-addr.a \
 ../libs/libelmme-base.a $(LIB1) $(LIB2)

../lib/putenv.o:
			cd ../lib; $(MAKE) putenv.o
../lib/strstr.o:
			cd ../lib; $(MAKE) strstr.o

../lib/convert_status.o:
			cd ../lib; $(MAKE) convert_status.o

$(BIN)/elmregister:	elmregister.o reghelper.o ../lib/putenv.o ../lib/convert_status.o $(STROBJ)
			$(CC) $(LFLAGS) -o $@ elmregister.o reghelper.o \
 ../lib/putenv.o ../lib/convert_status.o $(STROBJ)
$(BIN)/elmlibregister:  $(ELMLIBREG_OBJ) ../libs/libelmme-base.a \
 ../libs/libelmme-addr.a ../libs/libelmme-mailer.a ../libs/libelmme-mbox.a
		       $(CC) $(LFLAGS) -o $@ $(ELMLIBREG_OBJ) \
 ../libs/libelmme-mbox.a ../libs/libelmme-mailer.a \
 ../libs/libelmme-addr.a ../libs/libelmme-base.a \
 $(LIB2)

#	Rules to make shell scripts in bin directory
$(BIN)/checkalias:	checkalias
			$(CP) $? $@
			$(CHMOD) u+w,a+rx $@

$(BIN)/listalias:	listalias
			$(CP) $? $@
			$(CHMOD) u+w,a+rx $@

$(BIN)/messages:	messages
			$(CP) $? $@
			$(CHMOD) u+w,a+rx $@

$(BIN)/printmail:	printmail
			$(CP) $? $@
			$(CHMOD) u+w,a+rx $@

#	Dependencies of header files upon other header files they include

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_utils.h:		$(IHDR)/elm_defs.h $(INCLDIR)/patchlevel.h 
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@

#	Dependencies of C object files
elmalias.o:	def_utils.h $(INCLDIR)/s_elmalias.h \
  $(INCLDIR)/aliaslib.h $(INCLDIR)/addrlib.h
fastmail.o:	def_utils.h $(INCLDIR)/s_fastmail.h $(INCLDIR)/mailerlib.h \
  $(INCLDIR)/misclib.h $(INCLDIR)/schedule_time.h
from.o:		def_utils.h $(INCLDIR)/s_from.h $(INCLDIR)/s_elm.h $(INCLDIR)/mboxlib.h \
  $(INCLDIR)/addrlib.h 
newalias.o:	def_utils.h $(INCLDIR)/s_newalias.h $(INCLDIR)/mboxlib.h \
  $(INCLDIR)/aliaslib.h $(INCLDIR)/addrlib.h \
  $(INCLDIR)/reghelper.h aliases_helper.h
newmail.o:	def_utils.h $(INCLDIR)/s_newmail.h $(INCLDIR)/mboxlib.h \
  $(INCLDIR)/addrlib.h 
from.o:		def_utils.h $(INCLDIR)/s_from.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/mboxlib.h $(INCLDIR)/addrlib.h 
prlong.o:	def_utils.h
readmsg.o:	def_utils.h $(INCLDIR)/s_readmsg.h
elmaliases-write.o:	def_utils.h  $(INCLDIR)/aliaslib.h \
 $(INCLDIR)/addrlib.h $(INCLDIR)/reghelper.h $(INCLDIR)/s_me.h \
 $(INCLDIR)/s_elm.h $(INCLDIR)/rc_imp.h aliases_helper.h
aliases_helper.o: def_utils.h $(INCLDIR)/aliaslib.h $(INCLDIR)/addrlib.h \
 aliases_helper.h
elmcharset.o:	def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/cs_imp.h $(INCLDIR)/reghelper.h charmapcopy.h \
 $(INCLDIR)/misclib.h
elmiso2022sets.o: def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/cs_imp.h $(INCLDIR)/reghelper.h charmapcopy.h \
 $(INCLDIR)/misclib.h
elmconfwriter.o: def_utils.h  $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/s_elmrc.h $(INCLDIR)/rc_imp.h $(INCLDIR)/save_opts.h \
 $(INCLDIR)/misclib.h $(INCLDIR)/reghelper.h $(INCLDIR)/aliaslib.h \
 $(INCLDIR)/addrlib.h $(INCLDIR)/mboxlib.h $(INCLDIR)/melib.h
elmrc-write.o:	def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/rc_imp.h $(INCLDIR)/save_opts.h $(INCLDIR)/s_elmrc.h \
 $(INCLDIR)/reghelper.h
elmterminal.o:	def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/reghelper.h $(INCLDIR)/misclib.h
elmmimetypes.o: def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/reghelper.h $(INCLDIR)/misclib.h
elmmailinglists.o: def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/reghelper.h $(INCLDIR)/misclib.h $(INCLDIR)/rc_imp.h
elmunidata.o:	def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/unidata.h $(INCLDIR)/reghelper.h
elmbindata.o:	def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/bindata.h $(INCLDIR)/reghelper.h $(INCLDIR)/cs_imp.h \
 charmapcopy.o
elmstringconvert.o: def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h 
elmtagfilterents.o: def_utils.h $(INCLDIR)/misclib.h $(INCLDIR)/reghelper.h  $(INCLDIR)/s_me.h \
  $(INCLDIR)/s_elm.h $(INCLDIR)/melib.h $(INCLDIR)/addrlib.h $(INCLDIR)/mboxlib.h \
  $(INCLDIR)/rc_imp.h 
elmregister.o:	    $(IHDR)/defs_major.h $(INCLDIR)/patchlevel.h \
 $(INCLDIR)/reghelper.h $(IHDR)/convert_status.h
reghelper.o:	    $(IHDR)/defs_major.h $(INCLDIR)/patchlevel.h \
 $(INCLDIR)/reghelper.h
charmapcopy.o:	charmapcopy.h $(INCLDIR)/s_elm.h $(IHDR)/elm_defs.h \
 $(INCLDIR)/s_me.h $(INCLDIR)/reghelper.h  $(INCLDIR)/cs_imp.h
elmlibregister.o:   def_utils.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h \
 $(INCLDIR)/rc_imp.h $(INCLDIR)/save_opts.h $(INCLDIR)/s_elmrc.h \
 $(INCLDIR)/reghelper.h $(INCLDIR)/mailerlib.h $(INCLDIR)/mboxlib.h \
 $(INCLDIR)/schedule_time.h  $(INCLDIR)/addrlib.h
elmhashmarks.o:	    def_utils.h $(INCLDIR)/reghelper.h $(INCLDIR)/mboxlib.h \
 $(INCLDIR)/rc_imp.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h

#	Dependencies and rules for installing programs from bin directory

$(DEST)/checkalias:	$(BIN)/checkalias
			$(REG) copy -m 755 $? $@

$(DEST)/listalias:	$(BIN)/listalias
			$(REG) copy -m 755 $? $@

$(DEST)/messages:	$(BIN)/messages
			$(REG) copy -m 755 $? $@

$(DEST)/printmail:	$(BIN)/printmail
			$(REG) copy -m 755 $? $@

$(DEST)/wnewmail:	$(DEST)/newmail
			$(REG) link $? $@


$(LIB)/elmregister: $(BIN)/elmregister
			$(REG) copy -m 755 $? $@

$(LIB)/elmuninstall: $(LIB)/elmregister
			$(REG) link $? $@

rm-answer:
		$(REG) remove-installed $(DEST)/answer

!NO!SUBS!



for i in $libx
do
	y="`echo $i|$sed 's%^../%%'`"
cat >>Makefile <<!SUBS!
$i:
	cd ..; \$(MAKE) \$(MJ) \$(MFLAGS) $y
!SUBS!
done

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

$(BIN)/elmalias-shared:	$(ELMALIAS_OBJ) ../shlib/libelmme-base.so \
 ../shlib/libelmme-addr.so  ../shlib/libelmme-alias.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELMALIAS_OBJ) \
 ../shlib/libelmme-alias.so \
 ../shlib/libelmme-addr.so ../shlib/libelmme-base.so  $(LIB2)


$(BIN)/fastmail-shared:	$(FASTMAIL_OBJ) ../shlib/libelmme-base.so \
 ../shlib/libelmme-addr.so ../shlib/libelmme-mailer.so \
 ../shlib/libelmme-misc.so
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(FASTMAIL_OBJ) \
 ../shlib/libelmme-mailer.so ../shlib/libelmme-addr.so \
 ../shlib/libelmme-misc.so ../shlib/libelmme-base.so $(LIB2)


$(BIN)/frm-shared:		$(FRM_OBJ) ../shlib/libelmme-base.so \
 ../shlib/libelmme-addr.so ../shlib/libelmme-mbox.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(FRM_OBJ) \
 ../shlib/libelmme-mbox.so ../shlib/libelmme-addr.so \
 ../shlib/libelmme-base.so $(LIB2)

$(BIN)/newalias-shared:	$(NEWALIAS_OBJ) ../shlib/libelmme-alias.so \
 ../shlib/libelmme-base.so ../shlib/libelmme-addr.so \
 ../shlib/libelmme-misc.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(NEWALIAS_OBJ) \
 ../shlib/libelmme-misc.so ../shlib/libelmme-alias.so \
 ../shlib/libelmme-addr.so ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/newmail-shared: $(NEWMAIL_OBJ) ../shlib/libelmme-base.so \
 ../shlib/libelmme-mbox.so ../shlib/libelmme-addr.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(NEWMAIL_OBJ) \
 ../shlib/libelmme-mbox.so ../shlib/libelmme-addr.so \
 ../shlib/libelmme-base.so $(LIB2)



$(BIN)/prlong-shared:		$(PRLONG_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(PRLONG_OBJ) ../shlib/libelmme-base.so  $(LIB2)


$(BIN)/elmaliases-write-shared: $(ELMALIASESWRITE_OBJ) \
 ../shlib/libelmme-base.so ../shlib/libelmme-addr.so \
 ../shlib/libelmme-alias.so  
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELMALIASESWRITE_OBJ) \
 ../shlib/libelmme-alias.so ../shlib/libelmme-addr.so \
 ../shlib/libelmme-base.so $(LIB2)

$(BIN)/elmcharset-shared: $(ELMCHARSET_OBJ) \
  ../shlib/libelmme-misc.so ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) \
 $(ELMCHARSET_OBJ) ../shlib/libelmme-misc.so \
 ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmiso2022sets-shared: $(ELMISO2022SETS_OBJ) \
  ../shlib/libelmme-misc.so ../shlib/libelmme-base.so
			$(CC) $(LFLAGS) -o $@ $(RPATH) \
 $(ELMISO2022SETS_OBJ) ../shlib/libelmme-misc.so \
 ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmconfwriter-shared: $(ELMCONFWRT_OBJ)  ../shlib/libelmme-misc.so \
  ../shlib/libelmme-base.so ../shlib/libelmme-mbox.so \
  ../shlib/libelmme-addr.so ../shlib/libelmme-alias.so \
  ../shlib/libelmme-mime.so
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELMCONFWRT_OBJ) \
  ../shlib/libelmme-mime.so \
  ../shlib/libelmme-misc.so ../shlib/libelmme-alias.so \
  ../shlib/libelmme-mbox.so ../shlib/libelmme-addr.so \
  ../shlib/libelmme-base.so  $(LIB1) $(LIB2)

$(BIN)/elmrc-write-shared:      $(ELMRCWRITE_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELMRCWRITE_OBJ) \
 ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmlibregister-shared:  $(ELMLIBREG_OBJ) \
 ../shlib/libelmme-base.so ../shlib/libelmme-mailer.so \
 ../shlib/libelmme-addr.so ../shlib/libelmme-mbox.so
		       $(CC) $(LFLAGS) -o $@ $(RPATH) \
 $(ELMLIBREG_OBJ) ../shlib/libelmme-mbox.so \
 ../shlib/libelmme-base.so ../shlib/libelmme-addr.so \
 ../shlib/libelmme-mailer.so $(LIB2)

$(BIN)/elmterminal-shared:     $(ELMTERMINAL_OBJ) \
 ../shlib/libelmme-misc.so ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) \
 $(ELMTERMINAL_OBJ)  ../shlib/libelmme-misc.so \
 ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmmimetypes-shared:     $(ELMMIMETYPES_OBJ) \
 ../shlib/libelmme-misc.so ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) \
 $(ELMMIMETYPES_OBJ)  ../shlib/libelmme-misc.so \
 ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmmailinglists-shared:     $(ELMMLIST_OBJ) \
 ../shlib/libelmme-misc.so ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) \
 $(ELMMLIST_OBJ)  ../shlib/libelmme-misc.so \
 ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmmailservices-shared: $(ELMMS_OBJ) \
 ../shlib/libelmme-misc.so ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) \
 $(ELMMS_OBJ) ../shlib/libelmme-misc.so \
 ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmhashmarks-shared: $(ELMHASHMARKS_OBJ) ../shlib/libelmme-base.so \
 ../shlib/libelmme-mbox.so ../shlib/libelmme-addr.so
			$(CC) $(LFLAGS) -o  $@  $(RPATH) \
 $(ELMHASHMARKS_OBJ) ../shlib/libelmme-mbox.so ../shlib/libelmme-addr.so \
 ../shlib/libelmme-base.so $(LIB2)

$(BIN)/elmunidata-shared:     $(ELMUNIDATA_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELMUNIDATA_OBJ) ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmbindata-shared:     $(ELMBINDATA_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELMBINDATA_OBJ) ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmstringconvert-shared: $(ELMSCONV_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELMSCONV_OBJ) ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmtagfilterents-shared:  $(ELMTFILTENTS_OBJ) ../shlib/libelmme-mime.so \
 ../shlib/libelmme-misc.so ../shlib/libelmme-mbox.so ../shlib/libelmme-addr.so \
  ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELMTFILTENTS_OBJ) \
 ../shlib/libelmme-mime.so ../shlib/libelmme-misc.so ../shlib/libelmme-mbox.so \
 ../shlib/libelmme-addr.so ../shlib/libelmme-base.so  $(LIB1) $(LIB2)

$(DEST)/newmail:	$(BIN)/newmail-shared
			$(REG) copy -m 755 $? $@

$(DEST)/elmalias:	$(BIN)/elmalias-shared
			$(REG) copy -m 755 $? $@

$(DEST)/fastmail:	$(BIN)/fastmail-shared
			$(REG) copy -m 755 $? $@

$(DEST)/frm:		$(BIN)/frm-shared
			$(REG) copy -m 755 $? $@

$(DEST)/nfrm:		$(DEST)/frm
			$(REG) link $? $@

$(DEST)/newalias:	$(BIN)/newalias-shared
			$(REG) copy -m 755 $? $@


$(DEST)/elmstringconvert: $(BIN)/elmstringconvert-shared
			$(REG) copy -m 755 $? $@

$(LIB)/prlong:		$(BIN)/prlong-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmaliases-write: $(BIN)/elmaliases-write-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmcharset:	$(BIN)/elmcharset-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmiso2022sets:	$(BIN)/elmiso2022sets-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmconfwriter:	$(BIN)/elmconfwriter-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmrc-write:	$(BIN)/elmrc-write-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmterminal:	$(BIN)/elmterminal-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmmimetypes:	$(BIN)/elmmimetypes-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmmailinglists:	$(BIN)/elmmailinglists-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmmailservices:	$(BIN)/elmmailservices-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmunidata:	$(BIN)/elmunidata-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmbindata:	$(BIN)/elmbindata-shared
			$(REG) copy -m 755 $? $@


$(LIB)/elmlibregister:	$(BIN)/elmlibregister-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmhashmarks:	$(BIN)/elmhashmarks-shared
			$(REG) copy -m 755 $? $@

$(LIB)/elmtagfilterents: $(BIN)/elmtagfilterents-shared
			$(REG) copy -m 755 $? $@

!NO!SUBS!

	for i in $libxs
	do
		y="`echo $i|$sed 's%^../%%'`"
cat >>Makefile <<!SUBS!
$i:
	cd ..; \$(MAKE) \$(MJ) \$(MFLAGS) $y
!SUBS!
	done

else

cat >>Makefile <<'!NO!SUBS!'

$(DEST)/newmail:	$(BIN)/newmail
			$(REG) copy -m 755 $? $@

$(DEST)/elmalias:	$(BIN)/elmalias
			$(REG) copy -m 755 $? $@

$(DEST)/fastmail:	$(BIN)/fastmail
			$(REG) copy -m 755 $? $@

$(DEST)/frm:		$(BIN)/frm
			$(REG) copy -m 755 $? $@

$(DEST)/nfrm:		$(DEST)/frm
			$(REG) link $? $@

$(DEST)/newalias:	$(BIN)/newalias
			$(REG) copy -m 755 $? $@

$(DEST)/elmstringconvert: $(BIN)/elmstringconvert
			$(REG) copy -m 755 $? $@

$(LIB)/prlong:		$(BIN)/prlong
			$(REG) copy -m 755 $? $@

$(LIB)/elmaliases-write:	$(BIN)/elmaliases-write
			$(REG) copy -m 755 $? $@

$(LIB)/elmcharset:	$(BIN)/elmcharset
			$(REG) copy -m 755 $? $@

$(LIB)/elmiso2022sets:	$(BIN)/elmiso2022sets
			$(REG) copy -m 755 $? $@

$(LIB)/elmconfwriter:	$(BIN)/elmconfwriter
			$(REG) copy -m 755 $? $@

$(LIB)/elmrc-write:	$(BIN)/elmrc-write
			$(REG) copy -m 755 $? $@

$(LIB)/elmlibregister:	$(BIN)/elmlibregister
			$(REG) copy -m 755 $? $@

$(LIB)/elmterminal:	$(BIN)/elmterminal
			$(REG) copy -m 755 $? $@

$(LIB)/elmmimetypes:	$(BIN)/elmmimetypes
			$(REG) copy -m 755 $? $@

$(LIB)/elmmailinglists:	$(BIN)/elmmailinglists
			$(REG) copy -m 755 $? $@

$(LIB)/elmmailservices:	$(BIN)/elmmailservices
			$(REG) copy -m 755 $? $@

$(LIB)/elmtagfilterents: $(BIN)/elmtagfilterents
			$(REG) copy -m 755 $? $@

$(LIB)/elmunidata:	$(BIN)/elmunidata
			$(REG) copy -m 755 $? $@

$(LIB)/elmbindata:	$(BIN)/elmbindata
			$(REG) copy -m 755 $? $@

$(LIB)/elmhashmarks:	$(BIN)/elmhashmarks
			$(REG) copy -m 755 $? $@

!NO!SUBS!

fi






