/* $Id: def_readmsg.h,v 2.9 2017/05/13 17:56:11 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include <setjmp.h>

#include "mboxlib.h"
#include "misclib.h"
#include "addrlib.h"
#include "mime.h"
#include "melib.h"

enum hdr_disp_level { 
    BADLEV   =     0,
    ALL	  =	1,
    WEED  =	2,
    NONE  = 	3
};

#define FOLDER_HANDLER_magic	0xF50B

struct folder_handler {
    unsigned short            magic;   /*  FOLDER_HANDLER_magic */

    int                       num_messages;

    struct folder_routines  * handler;


    union {
	void               * dummy;
	struct fstate_data * fstate;
	struct folder_data * normal;
    } d;

};

enum message_error { error_none  = 0,
		     error_seek  = 1,
		     error_start = 2 };



typedef void free_folder_handler_f P_((struct folder_handler *H));
typedef void init_folder_handler_f P_((struct folder_handler *H));
typedef FILE * give_message_from_folder_f P_((struct folder_handler *folder,
					      int idx,
					      long *content_length,
					      enum message_error *err,
					      int print_separator,
					      char **env_buffer,
					      struct header_rec **entryret));
/* Return 1 on succeed */
typedef int parse_folder_handler_f P_((struct folder_handler *H));

#define FOLDER_ROUTINES_magic	0xF50C

struct folder_routines {
    unsigned short            magic;   /*  FOLDER_ROUTINES_magic */

    init_folder_handler_f      * init_it;
    free_folder_handler_f      * free_it;
    give_message_from_folder_f * give_message_from_it;
    parse_folder_handler_f     * parse_it;
};

/* wrapper.c */

extern struct folder_handler * malloc_folder_handler P_((struct folder_routines *routines));
extern void free_folder_handler P_((struct folder_handler **ptr));

extern FILE * give_message_from_folder P_((struct folder_handler *folder,
					   int idx,
					   long *content_length,
					   enum message_error *errret,
					   int print_separator,
					   char **env_buffer,
					   struct header_rec **entryret));
/* Return 1 on succeed */
extern  int parse_folder P_((struct folder_handler *H));


/* folder.c */

extern struct folder_handler * 
open_normal_folder P_((const char * folder_name,
		       unsigned int defaultfile_keyword,
		       unsigned int defaultfile_cmask));

extern void free_header_helper P_((struct header_rec **entry));
extern struct header_rec * malloc_header_helper P_((void));

/* fstate.c */

extern int have_fstate P_((void));
extern struct folder_handler * open_fstate P_((void));

extern int process_fstate_print P_((enum hdr_disp_level hdr_display_level,
				    int do_page_breaks, int do_raw_output));


extern long separator_helper P_((struct header_rec * entry, enum message_error *errret,
				 int print_separator,
				 char **env_buffer,FILE * F));

/* readmsg.c */

/* Return 1 on success */
extern int print_number_message P_((struct folder_handler  * folder,
				    int num,
				    enum hdr_disp_level hdr_disp_level, 
				    int do_page_breaks,
				    int do_raw_output));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
