static char rcsid[] = "@(#)$Id: wrapper.c,v 2.5 2014/11/15 11:00:26 hurtta Exp $";


/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_readmsg.h"

DEBUG_VAR(Debug,__FILE__,"readmsg");

struct folder_handler * malloc_folder_handler(routines)
     struct folder_routines *routines;
{
    struct folder_handler * ret = safe_malloc(sizeof (*ret));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)ret,sizeof (*ret));

    if (FOLDER_ROUTINES_magic != routines->magic)
	panic("READMSG PANIC",__FILE__,__LINE__,"malloc_folder_handler",
              "Bad magic number (routines)",0);

    ret->handler       = routines;
    ret->magic         = FOLDER_HANDLER_magic;
    ret->num_messages  = 0;
    
    ret->d.dummy  = NULL;
    ret->handler->init_it(ret);

    return ret;
}

void free_folder_handler(ptr)
     struct folder_handler **ptr;
{
    if (FOLDER_HANDLER_magic != (*ptr)->magic)
	panic("READMSG PANIC",__FILE__,__LINE__,"free_folder_handler",
              "Bad magic number (folder)",0);
    
    if (FOLDER_ROUTINES_magic != (*ptr)->handler->magic)
	panic("READMSG PANIC",__FILE__,__LINE__,"free_folder_handler",
              "Bad magic number (routines)",0);

    (*ptr)->handler->free_it(*ptr);
    (*ptr)->magic = 0;   /* Invalidate */

    free(*ptr);
    *ptr = NULL;
}


FILE * give_message_from_folder(folder,idx, content_length, err, 
				print_separator,
				env_buffer,entryret)
     struct folder_handler *folder;
     int idx;
     long *content_length;
     enum message_error *err;
     int print_separator;
     char **env_buffer;
     struct header_rec **entryret;
{
    if (FOLDER_HANDLER_magic != folder->magic)
	panic("READMSG PANIC",__FILE__,__LINE__,"give_message_from_folder",
              "Bad magic number (folder)",0);
	
    *content_length = 0;

    if (FOLDER_ROUTINES_magic != folder->handler->magic)
	panic("READMSG PANIC",__FILE__,__LINE__,"give_message_from_folder",
              "Bad magic number (routines)",0);


    if (entryret)
	*entryret = NULL;
    if (env_buffer)
	*env_buffer = NULL;
    if (err)
	*err = error_none;

    return folder->handler->give_message_from_it(folder,idx,content_length,
						 err,print_separator, 
						 env_buffer, entryret);
}

int parse_folder(folder) 
     struct folder_handler *folder;
{
    if (FOLDER_HANDLER_magic != folder->magic)
	panic("READMSG PANIC",__FILE__,__LINE__,"parse_folder",
              "Bad magic number (folder)",0);

    if (FOLDER_ROUTINES_magic != folder->handler->magic)
	panic("READMSG PANIC",__FILE__,__LINE__,"parse_folder",
              "Bad magic number (routines)",0);

    return folder->handler->parse_it(folder);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
